/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.state;

import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.model.MomAttributeImpl;
import se.ericsson.cello.mimparser.model.RestartTypeImpl;
import se.ericsson.cello.mimparser.state.AttributeValueState;
import se.ericsson.cello.mimparser.state.ConditionState;
import se.ericsson.cello.mimparser.state.CounterContextState;
import se.ericsson.cello.mimparser.state.CounterResetState;
import se.ericsson.cello.mimparser.state.CounterTypeState;
import se.ericsson.cello.mimparser.state.DependenciesScriptState;
import se.ericsson.cello.mimparser.state.DependenciesState;
import se.ericsson.cello.mimparser.state.DeprecatedState;
import se.ericsson.cello.mimparser.state.DisturbancesState;
import se.ericsson.cello.mimparser.state.FeatureState;
import se.ericsson.cello.mimparser.state.FilterState;
import se.ericsson.cello.mimparser.state.MomBaseState;
import se.ericsson.cello.mimparser.state.ObsoleteState;
import se.ericsson.cello.mimparser.state.PreConditionState;
import se.ericsson.cello.mimparser.state.RestartTypeState;
import se.ericsson.cello.mimparser.state.SamplingRateState;
import se.ericsson.cello.mimparser.state.ScannerState;
import se.ericsson.cello.mimparser.state.SideEffectsState;
import se.ericsson.cello.mimparser.state.SpecificationState;
import se.ericsson.cello.mimparser.state.TakesEffectState;
import se.ericsson.cello.mimparser.state.TransactionConstraintState;
import se.ericsson.cello.mimparser.state.UndefinedValueState;
import se.ericsson.cello.mimparser.state.VisibilityState;
import se.ericsson.cello.mimparser.statemachine.StateMachine;

class AttributeState
extends MomBaseState {
    private MomAttributeImpl momAttribute;
    public static final String ATTRIBUTE_TAG = "attribute";

    public AttributeState(MomAttributeImpl momAttributeImpl) {
        super(ATTRIBUTE_TAG);
        this.momAttribute = momAttributeImpl;
    }

    public void startElement(StateMachine stateMachine, String string, Attributes attributes) {
        super.startElement(stateMachine, string, this.momAttribute);
        this.handleFlagElements(string);
        if (string.equals("deprecated")) {
            stateMachine.pushState(new DeprecatedState(this.momAttribute));
        } else if (string.equals("undefinedValue")) {
            stateMachine.pushState(new UndefinedValueState(this.momAttribute));
        } else if (string.equals("disturbances")) {
            stateMachine.pushState(new DisturbancesState(this.momAttribute));
        } else if (string.equals("takesEffect")) {
            stateMachine.pushState(new TakesEffectState(this.momAttribute));
        } else if (string.equals("transactionConstraint")) {
            stateMachine.pushState(new TransactionConstraintState(this.momAttribute));
        } else if (string.equals("sideEffects")) {
            stateMachine.pushState(new SideEffectsState(this.momAttribute));
        } else if (string.equals("dependencies")) {
            stateMachine.pushState(new DependenciesState(this.momAttribute));
        } else if (string.equals("precondition")) {
            stateMachine.pushState(new PreConditionState(this.momAttribute));
        } else if (string.equals("condition")) {
            stateMachine.pushState(new ConditionState(this.momAttribute));
        } else if (string.equals("counterType")) {
            stateMachine.pushState(new CounterTypeState(this.momAttribute));
        } else if (string.equals("counterReset")) {
            stateMachine.pushState(new CounterResetState(this.momAttribute));
        } else if (string.equals("samplingRate")) {
            stateMachine.pushState(new SamplingRateState(this.momAttribute));
        } else if (string.equals("scanner")) {
            stateMachine.pushState(new ScannerState(this.momAttribute));
        } else if (string.equals("counterContext")) {
            stateMachine.pushState(new CounterContextState(this.momAttribute));
        } else if (string.equals("specification")) {
            stateMachine.pushState(new SpecificationState(this.momAttribute));
        } else if (string.equals("obsolete")) {
            stateMachine.pushState(new ObsoleteState(this.momAttribute));
        } else if (string.equals("visibility")) {
            stateMachine.pushState(new VisibilityState(this.momAttribute));
        } else if (string.equals("dependenciesScript")) {
            stateMachine.pushState(new DependenciesScriptState(this.momAttribute));
        } else if (string.equals("filter")) {
            stateMachine.pushState(new FilterState(this.momAttribute));
        } else if (string.equals("feature")) {
            stateMachine.pushState(new FeatureState(this.momAttribute));
        } else if (string.equals("value")) {
            stateMachine.pushState(new AttributeValueState(this.momAttribute));
        } else if (string.equals("restartType")) {
            RestartTypeImpl restartTypeImpl = new RestartTypeImpl(string, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.momAttribute.setRestart(restartTypeImpl);
            stateMachine.pushState(new RestartTypeState(restartTypeImpl));
        } else {
            stateMachine.getDataTypeManager().handleDataTypes(this.momAttribute, string, attributes);
        }
    }

    private void handleFlagElements(String string) {
        if (string.equals("mandatory")) {
            this.momAttribute.setMandatory();
        } else if (string.equals("noNotification")) {
            this.momAttribute.setNoNotification();
        } else if (string.equals("restricted")) {
            this.momAttribute.setRestricted();
        } else if (string.equals("readOnly")) {
            this.momAttribute.setReadOnly();
        } else if (string.equals("nonPersistent")) {
            this.momAttribute.setNonPersistent();
        } else if (string.equals("local")) {
            this.momAttribute.setLocal();
        } else if (string.equals("static")) {
            this.momAttribute.setStatic();
        } else if (string.equals("undefined")) {
            this.momAttribute.setUndefined();
        } else if (string.equals("lockBeforeModify")) {
            this.momAttribute.setLockBeforeModify();
        } else if (string.equals("interfaceOnly")) {
            this.momAttribute.setInterfaceOnly();
        } else if (string.equals("transactionRequired")) {
            this.momAttribute.setTransactionRequired();
        } else if (string.equals("indexed")) {
            this.momAttribute.setIsIndexed();
        } else if (string.equals("key")) {
            this.momAttribute.setHasKey();
        }
    }
}

