/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.state;

import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.model.MomActionImpl;
import se.ericsson.cello.mimparser.model.MomAttributeImpl;
import se.ericsson.cello.mimparser.model.MomClassImpl;
import se.ericsson.cello.mimparser.state.ActionState;
import se.ericsson.cello.mimparser.state.AttributeState;
import se.ericsson.cello.mimparser.state.DeprecatedState;
import se.ericsson.cello.mimparser.state.LockBeforeDeleteState;
import se.ericsson.cello.mimparser.state.MomBaseState;
import se.ericsson.cello.mimparser.state.NotificationTypesState;
import se.ericsson.cello.mimparser.state.TransactionConstraintState;
import se.ericsson.cello.mimparser.statemachine.StateMachine;

class ClassState
extends MomBaseState {
    private MomClassImpl momClass;
    public static final String CLASS_TAG = "class";

    public ClassState(MomClassImpl momClassImpl) {
        super(CLASS_TAG);
        this.momClass = momClassImpl;
    }

    public void startElement(StateMachine stateMachine, String string, Attributes attributes) {
        super.startElement(stateMachine, string, this.momClass);
        if (string.equals("attribute")) {
            MomAttributeImpl momAttributeImpl = new MomAttributeImpl(string, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.momClass.addAttribute(momAttributeImpl.getName(), momAttributeImpl);
            stateMachine.pushState(new AttributeState(momAttributeImpl));
        } else if (string.equals("action")) {
            MomActionImpl momActionImpl = new MomActionImpl(string, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.momClass.addAction(momActionImpl.getName(), momActionImpl);
            stateMachine.pushState(new ActionState(momActionImpl));
        } else if (string.equals("notificationTypes")) {
            stateMachine.pushState(new NotificationTypesState(this.momClass));
        } else if (string.equals("transactionConstraint")) {
            stateMachine.pushState(new TransactionConstraintState(this.momClass));
        } else if (string.equals("systemCreated")) {
            this.momClass.setSystemCreated();
        } else if (string.equals("deprecated")) {
            stateMachine.pushState(new DeprecatedState(this.momClass));
        } else if (string.equals("lockBeforeDelete")) {
            stateMachine.pushState(new LockBeforeDeleteState(this.momClass));
        } else if (string.equals("nonPersistent")) {
            this.momClass.setNonPersistent();
        } else if (string.equals("transactionRequired")) {
            this.momClass.setTransactionRequired();
        }
    }
}

