/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.command.handlers;

import se.ericsson.cello.ncli.server.command.handlers.CommandFileHandling;
import se.ericsson.cello.ncli.server.command.handlers.CommandHandler;
import se.ericsson.cello.ncli.server.command.handlers.CommandHandlingListener;
import se.ericsson.cello.ncli.server.command.result.Printout;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.exceptions.NcliException;
import se.ericsson.cello.ncli.server.logging.Log;

public class CommandFileHandler
extends CommandHandler
implements CommandFileHandling {
    private boolean firstCommandExecuted = false;
    private boolean txMode = false;

    public CommandFileHandler(CommandHandlingListener commandHandlingListener, NodeServices nodeServices) {
        super(commandHandlingListener, nodeServices);
    }

    public boolean confirmCommand(Printout printout) {
        return true;
    }

    public void sendResponse(Printout printout) {
        this.handlingListener.sendErrorResponse(printout.isErrorPrintout(), printout.getPrintoutBuf().toString());
    }

    public boolean checkCancellation() {
        return false;
    }

    public void executeCommandFromHistory(int n) {
    }

    public void closeSession(boolean bl) {
    }

    public void connect(String string) {
        Log.trace(CommandFileHandler.class, "connect(<null>)");
        try {
            this.nodeServices.init();
        }
        catch (NcliException ncliException) {
            Log.info(CommandFileHandler.class, "Could not init CS. " + ncliException.getMessage());
        }
    }

    public void disconnect() {
    }

    public void executeCommand(String string) {
        Log.trace(CommandFileHandler.class, "executeCommand(" + string + ")");
        try {
            string = string.trim();
            string = this.removeComment(string);
            if (string != "") {
                this.commandParser.executeParsableString(string, this.commandExecutor, this.nodeServices);
            }
        }
        catch (NcliException ncliException) {
            Log.info(CommandFileHandler.class, "Could not execute command: " + string);
        }
    }

    public void executeCommandFromFile(String string) throws NcliException {
        Log.trace(CommandFileHandler.class, "executeCommand(" + string + ")");
        string = string.trim();
        string = this.removeComment(string);
        if (string != "") {
            if ("TRANSACTION_MODE".equals(string) && !this.txMode && !this.firstCommandExecuted) {
                this.txMode = true;
                Log.trace(CommandFileHandler.class, "Enabling commit after each command");
            } else if (!this.firstCommandExecuted) {
                if (!this.txMode) {
                    this.nodeServices.getHardTransactionHandler().startTransaction();
                }
                this.commandParser.executeParsableString(string, this.commandExecutor, this.nodeServices);
                this.firstCommandExecuted = true;
            } else {
                this.commandParser.executeParsableString(string, this.commandExecutor, this.nodeServices);
            }
        }
    }

    public void commandCancelled(Printout printout) {
    }

    private String removeComment(String string) {
        String string2 = null;
        int n = string.indexOf("#");
        string2 = n != -1 || (n = string.indexOf("//")) != -1 ? (n != 0 ? string.substring(0, n) : "") : (string.length() == 0 ? "" : string);
        return string2;
    }

    public void endOfFile(boolean bl) {
        if (this.nodeServices.getHardTransactionHandler().isTransactionStarted()) {
            if (bl) {
                this.nodeServices.getHardTransactionHandler().hardRollbackTransaction();
            } else {
                this.nodeServices.getHardTransactionHandler().hardCommitTransaction();
            }
        }
    }
}

