/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.command.implementors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import se.ericsson.cello.ncli.server.command.handlers.CommandResultListener;
import se.ericsson.cello.ncli.server.command.implementors.CSCommand;
import se.ericsson.cello.ncli.server.command.result.PrintoutFactory;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.exceptions.NcliException;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.neal.fm.Alarm;
import se.ericsson.cello.neal.fm.AlarmCounter;

public class AlarmsCommand
extends CSCommand {
    protected boolean countFlag = false;
    protected String severityFilter = null;
    protected String causeFilter = null;
    protected boolean sortBySeverityFlag = false;
    protected boolean sortByCauseFlag = false;
    protected boolean xmlFlag = false;

    public AlarmsCommand(CommandResultListener commandResultListener, NodeServices nodeServices) {
        super(commandResultListener, nodeServices);
    }

    public void setCountFlag(boolean bl) {
        this.countFlag = bl;
    }

    public void setSeverityFilter(String string) {
        this.severityFilter = string;
    }

    public void setCauseFilter(String string) {
        this.causeFilter = string;
    }

    public void setSortByCauseFlag(boolean bl) {
        this.sortByCauseFlag = bl;
    }

    public void setSortBySeverityFlag(boolean bl) {
        this.sortBySeverityFlag = bl;
    }

    public void execute() {
        Log.trace(AlarmsCommand.class, "AlarmsCommand::execute()");
        this.printout = PrintoutFactory.createPrintout(this.xmlFlag, "ALARM");
        try {
            if (this.countFlag) {
                AlarmCounter alarmCounter = this.nodeServices.getFm().getAlarmCounter();
                this.printout.addAlarmCountString();
                this.printout.addResult(alarmCounter);
            } else {
                Alarm[] alarmArray = this.nodeServices.getFm().getAlarmList();
                ArrayList arrayList = this.filterAlarmList(alarmArray);
                Comparator comparator = null;
                comparator = this.sortBySeverityFlag ? new SeverityComparator() : (this.sortByCauseFlag ? new CauseCodeComparator() : new EventTimeComparator());
                Collections.sort(arrayList, comparator);
                this.printout.addAlarmsString();
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.printout.addResult((Alarm)arrayList.get(i));
                }
            }
        }
        catch (NcliException ncliException) {
            this.printout.addErrorText(ncliException);
        }
        this.printout.addEndText();
        this.sendResponse();
    }

    protected ArrayList filterAlarmList(Alarm[] alarmArray) {
        String string;
        int n;
        ArrayList<Alarm> arrayList = new ArrayList<Alarm>(0);
        if (alarmArray == null || alarmArray.length <= 0) {
            return arrayList;
        }
        for (int i = 0; i < alarmArray.length; ++i) {
            arrayList.add(alarmArray[i]);
        }
        if (this.severityFilter != null) {
            ArrayList<Alarm> arrayList2 = new ArrayList<Alarm>(0);
            for (n = 0; n < arrayList.size(); ++n) {
                string = ((Alarm)arrayList.get(n)).getPerceivedSeverity();
                if (!string.equalsIgnoreCase(this.severityFilter)) continue;
                arrayList2.add(alarmArray[n]);
            }
            arrayList = arrayList2;
        }
        if (this.causeFilter != null) {
            ArrayList<Alarm> arrayList3 = new ArrayList<Alarm>(0);
            for (n = 0; n < arrayList.size(); ++n) {
                string = Integer.toString(((Alarm)arrayList.get(n)).getProbableCauseDef());
                if (!string.equalsIgnoreCase(this.causeFilter)) continue;
                arrayList3.add(alarmArray[n]);
            }
            arrayList = arrayList3;
        }
        return arrayList;
    }

    protected void setXmlFlag(boolean bl) {
        this.xmlFlag = bl;
    }

    class CauseCodeComparator
    implements Comparator {
        CauseCodeComparator() {
        }

        public int compare(Object object, Object object2) {
            Alarm alarm = (Alarm)object;
            Alarm alarm2 = (Alarm)object2;
            if (alarm.getProbableCauseDef() == alarm2.getProbableCauseDef()) {
                return alarm.getEventTime().compareTo((Object)alarm2.getEventTime());
            }
            if (alarm.getProbableCauseDef() > alarm2.getProbableCauseDef()) {
                return 1;
            }
            return -1;
        }
    }

    class SeverityComparator
    implements Comparator {
        SeverityComparator() {
        }

        public int compare(Object object, Object object2) {
            Alarm alarm = (Alarm)object;
            Alarm alarm2 = (Alarm)object2;
            if (alarm.getPerceivedSeverityDef() == alarm2.getPerceivedSeverityDef()) {
                return alarm.getEventTime().compareTo((Object)alarm2.getEventTime());
            }
            if (alarm.getPerceivedSeverityDef() > alarm2.getPerceivedSeverityDef()) {
                return 1;
            }
            return -1;
        }
    }

    class EventTimeComparator
    implements Comparator {
        EventTimeComparator() {
        }

        public int compare(Object object, Object object2) {
            Alarm alarm = (Alarm)object;
            Alarm alarm2 = (Alarm)object2;
            int n = alarm.getEventTime().compareTo((Object)alarm2.getEventTime());
            if (n != 0) {
                return n;
            }
            return alarm.getAlarmId().compareTo(alarm2.getAlarmId());
        }
    }
}

