/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.completion;

import java.util.StringTokenizer;
import se.ericsson.cello.ncli.server.completion.BaseCompleter;
import se.ericsson.cello.ncli.server.completion.Completer;
import se.ericsson.cello.ncli.server.completion.CompleterFactory;
import se.ericsson.cello.ncli.server.completion.CsCmdCompleter;
import se.ericsson.cello.ncli.server.completion.completers.CmdSearchCompleter;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.logging.Log;

public class SearchExpressionCompleter
extends BaseCompleter {
    private String moType = null;

    public SearchExpressionCompleter(NodeServices nodeServices) {
        super(nodeServices);
    }

    public void completeString(String string) {
        Log.trace(CmdSearchCompleter.class, "completeString(" + string + ")");
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        if (n <= 0) {
            this.completeMoAddress("", stringTokenizer, string);
        } else if (n == 1) {
            String string2 = stringTokenizer.nextToken();
            this.completeMoAddress(string2, stringTokenizer, string);
        } else if (n >= 2) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("-g")) {
                this.completeMoAddress(string3, stringTokenizer, string);
            } else {
                string3 = stringTokenizer.nextToken();
                this.completeMoType(string3, stringTokenizer, string);
            }
        }
    }

    protected boolean completeMoAddress(String string, StringTokenizer stringTokenizer, String string2) {
        Log.trace(CmdSearchCompleter.class, "completeMoAddress() currToken='" + string + "', aStringToComplete ='" + string2 + "'");
        CsCmdCompleter csCmdCompleter = new CsCmdCompleter(this.nodeServices){};
        boolean bl = csCmdCompleter.completeMoAddress(string, stringTokenizer, string2);
        if (bl) {
            this.completedString = csCmdCompleter.getCompletedString();
            this.completionOptionList = csCmdCompleter.getCompletionOptionList();
            return true;
        }
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
        } else if (string2.endsWith(" ")) {
            string = "";
        } else {
            return false;
        }
        return this.completeMoType(string, stringTokenizer, string2);
    }

    protected boolean completeMoType(String string, StringTokenizer stringTokenizer, String string2) {
        Log.trace(CmdSearchCompleter.class, "completeMoType() currToken='" + string + "', aStringToComplete ='" + string2 + "'");
        this.moType = string;
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            return this.completeAttrName(string, stringTokenizer, string2);
        }
        if (string2.endsWith(" ") && string.length() != 0) {
            string = "";
            return this.completeAttrName(string, stringTokenizer, string2);
        }
        Completer completer = CompleterFactory.createMoTypeCompleter(this.nodeServices);
        completer.completeString(string);
        int n = string2.lastIndexOf(string);
        String string3 = string2.substring(0, n);
        this.completedString = string3.concat(completer.getCompletedString());
        this.completionOptionList = completer.getCompletionOptionList();
        return true;
    }

    public boolean completeAttrName(String string, StringTokenizer stringTokenizer, String string2) {
        Log.trace(CmdSearchCompleter.class, "completeAttrName() currToken='" + string + "', aStringToComplete ='" + string2 + "'");
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            return this.completeAttrName(string, stringTokenizer, string2);
        }
        String string3 = string;
        if (string2.endsWith(" ")) {
            string3 = "";
        }
        Completer completer = CompleterFactory.createAttrNameCompleter(this.nodeServices, this.moType, true, true);
        int n = string2.lastIndexOf(string3);
        String string4 = string2.substring(0, n);
        completer.completeString(string3);
        String string5 = completer.getCompletedString();
        if (string5.endsWith(" ")) {
            string5 = string5.substring(0, string5.length() - 1);
        }
        if (completer.getCompletionOptionList().size() == 0) {
            this.completedString = string4.concat(string5);
        } else if (completer.getCompletionOptionList().size() == 1) {
            this.completedString = string4.concat(string5).concat(" ");
            this.completionOptionList.clear();
        } else if (completer.getCompletionOptionList().size() > 1) {
            this.completedString = string4.concat(string5);
            this.completionOptionList = completer.getCompletionOptionList();
        }
        return true;
    }
}

