/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.completion.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import se.ericsson.cello.mimparser.MoRef;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.mimparser.MomCorbaTypeAttribute;
import se.ericsson.cello.mimparser.MomEntity;
import se.ericsson.cello.mimparser.MomEnumRef;
import se.ericsson.cello.mimparser.MomSequence;
import se.ericsson.cello.mimparser.MomStructMember;
import se.ericsson.cello.mimparser.MomStructRef;
import se.ericsson.cello.ncli.server.completion.completers.MoAddressCompleter;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.neal.cm.Mo;

public class CompletionHelper {
    public static boolean startsWithUpperCase(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        String string2 = string.substring(0, 1);
        return string2.equals(string2.toUpperCase());
    }

    public static String switchStartCase(String string) {
        String string2 = "";
        if (string == null) {
            return string;
        }
        if (string.length() == 0) {
            return string;
        }
        string2 = CompletionHelper.startsWithUpperCase(string) ? string.substring(0, 1).toLowerCase() : string.substring(0, 1).toUpperCase();
        return string2.concat(string.substring(1, string.length()));
    }

    public static String getCommonStartStr(ArrayList arrayList, String string) {
        Log.trace(CompletionHelper.class, "getCommonStartStr()");
        Log.trace(CompletionHelper.class, "cmd = " + string);
        if (arrayList == null || arrayList.size() == 0 || string == null) {
            return "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        int n = stringTokenizer.countTokens();
        Log.trace(CompletionHelper.class, "nrOfTokens = " + n);
        if (n <= 1 || n >= 3) {
            return CompletionHelper.getCommonStartStrForSubset(arrayList);
        }
        return MoAddressCompleter.getCommonStartStrForMo(arrayList, string);
    }

    public static String getCommonStartStrForSubset(ArrayList arrayList) {
        Log.trace(CompletionHelper.class, "getCommonStartStrForSubset()");
        if (arrayList == null || arrayList.size() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = (String)arrayList.get(0);
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append(string.substring(i, i + 1));
            for (int j = 0; j < arrayList.size(); ++j) {
                String string2 = (String)arrayList.get(j);
                if (string2.startsWith(stringBuffer.toString())) continue;
                return stringBuffer.deleteCharAt(stringBuffer.length() - 1).toString();
            }
        }
        return stringBuffer.toString();
    }

    public static String getCommonStartStrForSubsetIgnoreCase(ArrayList arrayList) {
        Log.trace(CompletionHelper.class, "getCommonStartStrForSubset()");
        if (arrayList == null || arrayList.size() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = (String)arrayList.get(0);
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append(string.substring(i, i + 1));
            for (int j = 0; j < arrayList.size(); ++j) {
                String string2 = (String)arrayList.get(j);
                if (string2.toLowerCase().startsWith(stringBuffer.toString().toLowerCase())) continue;
                return stringBuffer.deleteCharAt(stringBuffer.length() - 1).toString();
            }
        }
        return stringBuffer.toString();
    }

    public static void putMatchingRdnInList(String string, Mo[] moArray, ArrayList arrayList) {
        if (string == null || moArray == null || arrayList == null) {
            return;
        }
        for (int i = 0; i < moArray.length; ++i) {
            String string2 = moArray[i].getType().concat("=").concat(moArray[i].getName());
            if (string.length() != 0 && !string2.toLowerCase().startsWith(string.toLowerCase())) continue;
            arrayList.add(string2);
        }
    }

    public static void putMatchingMomEntityNameInList(String string, Iterator iterator, ArrayList arrayList) {
        if (string == null || iterator == null || arrayList == null) {
            return;
        }
        while (iterator.hasNext()) {
            String string2 = ((MomEntity)iterator.next()).getName();
            if (string.length() != 0 && !string2.toLowerCase().startsWith(string.toLowerCase())) continue;
            arrayList.add(string2);
        }
    }

    public static String formatTypeAndDefaultValue(MomEntity momEntity) {
        if (momEntity == null) {
            return null;
        }
        if (momEntity instanceof MomCorbaTypeAttribute) {
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            Object object = ((MomCorbaTypeAttribute)momEntity).getDefault();
            String string2 = null;
            if (object != null) {
                string2 = object.toString();
            }
            if ((string = momEntity.getXmlType()).equals("string")) {
                stringBuffer.append("(String)");
                if (string2 != null) {
                    if (string2.indexOf("\"") < 0) {
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append(string2);
                    if (string2.indexOf("\"") < 0) {
                        stringBuffer.append("\"");
                    }
                }
            } else if (string.equals("long")) {
                stringBuffer.append("(Integer)");
                if (string2 != null) {
                    stringBuffer.append(string2);
                }
            } else if (string.equals("boolean")) {
                stringBuffer.append("(Boolean)");
                if (string2 != null) {
                    stringBuffer.append(string2);
                }
            } else if (string.equals("float")) {
                stringBuffer.append("(Float)");
                if (string2 != null) {
                    stringBuffer.append(string2);
                }
            } else if (string.equals("longlong")) {
                stringBuffer.append("(Long)");
                if (string2 != null) {
                    stringBuffer.append(string2);
                }
            } else {
                return null;
            }
            return stringBuffer.toString();
        }
        if (momEntity instanceof MomStructRef) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{");
            Iterator iterator = ((MomStructRef)momEntity).getStruct().getMembers();
            while (iterator.hasNext()) {
                MomStructMember momStructMember = (MomStructMember)iterator.next();
                stringBuffer.append(" " + momStructMember.getName());
                stringBuffer.append("=");
                String string = CompletionHelper.formatTypeAndDefaultValue(momStructMember.getValue());
                if (string == null) continue;
                stringBuffer.append(string);
            }
            stringBuffer.append(" }");
            return stringBuffer.toString();
        }
        if (momEntity instanceof MomSequence) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = ((MomSequence)momEntity).getType().getXmlType();
            stringBuffer.append("(");
            if (string.equals("class") || string.equals("moRef")) {
                stringBuffer.append("Reference");
            } else if (string.equals("struct") || string.equals("structRef")) {
                stringBuffer.append("Struct");
            }
            if (string.equals("string")) {
                stringBuffer.append("String");
            } else if (string.equals("long")) {
                stringBuffer.append("Integer");
            } else if (string.equals("boolean")) {
                stringBuffer.append("Boolean");
            } else if (string.equals("float")) {
                stringBuffer.append("Float");
            } else if (string.equals("longlong")) {
                stringBuffer.append("long");
            }
            stringBuffer.append(")");
            stringBuffer.append("{");
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
        if (momEntity instanceof MomEnumRef) {
            StringBuffer stringBuffer = new StringBuffer();
            Integer n = ((MomEnumRef)momEntity).getDefault();
            String string = null;
            if (n != null) {
                string = ((Object)n).toString();
            }
            stringBuffer.append("(Integer)");
            if (string != null) {
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
        if (momEntity instanceof MomClass || momEntity instanceof MoRef) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(Reference)");
            return stringBuffer.toString();
        }
        return null;
    }

    public static String resolveLdnFromGroup(String string, NodeServices nodeServices) {
        if (string.equalsIgnoreCase("-group")) {
            String string2 = nodeServices.getMoGroupHandler().getDefaultGroup().getTopMostMemberLdn();
            if (string2 != null) {
                return string2;
            }
        } else {
            try {
                String string3;
                int[] nArray = nodeServices.getAddressResolver().resolveIndexFromRange(string, Integer.MAX_VALUE);
                if (nArray != null && (string3 = nodeServices.getMoGroupHandler().getDefaultGroup().getFirstValidMemberLdnInRange(nArray)) != null) {
                    return string3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String stripLeadingAndTrailingQuotes(String string) {
        if (string.startsWith("\"")) {
            string = string.substring(1, string.length());
        }
        if (string.endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }
}

