/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.cs.transaction;

import se.ericsson.cello.ncli.server.cs.transaction.HardTransactionHandling;
import se.ericsson.cello.neal.cm.CmException;
import se.ericsson.cello.neal.cm.CmService;
import se.ericsson.cello.neal.cm.Transaction;

public class TransactionHandler
implements HardTransactionHandling {
    private Transaction tx = null;
    protected boolean controlled = false;
    private CmService cm = null;

    public TransactionHandler(CmService cmService) {
        this.cm = cmService;
    }

    public void startTransaction() {
        this.startTransaction(3600000);
    }

    public void startTransaction(int n) {
        this.tx = this.cm.createTransaction(n);
        this.controlled = true;
    }

    public void softCommitTransaction() {
        if (!this.controlled && this.tx != null) {
            try {
                this.tx.commit();
                this.tx.end();
            }
            catch (CmException cmException) {
                throw cmException;
            }
            finally {
                this.tx = null;
            }
        }
    }

    public Transaction getCurrentTransaction() {
        return this.tx;
    }

    public Transaction getTransaction() {
        return this.getTransaction(3600000);
    }

    public Transaction getTransaction(int n) {
        if (this.tx == null) {
            this.tx = this.cm.createTransaction(n);
            this.controlled = false;
        }
        return this.tx;
    }

    public void softRollbackTransaction() {
        if (!this.controlled && this.tx != null) {
            try {
                this.tx.rollback();
                this.tx.end();
            }
            catch (CmException cmException) {
                throw cmException;
            }
            finally {
                this.tx = null;
            }
        }
    }

    public void hardCommitTransaction() {
        this.controlled = false;
        this.softCommitTransaction();
    }

    public Transaction getNullTransaction() {
        return this.cm.createNullTransaction();
    }

    public boolean isTransactionStarted() {
        return this.tx != null;
    }

    public boolean isControlled() {
        return this.controlled;
    }

    public void hardRollbackTransaction() {
        this.controlled = false;
        this.softRollbackTransaction();
    }
}

