/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.session;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.ncli.server.session.SessionData;
import se.ericsson.cello.ncli.server.session.SessionDataManager;

public class SessionDataManagerImpl
implements SessionDataManager {
    private long sessionStorageTime;
    private Map sessionStorage;
    private SessionDataSupervisor sessionDataSupervisor = null;
    static /* synthetic */ Class class$se$ericsson$cello$ncli$server$session$SessionDataManagerImpl$SessionDataSupervisor;

    public SessionDataManagerImpl(long l) {
        this.sessionStorageTime = l;
        this.sessionStorage = Collections.synchronizedMap(new HashMap());
    }

    public SessionData get(String string) {
        return (SessionData)this.sessionStorage.remove(string);
    }

    public void delete(String string) {
        this.sessionStorage.remove(string);
    }

    public void clean() {
        this.sessionStorage.clear();
    }

    public void save(String string, SessionData sessionData) {
        this.sessionStorage.put(string, sessionData);
    }

    Map getSessionStorage() {
        return this.sessionStorage;
    }

    public void startManager(long l) {
        if (this.serviceEnabled()) {
            if (null == this.sessionDataSupervisor) {
                this.sessionDataSupervisor = new SessionDataSupervisor();
                this.sessionDataSupervisor.setPollInterval(l);
                this.sessionDataSupervisor.setName("NcliSessionDataSupervisor");
                this.sessionDataSupervisor.start();
            }
            Log.trace(SessionDataManagerImpl.class, "Starting supervisor with poll intervall " + l + " ms");
        }
    }

    public void stopManager() {
        if (this.serviceEnabled()) {
            this.sessionDataSupervisor.setKeepAlive(false);
            this.sessionDataSupervisor.interrupt();
            this.sessionDataSupervisor = null;
        }
    }

    public boolean isManagerStarted() {
        return null != this.sessionDataSupervisor;
    }

    private boolean serviceEnabled() {
        return this.sessionStorageTime > 0L;
    }

    class SessionDataSupervisor
    extends Thread {
        private long pollInterval;
        private boolean keepAlive = true;

        SessionDataSupervisor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.keepAlive) {
                Log.debug(class$se$ericsson$cello$ncli$server$session$SessionDataManagerImpl$SessionDataSupervisor == null ? SessionDataManagerImpl.class$("se.ericsson.cello.ncli.server.session.SessionDataManagerImpl$SessionDataSupervisor") : class$se$ericsson$cello$ncli$server$session$SessionDataManagerImpl$SessionDataSupervisor, "Start supervising");
                Map map = SessionDataManagerImpl.this.sessionStorage;
                synchronized (map) {
                    Iterator iterator = SessionDataManagerImpl.this.sessionStorage.keySet().iterator();
                    ArrayList arrayList = new ArrayList();
                    if (iterator != null) {
                        Log.debug(class$se$ericsson$cello$ncli$server$session$SessionDataManagerImpl$SessionDataSupervisor == null ? SessionDataManagerImpl.class$("se.ericsson.cello.ncli.server.session.SessionDataManagerImpl$SessionDataSupervisor") : class$se$ericsson$cello$ncli$server$session$SessionDataManagerImpl$SessionDataSupervisor, "keys != null");
                        while (iterator.hasNext()) {
                            Object k = iterator.next();
                            SessionData sessionData = (SessionData)SessionDataManagerImpl.this.sessionStorage.get(k);
                            if (this.isDataStillValid(sessionData.getTimestamp())) continue;
                            arrayList.add(k);
                            Log.debug(class$se$ericsson$cello$ncli$server$session$SessionDataManagerImpl$SessionDataSupervisor == null ? SessionDataManagerImpl.class$("se.ericsson.cello.ncli.server.session.SessionDataManagerImpl$SessionDataSupervisor") : class$se$ericsson$cello$ncli$server$session$SessionDataManagerImpl$SessionDataSupervisor, "Session data for user " + k + " has expired");
                        }
                        for (int i = 0; i < arrayList.size(); ++i) {
                            SessionDataManagerImpl.this.sessionStorage.remove(arrayList.get(i));
                            Log.debug(class$se$ericsson$cello$ncli$server$session$SessionDataManagerImpl$SessionDataSupervisor == null ? SessionDataManagerImpl.class$("se.ericsson.cello.ncli.server.session.SessionDataManagerImpl$SessionDataSupervisor") : class$se$ericsson$cello$ncli$server$session$SessionDataManagerImpl$SessionDataSupervisor, "Removing data: " + arrayList.get(i));
                        }
                    }
                }
                try {
                    Thread.sleep(this.pollInterval);
                    Log.debug(class$se$ericsson$cello$ncli$server$session$SessionDataManagerImpl$SessionDataSupervisor == null ? SessionDataManagerImpl.class$("se.ericsson.cello.ncli.server.session.SessionDataManagerImpl$SessionDataSupervisor") : class$se$ericsson$cello$ncli$server$session$SessionDataManagerImpl$SessionDataSupervisor, "Thread has woken up");
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private boolean isDataStillValid(long l) {
            return l + SessionDataManagerImpl.this.sessionStorageTime * 1000L > Calendar.getInstance().getTimeInMillis();
        }

        public void setKeepAlive(boolean bl) {
            this.keepAlive = bl;
        }

        public void setPollInterval(long l) {
            this.pollInterval = l;
        }
    }
}

