/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jsse;

import com.ibm.j9.jsse.support.Msg;
import com.ibm.j9.ssl.J9HandshakeException;
import com.ibm.j9.ssl.J9SSLContext;
import com.ibm.j9.ssl.J9SSLSessionContext;
import com.ibm.j9.ssl.SessionState;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public class J9JSSESSLContext
implements J9SSLContext {
    private final X509TrustManager trustManager;
    private final X509KeyManager keyManager;
    private final SecureRandom randomSource;
    private final J9SSLSessionContext sessionTable;
    private boolean sessionCreationAllowed = true;

    public SessionState createSession(String hostName) throws J9HandshakeException {
        if (this.getSessionCreationEnabled()) {
            return this.sessionTable.createSession(hostName);
        }
        throw new J9HandshakeException(Msg.getString("K03b1"));
    }

    public SessionState createSession(byte[] sessionID) throws J9HandshakeException {
        if (this.getSessionCreationEnabled()) {
            return this.sessionTable.createSession(sessionID);
        }
        throw new J9HandshakeException(Msg.getString("K03b1"));
    }

    J9JSSESSLContext(X509TrustManager manager, SecureRandom random, J9SSLSessionContext sessionTable) {
        this.keyManager = null;
        this.trustManager = manager;
        this.randomSource = random;
        this.sessionTable = sessionTable;
    }

    J9JSSESSLContext(X509KeyManager keyManager, X509TrustManager manager, SecureRandom random, J9SSLSessionContext sessionTable) {
        this.keyManager = keyManager;
        this.trustManager = manager;
        this.randomSource = random;
        this.sessionTable = sessionTable;
    }

    public void getRandomBytes(byte[] buffer) {
        this.randomSource.nextBytes(buffer);
    }

    public void checkServerTrusted(com.ibm.oti.security.provider.X509Certificate[] certChain) throws CertificateException {
        this.trustManager.checkServerTrusted((X509Certificate[])certChain, certChain[0].getPublicKey().getAlgorithm());
    }

    public void checkClientTrusted(com.ibm.oti.security.provider.X509Certificate[] certChain) throws CertificateException {
        this.trustManager.checkClientTrusted((X509Certificate[])certChain, certChain[0].getPublicKey().getAlgorithm());
    }

    public void addSession(SessionState session) {
        this.sessionTable.addSession(session);
    }

    public void removeSession(SessionState session) {
        this.sessionTable.removeSession(session);
    }

    public SessionState getSession(String hostName) {
        return this.sessionTable.getSession(hostName);
    }

    public SessionState getSession(byte[] sessionID) {
        return this.sessionTable.getSession(sessionID);
    }

    public J9SSLSessionContext getSessionContext() {
        return this.sessionTable;
    }

    public boolean getSessionCreationEnabled() {
        return this.sessionCreationAllowed;
    }

    public void setEnableSessionCreation(boolean sessionCreationAllowed) {
        this.sessionCreationAllowed = sessionCreationAllowed;
    }

    public String chooseClientAlias(String[] keyAlgorithmNames, Principal[] trustedIssuers) {
        if (this.keyManager == null) {
            return null;
        }
        return this.keyManager.chooseClientAlias(keyAlgorithmNames, trustedIssuers, null);
    }

    public String chooseServerAlias(String keyAlgorithmName, Principal[] trustedIssuers) {
        if (this.keyManager == null) {
            return null;
        }
        return this.keyManager.chooseServerAlias(keyAlgorithmName, trustedIssuers, null);
    }

    public X509Certificate[] getCertificateChain(String alias) {
        if (alias == null) {
            return null;
        }
        return this.keyManager.getCertificateChain(alias);
    }

    public RSAPrivateCrtKey getPrivateKey(String alias) {
        if (alias == null) {
            return null;
        }
        PrivateKey result = this.keyManager.getPrivateKey(alias);
        if (result instanceof RSAPrivateCrtKey) {
            return (RSAPrivateCrtKey)result;
        }
        return null;
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }
}

