/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jsse;

import com.ibm.j9.jsse.J9JSSESSLContext;
import com.ibm.j9.jsse.SSLServerSocketImpl;
import com.ibm.j9.jsse.support.Msg;
import com.ibm.j9.ssl.CipherSpec;
import com.ibm.j9.ssl.J9SSLContext;
import com.ibm.j9.ssl.J9SSLSessionContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SSLServerSocketFactory
extends javax.net.ssl.SSLServerSocketFactory {
    private static String DFLT_PROVIDER_TRUSTMGR_ALG = "IBMJ9X509";
    private J9SSLContext context;

    public SSLServerSocketFactory() {
        J9SSLSessionContext sessionContextImpl = new J9SSLSessionContext();
        X509TrustManager tm = null;
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(DFLT_PROVIDER_TRUSTMGR_ALG);
            tmf.init((KeyStore)null);
            TrustManager[] candidates = tmf.getTrustManagers();
            tm = (X509TrustManager)candidates[0];
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError(Msg.getString("K03b8", e.getMessage()));
        }
        catch (KeyStoreException e) {
            throw new InternalError(Msg.getString("K03b9", e.getMessage()));
        }
        SecureRandom randomSource = new SecureRandom();
        this.context = new J9JSSESSLContext(tm, randomSource, sessionContextImpl);
    }

    public SSLServerSocketFactory(J9SSLContext sslContext) {
        this.context = sslContext;
    }

    public String[] getDefaultCipherSuites() {
        return (String[])CipherSpec.SUPPORTED_SPEC_IDS.clone();
    }

    public String[] getSupportedCipherSuites() {
        return (String[])CipherSpec.SUPPORTED_SPEC_IDS.clone();
    }

    public ServerSocket createServerSocket() throws IOException {
        return new SSLServerSocketImpl(this.context, this.getDefaultCipherSuites());
    }

    public ServerSocket createServerSocket(int localPort) throws IOException {
        return new SSLServerSocketImpl(localPort, this.context, this.getDefaultCipherSuites());
    }

    public ServerSocket createServerSocket(int localPort, int connectionBackLog) throws IOException {
        return new SSLServerSocketImpl(localPort, this.context, this.getDefaultCipherSuites(), connectionBackLog);
    }

    public ServerSocket createServerSocket(int localPort, int connectionBackLog, InetAddress localAddress) throws IOException {
        return new SSLServerSocketImpl(localPort, this.context, this.getDefaultCipherSuites(), connectionBackLog, localAddress);
    }
}

