/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jsse;

import com.ibm.oti.security.provider.X509CertImpl;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Date;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.CertificateException;
import javax.security.cert.CertificateExpiredException;
import javax.security.cert.X509Certificate;

public final class X509CertificateJSSE
extends X509Certificate {
    private final X509CertImpl impl;

    public X509CertificateJSSE(X509CertImpl impl) {
        this.impl = impl;
    }

    public void checkValidity() throws CertificateExpiredException, javax.security.cert.CertificateNotYetValidException {
        try {
            this.impl.checkValidity();
        }
        catch (java.security.cert.CertificateExpiredException e) {
            throw new CertificateExpiredException(e.getMessage());
        }
        catch (CertificateNotYetValidException e) {
            throw new javax.security.cert.CertificateNotYetValidException(e.getMessage());
        }
    }

    public void checkValidity(Date date) throws CertificateExpiredException, javax.security.cert.CertificateNotYetValidException {
        try {
            this.impl.checkValidity(date);
        }
        catch (java.security.cert.CertificateExpiredException e) {
            throw new CertificateExpiredException(e.getMessage());
        }
        catch (CertificateNotYetValidException e) {
            throw new javax.security.cert.CertificateNotYetValidException(e.getMessage());
        }
    }

    public int getVersion() {
        return this.impl.getVersion() - 1;
    }

    public BigInteger getSerialNumber() {
        return this.impl.getSerialNumber();
    }

    public Principal getIssuerDN() {
        return this.impl.getIssuerDN();
    }

    public Principal getSubjectDN() {
        return this.impl.getSubjectDN();
    }

    public Date getNotBefore() {
        return this.impl.getNotBefore();
    }

    public Date getNotAfter() {
        return this.impl.getNotAfter();
    }

    public String getSigAlgName() {
        return this.impl.getSigAlgName();
    }

    public String getSigAlgOID() {
        return this.impl.getSigAlgOID();
    }

    public byte[] getSigAlgParams() {
        return this.impl.getSigAlgParams();
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        try {
            return this.impl.getEncoded();
        }
        catch (java.security.cert.CertificateEncodingException e) {
            throw new CertificateEncodingException(e.getMessage());
        }
    }

    public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        try {
            this.impl.verify(publicKey);
        }
        catch (java.security.cert.CertificateException e) {
            throw new CertificateException(e.getMessage());
        }
    }

    public void verify(PublicKey publicKey, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        try {
            this.impl.verify(publicKey, sigProvider);
        }
        catch (java.security.cert.CertificateException e) {
            throw new CertificateException(e.getMessage());
        }
    }

    public String toString() {
        return this.impl.toString();
    }

    public PublicKey getPublicKey() {
        return this.impl.getPublicKey();
    }
}

