/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.common;

import java.io.IOException;
import java.util.ArrayList;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.jar.JarFileManager;
import se.ericsson.crbs.omf.aue.common.jar.JarFileManagerFactory;
import se.ericsson.crbs.omf.aue.common.jar.XmlHolder;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;

public class MainAueHelper {
    private static final Class THIS_CLASS = MainAueHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    public static final String RESET_XML_FILE_NAME = "reset.xml";
    public static final String OMF_NAME_PREFIX = "OMF";
    private final JarFileManager jarFileManager;

    public MainAueHelper(String propertiesFile) throws CrbsAueException {
        try {
            this.jarFileManager = JarFileManagerFactory.getInstance().getJarFileManager(propertiesFile);
        }
        catch (IOException ioe) {
            String errorMsg = "Could not read the JAR file";
            logger.traceDebug(THIS_CLASS, AueUtil.appendReason("Could not read the JAR file", ioe));
            throw new CrbsAueException("Could not read the JAR file", ioe);
        }
    }

    public XmlHolder[] getModificationXmlHolders() throws IOException {
        logger.traceEnter(THIS_CLASS, "getModificationXmlHolders()");
        ArrayList<XmlHolder> xmlHolderList = new ArrayList<XmlHolder>();
        XmlHolder[] allXmlHolders = this.jarFileManager.getXmlHolders();
        for (int i = 0; i < allXmlHolders.length; ++i) {
            if (allXmlHolders[i].getPath().endsWith(RESET_XML_FILE_NAME)) continue;
            logger.traceGeneral(THIS_CLASS, "Found modification XML file: " + AueUtil.doubleQuote(allXmlHolders[i].getPath()));
            xmlHolderList.add(allXmlHolders[i]);
        }
        XmlHolder[] modificationFilesXmlHolders = new XmlHolder[xmlHolderList.size()];
        xmlHolderList.toArray(modificationFilesXmlHolders);
        logger.traceReturn(THIS_CLASS, "getModificationXmlHolders()");
        return modificationFilesXmlHolders;
    }

    public XmlHolder getResetXmlHolder() {
        logger.traceEnter(THIS_CLASS, "getResetXmlHolder()");
        XmlHolder[] allXmlHolders = this.jarFileManager.getXmlHolders();
        XmlHolder resetXmlHolder = null;
        for (int i = 0; i < allXmlHolders.length; ++i) {
            if (!allXmlHolders[i].getPath().endsWith(RESET_XML_FILE_NAME)) continue;
            resetXmlHolder = allXmlHolders[i];
            logger.traceGeneral(THIS_CLASS, "Found reset XML file: " + AueUtil.doubleQuote(resetXmlHolder.getPath()));
            break;
        }
        logger.traceReturn(THIS_CLASS, "getResetXmlHolder()");
        return resetXmlHolder;
    }
}

