/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.corba;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.net.ssl.SSLContext;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.ORB;
import se.ericsson.security.corba.PortResourceClientProxy;
import se.ericsson.security.corba.interceptor.TraceErrorLogger;

public class ORBInit {
    private static TraceErrorLogger logger = new TraceErrorLogger();
    private static final Class thisClass;
    private static String CorbaSecurity;
    private static final String SecurityConfigFile;
    static /* synthetic */ Class class$se$ericsson$security$corba$ORBInit;

    public static void setCorbaSecurityState(String string) {
        CorbaSecurity = string;
    }

    public static ORB getORB() throws INITIALIZE {
        return ORB.init((String[])null, (Properties)ORBInit.getOrbProperties());
    }

    public static Properties getOrbProperties() throws INITIALIZE {
        Properties properties = ORBInit.getProperties("orb.properties");
        Properties properties2 = ORBInit.loadExternalProperties();
        Properties properties3 = System.getProperties();
        Properties[] propertiesArray = new Properties[]{properties3, properties2, properties};
        String string = ORBInit.getProperty("se.ericsson.security.keystoretype", propertiesArray);
        properties = ORBInit.isServer() ? ORBInit.getServerProperties(properties, string) : ORBInit.getClientProperties(properties);
        if (ORBInit.getBoolean("se.ericsson.security.corba.networklistener", propertiesArray)) {
            properties.setProperty("org.omg.PortableInterceptor.ORBInitializerClass.NetworkListenerInit", "se.ericsson.security.corba.interceptor.NetworkListenerInit");
            properties.setProperty("jacorb.net.tcp_listener", "se.ericsson.security.corba.NetworkListener");
            properties.setProperty("jacorb.security.ssl.ssl_listener", "se.ericsson.security.corba.NetworkListener");
        }
        properties.setProperty("jacorb.transport.client.selector", "se.ericsson.security.corba.interceptor.CppProfileSelector");
        properties = ORBInit.mergeProperties(properties, properties2);
        properties = ORBInit.mergeSystemProperties(properties);
        ORBInit.traceOrbProperties(properties);
        return properties;
    }

    private static void traceOrbProperties(Properties properties) {
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>(properties);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Listing ORB properties\n");
        stringBuffer.append("----------------------\n");
        Iterator iterator = treeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuffer.append(entry.getKey()).append(" = ");
            stringBuffer.append(entry.getValue()).append("\n");
        }
        stringBuffer.append("----------------------\n");
        logger.trace(1, thisClass, stringBuffer.toString());
        treeMap.clear();
    }

    private static Properties getProperties(String string) throws INITIALIZE {
        Properties properties = new Properties();
        InputStream inputStream = (class$se$ericsson$security$corba$ORBInit == null ? (class$se$ericsson$security$corba$ORBInit = ORBInit.class$("se.ericsson.security.corba.ORBInit")) : class$se$ericsson$security$corba$ORBInit).getResourceAsStream(string);
        if (inputStream == null) {
            throw new INITIALIZE("Could not find properties " + string);
        }
        ORBInit.loadAndClose(properties, inputStream);
        return properties;
    }

    private static Properties mergeProperties(Properties properties, Properties properties2) {
        Enumeration<?> enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            properties.setProperty(string, properties2.getProperty(string));
        }
        return properties;
    }

    private static Properties mergeSystemProperties(Properties properties) {
        Properties properties2 = System.getProperties();
        Enumeration<?> enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("se.ericsson.") && !string.startsWith("org.jacorb.") && !string.startsWith("jacorb.") && !string.startsWith("org.omg.") && !string.startsWith("prismtech") && !string.equals("OASSLPort")) continue;
            properties.setProperty(string, properties2.getProperty(string));
        }
        return properties;
    }

    private static Properties loadExternalProperties() throws INITIALIZE {
        Properties properties = new Properties();
        if (!ORBInit.isServer()) {
            String string = System.getProperty("se.ericsson.security.PropertyFileURL");
            if (string != null) {
                logger.trace(1, thisClass, "Reading properties from URL " + string);
                try {
                    URL uRL = new URL(string);
                    ORBInit.loadAndClose(properties, uRL.openStream());
                }
                catch (MalformedURLException malformedURLException) {
                    logger.traceStack(1, thisClass, "PropertyFileURL not a valid url:" + string, malformedURLException);
                    throw new INITIALIZE("PropertyFileURL not a valid url " + string + " : " + malformedURLException);
                }
                catch (IOException iOException) {
                    logger.traceStack(1, thisClass, "Failed reading properties from url : " + string, iOException);
                    throw new INITIALIZE("Failed reading properties from url " + string + " : " + iOException);
                }
            }
        } else {
            String string = System.getProperty("se.ericsson.security.PropertyFileLocation");
            if (string == null) {
                string = System.getProperty("se_ericsson_security_PropertyFileLocation");
            }
            if (string == null) {
                string = "orb.prp";
            }
            try {
                logger.trace(1, thisClass, "Reading properties from " + string);
                ORBInit.loadAndClose(properties, new FileInputStream(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.trace(1, thisClass, "Could not find property file " + string);
            }
        }
        return properties;
    }

    private static boolean isSecurityEnabled() {
        if (CorbaSecurity == null) {
            if (Boolean.getBoolean("se.ericsson.security.ssu.authenticationenabled")) {
                ORBInit.setCorbaSecurityState("ON");
                return true;
            }
            logger.trace(1, thisClass, "Reading security state from " + SecurityConfigFile);
            try {
                Properties properties = new Properties();
                ORBInit.loadAndClose(properties, new FileInputStream(SecurityConfigFile));
                CorbaSecurity = properties.getProperty("CorbaSecurity");
                properties.clear();
                properties = null;
            }
            catch (IOException iOException) {
                logger.trace(1, thisClass, "Could not load security state " + iOException.toString());
            }
        }
        logger.trace(1, thisClass, "CorbaSecurity=" + CorbaSecurity);
        return "ON".equalsIgnoreCase(CorbaSecurity);
    }

    public static boolean isServer() {
        return Boolean.getBoolean("se.ericsson.security.corba.is_server");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadAndClose(Properties properties, InputStream inputStream) throws INITIALIZE {
        try {
            try {
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                logger.traceStack(1, thisClass, "Failed reading properties: ", iOException);
                throw new INITIALIZE("Failed reading properties: " + iOException);
            }
            Object var4_2 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                inputStream = null;
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        inputStream.close();
        return;
    }

    private static Properties getServerProperties(Properties properties, String string) {
        logger.trace(1, thisClass, "Loading Server properties");
        if (ORBInit.isSecurityEnabled()) {
            if ("JKS".equalsIgnoreCase(string)) {
                properties = ORBInit.mergeProperties(properties, ORBInit.getProperties("keystore.properties"));
            } else {
                properties = ORBInit.mergeProperties(properties, ORBInit.getProperties("application.properties"));
                if (System.getProperty("java.vendor").startsWith("IBM")) {
                    if (!System.getProperty("os.name").startsWith("Linux")) {
                        logger.trace(1, thisClass, "Loading J9 ME properties");
                        properties = ORBInit.mergeProperties(properties, ORBInit.getProperties("j9.application.properties"));
                    } else {
                        logger.trace(1, thisClass, "Loading J9 SE properties");
                        properties = ORBInit.mergeProperties(properties, ORBInit.getProperties("j9se.application.properties"));
                    }
                }
            }
            String string2 = ORBInit.getSupportedCiphers();
            logger.trace(1, thisClass, string2);
            properties.setProperty("jacorb.security.ssl.server.cipher_suites", string2);
            properties.setProperty("jacorb.security.ssl.client.cipher_suites", string2);
        } else {
            properties.setProperty("org.omg.PortableInterceptor.ORBInitializerClass.ServerInit", "se.ericsson.security.corba.interceptor.Level1ServerInit");
        }
        properties.setProperty("jacorb.net.socket_factory", "se.ericsson.security.corba.socket.CSUSocketFactory");
        return properties;
    }

    private static Properties getClientProperties(Properties properties) {
        logger.trace(1, thisClass, "Loading Client properties");
        int n = -1;
        int n2 = -1;
        boolean bl = ORBInit.isSecurityEnabled();
        if (bl) {
            properties = ORBInit.mergeProperties(properties, ORBInit.getProperties("applet.properties"));
        }
        if (!System.getProperty("se.ericsson.security.port_daemon", "on").equalsIgnoreCase("off")) {
            try {
                n = PortResourceClientProxy.getPort();
                n2 = PortResourceClientProxy.getPort();
                logger.trace(1, thisClass, "Got port from port daemon: " + n);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                logger.trace(1, thisClass, "SSU missing. Firewall may block callbacks.");
            }
        } else {
            logger.info(thisClass, "Port daemon check disabled. Firewall may block callbacks");
        }
        if (n != -1 || n2 != -1) {
            if (bl) {
                properties.setProperty("jacorb.ssl.socket_factory.port_min", new Integer(n).toString());
                properties.setProperty("jacorb.ssl.socket_factory.port_max", new Integer(n).toString());
                properties.setProperty("jacorb.ssl.socket_factory", "com.prismtech.corba.jacorb.PortRangeSSLSocketFactory");
                properties.setProperty("OASSLPort", new Integer(n2).toString());
                properties.setProperty("jacorb.ssl.server_socket_factory", "com.prismtech.corba.jacorb.SSLServerSocketFactory");
            } else {
                properties.setProperty("jacorb.net.socket_factory.port.min", new Integer(n).toString());
                properties.setProperty("jacorb.net.socket_factory.port.max", new Integer(n).toString());
                properties.setProperty("jacorb.net.socket_factory", "org.jacorb.orb.factory.PortRangeSocketFactory");
                properties.setProperty("OAPort", new Integer(n2).toString());
            }
        }
        return properties;
    }

    private static boolean getBoolean(String string, Properties[] propertiesArray) {
        for (int i = 0; i < propertiesArray.length; ++i) {
            String string2 = propertiesArray[i].getProperty(string);
            if (string2 == null) continue;
            return Boolean.valueOf(string2);
        }
        return false;
    }

    private static String getSupportedCiphers() {
        List list = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, null, null);
            String[] stringArray = sSLContext.getSocketFactory().getSupportedCipherSuites();
            list = ORBInit.convertStringArrayToList(stringArray);
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i).toString().indexOf("NULL") != -1) {
                    list.remove(i);
                    continue;
                }
                stringBuffer.append(list.get(i).toString());
                if (i == list.size() - 1) continue;
                stringBuffer.append(",");
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.traceError(thisClass, "NoSuchAlgorithmException", noSuchAlgorithmException);
        }
        catch (RuntimeException runtimeException) {
            logger.traceError(thisClass, "RunTimeException", runtimeException);
        }
        catch (KeyManagementException keyManagementException) {
            logger.traceError(thisClass, "KeyManagementException", keyManagementException);
        }
        if (stringBuffer.lastIndexOf(",") == stringBuffer.length() - 1) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private static List convertStringArrayToList(String[] stringArray) {
        String[] stringArray2 = stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray2.length; ++i) {
            arrayList.add(stringArray2[i]);
        }
        return arrayList;
    }

    private static String getProperty(String string, Properties[] propertiesArray) {
        for (int i = 0; i < propertiesArray.length; ++i) {
            String string2 = propertiesArray[i].getProperty(string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = thisClass = class$se$ericsson$security$corba$ORBInit == null ? (class$se$ericsson$security$corba$ORBInit = ORBInit.class$("se.ericsson.security.corba.ORBInit")) : class$se$ericsson$security$corba$ORBInit;
        SecurityConfigFile = System.getProperty("oms.javasim.seccfgfile") != null ? System.getProperty("oms.javasim.seccfgfile") : (System.getProperties().containsKey("SIM") ? "/host/security/security.cfg" : "/c/security/security.cfg");
        CorbaSecurity = null;
    }
}

