/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem;

import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractDbControlledAuxillaryUnitRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAiDevice;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAiDeviceSet;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRruDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSector;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SectorAntennaMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class RruwRI
extends AbstractDbControlledAuxillaryUnitRI {
    public static final String name = "RRUW";
    private static final String WIZARD_SWALLOC_ROLE_RRUW = "RBS_RRUW";
    private static final String WIZARD_REPERTOIRE_RRUW = "RBS_RRUW";
    private static final String piuTypeProductName = "RRUW";
    private boolean lockSecondAiDevice = false;
    private MoHandler moHandler;
    private MoInstance sectorMoi;
    private MoInstance sectorAntennaMoi;
    private MoInstance auxPiuMoi;
    public MoInstance boardMoi;
    private String auxPiuLdn;
    private final String ldn;
    private static final String[] SECTOR_RDN = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"};

    public RruwRI(Rbs rbs, String string, String string2) {
        super("RRUW", rbs, 20, "RRUW", string2);
        this.setSwLoadable(true);
        this.setRoleForSwAllocation("RBS_RRUW");
        this.addRepertoiresToInstall("RBS_RRUW");
        this.ldn = string;
        this.moHandler = this.rbs.getMoHandler();
    }

    public RruwRI(Rbs rbs, String string, String string2, int n) throws BemException {
        super("RRUW", rbs, 20, "RRUW", string2);
        this.setSwLoadable(true);
        this.setRoleForSwAllocation("RBS_RRUW");
        this.addRepertoiresToInstall("RBS_RRUW");
        this.sectorMoi = new FixedRdnMoi(this.rbs.getNodeBFunctionMoi(), MimSector.MOTYPENAME, SECTOR_RDN[n - 1]);
        this.sectorAntennaMoi = new SectorAntennaMoi(this.rbs.getEquipmentMoi(), this.sectorMoi, n, 1);
        this.auxPiuMoi = new FixedRdnMoi(this.sectorAntennaMoi, MimAuxPlugInUnit.MOTYPENAME, "RRUW" + string);
        this.auxPiuLdn = this.auxPiuMoi.getLdn();
        this.boardMoi = new SingleChildMoi(this.auxPiuMoi, MimRruDeviceGroup.MOTYPENAME, "1");
        this.ldn = this.boardMoi.getLdn();
        this.moHandler = this.rbs.getMoHandler();
    }

    public void install(String string) throws BemException {
        super.install(string);
        if (string.equals("AuxUnitDbControlledCreationPhase")) {
            this.setTrDeviceAttribute();
        }
        if (string.equals("LockPhase") || string.equals("UnlockPhase")) {
            this.lockOrUnlockSecondAiDevice();
        }
    }

    private void setTrDeviceAttribute() throws BemException {
        this.createMoIfNotExisting(this.ldn + ",TrDeviceSet=1,TrDevice=2");
    }

    public boolean isInstalled() throws BemException {
        return super.isExisting(this.ldn);
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getAuxPiuLdn() {
        return this.auxPiuLdn;
    }

    public String getDisplayName() {
        return "RRUW: " + this.getLdn();
    }

    public void setSecondAiLocked(boolean bl) {
        this.lockSecondAiDevice = bl;
    }

    private void lockOrUnlockSecondAiDevice() throws BemException {
        try {
            String string = this.ldn + "," + MimAiDeviceSet.MOTYPENAME + "=1," + MimAiDevice.MOTYPENAME + "=2";
            BemMo bemMo = this.moHandler.getMo(string);
            if (this.moHandler.isExisting(bemMo)) {
                Integer n = (Integer)this.moHandler.getAttribute(bemMo, "administrativeState");
                if (this.lockSecondAiDevice) {
                    if (n != null && n == 1) {
                        this.moHandler.setAttribute(bemMo, "administrativeState", new Integer(0));
                    }
                } else if (n != null && n == 0) {
                    this.moHandler.setAttribute(bemMo, "administrativeState", new Integer(1));
                }
            }
        }
        catch (MoHandlerException moHandlerException) {
            String string = moHandlerException.getAction();
            throw new BemException(string, this.ldn, (Throwable)moHandlerException);
        }
    }
}

