/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.resource;

import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.custparam.TransportOptionParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpInterface;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpOam;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class IpRI
extends AbstractResourceItem
implements ResourceItem {
    public static final String HOST_NODEINTERFACENAME = "lh";
    public static final String ETHERNET_NODEINTERFACENAME = "le0";
    private static final String[] myInstallationPhases = new String[]{"IpSystemCreationPhase", "NodeInterfaceNameSettingPhase", "DnsAutoConfigPhase", "IpValidationPhase"};
    private static String name = "IP";
    private String ipLdn;
    private boolean wasCreated = false;
    private MoInstance ipInterfaceMoi = null;

    public IpRI(Rbs rbs) throws BemException {
        super(name, rbs, myInstallationPhases);
        MoInstance moInstance = this.rbs.getRootMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(moInstance, MimIpOam.MOTYPENAME, "1");
        SingleChildMoi singleChildMoi2 = new SingleChildMoi(singleChildMoi, MimIp.MOTYPENAME, "1");
        this.ipLdn = singleChildMoi2.getLdn();
        this.initiateCPWithNodeValues();
    }

    private void initiateCPWithNodeValues() throws BemException {
        TransportOptionParameter transportOptionParameter = (TransportOptionParameter)this.getRbs().getCustomerParameterServerObject("IPoverGigabitEthernet_transportOption");
        this.registerCustomerParameter(transportOptionParameter);
        CustomerParameter customerParameter = this.getRbs().getCustomerParameterObject("OamIpHost_dnsAutoConfig");
        this.registerCustomerParameter(customerParameter);
        if (this.isExisting(this.ipLdn)) {
            BemMo bemMo = this.getMo(this.ipLdn);
            String string = (String)this.getAttribute(bemMo, "nodeInterfaceName");
            if (string.startsWith(HOST_NODEINTERFACENAME)) {
                transportOptionParameter.setLoadedValue("ipV4");
            } else if (string.equals(ETHERNET_NODEINTERFACENAME)) {
                transportOptionParameter.setLoadedValue("atm");
            } else {
                BemLog.log(2, name + ".initiateCPWithNodeValues()" + " failed to load interfaceName from node");
            }
            BemMo bemMo2 = (BemMo)this.getAttribute(bemMo, "dnsAutoConfigInterfaceRef");
            if (bemMo2 != null && bemMo2.isExisting() && bemMo2.getType().equals(MimIpInterface.MOTYPENAME)) {
                Integer n = (Integer)this.getAttribute(bemMo2, "configurationMode");
                if (n != null && n == 1) {
                    customerParameter.setValue("TRUE");
                } else {
                    customerParameter.setValue("FALSE");
                }
            }
        }
    }

    public void setIpInterface(MoInstance moInstance) {
        this.ipInterfaceMoi = moInstance;
    }

    public void install(String string) throws BemException {
        if (string.equals("IpSystemCreationPhase")) {
            boolean bl = false;
            this.installIpMo(bl);
        } else if (string.equals("NodeInterfaceNameSettingPhase")) {
            boolean bl = true;
            this.installIpMo(bl);
        } else if (string.equals("IpValidationPhase")) {
            this.validateIpMo();
        } else if (string.equals("DnsAutoConfigPhase") && this.isInstalled()) {
            this.setDnsAutoConfigInterfaceRef();
        }
    }

    private void installIpMo(boolean bl) throws BemException {
        if (!bl && !this.isInstalled()) {
            this.wasCreated = true;
            this.createIpMo();
        } else if (bl && !this.wasCreated && this.isInstalled()) {
            this.setIpMoAttributes();
        }
    }

    private void createIpMo() throws BemException {
        NalNameValue nalNameValue = this.getWorkingMode();
        NalNameValue nalNameValue2 = this.getNodeInterfaceName();
        NalNameValue[] nalNameValueArray = new NalNameValue[]{nalNameValue, nalNameValue2};
        this.createMoIfNotExisting(this.ipLdn, nalNameValueArray);
    }

    private void setIpMoAttributes() throws BemException {
        NalNameValue nalNameValue = this.getWorkingMode();
        NalNameValue nalNameValue2 = this.getNodeInterfaceName();
        NalNameValue[] nalNameValueArray = new NalNameValue[]{nalNameValue, nalNameValue2};
        boolean bl = false;
        while (!bl) {
            Object object;
            if (super.isInterrupted()) {
                Nal.getLog().nalTrace(4, this.getClass(), "Setting attributes workingMode and nodeInterfaceName on MO Ip was interrupted by user");
                break;
            }
            try {
                MoHandler moHandler = this.rbs.getMoHandler();
                object = moHandler.getMo(this.ipLdn);
                moHandler.setAttributes((BemMo)object, nalNameValueArray);
                bl = true;
            }
            catch (MoHandlerException moHandlerException) {
                object = "";
                Throwable throwable = moHandlerException.getCause();
                if (throwable instanceof NalCmException) {
                    object = throwable.toString();
                    Nal.getLog().nalTrace(6, this.getClass(), "Cause = " + (String)object);
                }
                if (-1 != ((String)object).indexOf("OperationNotAllowed")) {
                    Nal.getLog().nalTrace(6, this.getClass(), "Setting attributes on MO Ip is not yet allowed, trying to set after some delay, retrying ...");
                    super.delay_ms(500);
                    continue;
                }
                throw new BemException("Failed to setIpMoAttributes in IpRI", (Throwable)moHandlerException);
            }
        }
    }

    private NalNameValue getWorkingMode() throws BemException {
        CustomerParameter customerParameter = super.getCustomerParameter("IPoverGigabitEthernet_transportOption");
        Integer n = customerParameter.getValue().equals("ipV4") ? new Integer(0) : new Integer(1);
        NalNameValue nalNameValue = Nal.getFactory().getNameValue("workingMode", n);
        return nalNameValue;
    }

    private NalNameValue getNodeInterfaceName() throws BemException {
        CustomerParameter customerParameter = super.getCustomerParameter("IPoverGigabitEthernet_transportOption");
        String string = "nodeInterfaceName";
        String string2 = customerParameter.getValue().equals("ipV4") ? "lh0" : ETHERNET_NODEINTERFACENAME;
        NalNameValue nalNameValue = Nal.getFactory().getNameValue(string, string2);
        return nalNameValue;
    }

    private void setDnsAutoConfigInterfaceRef() throws BemException {
        String string = "dnsAutoConfigInterfaceRef";
        if (this.ipInterfaceMoi != null) {
            BemMo bemMo = this.getMo(this.ipInterfaceMoi.getLdn());
            this.setAttribute(this.ipLdn, string, (Object)bemMo);
        }
    }

    private void validateIpMo() throws BemException {
        BemMo bemMo = this.getMo(this.ipLdn);
        String string = null;
        Object object = null;
        Object object2 = null;
        try {
            NalNameValue nalNameValue = this.getNodeInterfaceName();
            object = nalNameValue.getValue();
            string = nalNameValue.getName();
            object2 = this.getAttribute(bemMo, string);
            if (object2 == null || !object2.equals(object)) {
                throw new BemException("IpValidation failed");
            }
            nalNameValue = this.getWorkingMode();
            object = nalNameValue.getValue();
            string = nalNameValue.getName();
            object2 = this.getAttribute(bemMo, string);
            if (object2 == null || !object2.equals(object)) {
                throw new BemException("IpValidation failed");
            }
        }
        catch (Exception exception) {
            BemException bemException = new BemException("IpRI validation", (Throwable)exception);
            bemException.setProperty("Bad value - Description", "IpValidation failed for attribute " + string);
            bemException.setProperty("Bad value - Expected", object);
            bemException.setProperty("Bad value - Actual", object2);
            bemException.setProperty("ManagedObject", bemMo);
            throw bemException;
        }
    }

    public boolean isInstalled() throws BemException {
        boolean bl = false;
        if (super.isExisting(this.ipLdn)) {
            bl = true;
        }
        return bl;
    }

    public String getDisplayName() {
        return name;
    }

    public String getLdn() {
        return this.ipLdn;
    }

    public boolean shouldRiBeInstalled() throws BemException {
        boolean bl = false;
        CustomerParameter customerParameter = super.getCustomerParameter("IPoverGigabitEthernet_transportOption");
        CustomerParameter customerParameter2 = super.getCustomerParameter("OamIpHost_dnsAutoConfig");
        if (this.isInstalled()) {
            if (customerParameter.hasValueChanged() || customerParameter2.hasValueChanged()) {
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public void setRestrictedTransportOption() throws BemException {
        TransportOptionParameter transportOptionParameter = (TransportOptionParameter)this.getRbs().getCustomerParameterServerObject("IPoverGigabitEthernet_transportOption");
        if (this.isExisting(this.ipLdn)) {
            BemMo bemMo = this.getMo(this.ipLdn);
            String string = (String)this.getAttribute(bemMo, "nodeInterfaceName");
            if (string.startsWith(HOST_NODEINTERFACENAME)) {
                BemLog.log(3, name + ".setRestrictedTransportOption()" + " for " + HOST_NODEINTERFACENAME + ". Initial value " + transportOptionParameter.getValue() + " used.");
            } else if (string.equals(ETHERNET_NODEINTERFACENAME)) {
                if (transportOptionParameter.getRestriction().isActive()) {
                    if (!transportOptionParameter.getRestriction().isValueRestricted("atm")) {
                        transportOptionParameter.setValue("atm");
                    } else if (!transportOptionParameter.getRestriction().isValueRestricted("ipV4")) {
                        transportOptionParameter.setValue("ipV4");
                    } else {
                        transportOptionParameter.setValue("atm");
                        BemLog.log(2, name + ".setRestrictedTransportOption()" + ". Unhandled restriction. Transport set to ATM.");
                    }
                } else {
                    transportOptionParameter.setValue("atm");
                    BemLog.log(3, name + ".setRestrictedTransportOption()" + ". Restriction not active. Transport set to ATM.");
                }
            } else {
                BemLog.log(2, name + ".setRestrictedTransportOption()" + " failed to load interfaceName from node");
            }
        }
    }
}

