/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.check.ConfigurationCheckReport;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.AbstractConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.ApcConfigurationManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.ApcHwCapabilityMetaData;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.BatteryManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.BatteryTypeConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.ChargingModeConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.ClimateManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.IntegerConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.MultiplePowerSystemConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.PowerDistributionManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.PowerSupplyManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.PowerSystemUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.SharedBatteryConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.SupportSystemManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.TestModeConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.BatteryTypeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.ClimateRegulationSystem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.ClimateSystem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.ConfigureBatteryBackupParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.ConfigurePowerSupplyParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.FanSpeedSupervisionParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.MultiplePowerSystemParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.NoOfBfuParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.NoOfPduParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.NoOfPsuParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.SmokeDetectorParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.SupportSystemControlParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.EcBusRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.HwGroupRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.help.RDNHelper;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.PowerSupplyProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OutOfRangeException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.TrueFalseCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsInfo;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractHwUnitWithEcPortRI;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRuRI;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAntFeederCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimBatteryBackup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimCabinet;
import se.ericsson.wcdma.rbs.bem.common.mim.MimHwGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimHwUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPowerSupply;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMoImpl;
import se.ericsson.wcdma.rbs.bem.common.service.PrefixUtil;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public abstract class AbstractPowerSystemCI
extends AbstractConfigurationItem
implements CustomerParameterListener,
PowerSupplyProvider {
    public static final String name = "PowerSystemCI";
    private HashMap psuMap = new HashMap();
    private HashMap pduMap = new HashMap();
    private HashMap bfuMap = new HashMap();
    public static final Integer mimBfuNumberSupportParallelBfu = new Integer(2);
    private HashMap powerSupplyManagerMap = new HashMap();
    private HashMap powerDistributionManagerMap = new HashMap();
    private HashMap batteryManagerMap = new HashMap();
    private HashMap climateManagerMap = new HashMap();
    private SupportSystemManager supportSystemManager;
    protected HashMap optionalEquipmentcabinetNoParam = new HashMap();
    protected HashMap noOfPsuCustParamMap = new HashMap();
    protected HashMap noOfPduCustParamMap = new HashMap();
    protected HashMap noOfBfuCustParamMap = new HashMap();
    protected HashMap fanSpeedSupervisionParamMap = new HashMap();
    protected HashMap confPowerSupplyCustParam = new HashMap();
    protected HashMap multiplePowerSystemCustParam = new HashMap();
    protected HashMap batteryTypeParam = new HashMap();
    protected HashMap confBatteryBackupCustParam = new HashMap();
    protected SupportSystemControlParameter supportSystemControlCustParam;
    protected HashMap configureClimateCustParamMap = new HashMap();
    protected HashMap climateSystemCustParam = new HashMap();
    protected HashMap climateRegulationSystemCustParamMap = new HashMap();
    protected HashMap smokeDetectorParam = new HashMap();
    protected HashMap cabinetNumberParam = new HashMap();
    protected HashMap referredCabinetNumberParam = new HashMap();
    protected HashMap sharedCabinetIdentifierParam = new HashMap();
    protected HashMap delCabinetNumberParam = new HashMap();
    protected HashMap cabEcBusNoParam = new HashMap();
    protected HashMap cabClimateSystemParam = new HashMap();
    protected HashMap cabinetTypeParam = new HashMap();
    protected IntegerParameter[] ecBusNoParam = new IntegerParameter[7];
    protected IntegerParameter[] ecBusconnectorUnitNumberParam = new IntegerParameter[7];
    protected Enumeration[] ecBusConnectorTypeParam = new Enumeration[7];
    protected IntegerParameter[] ecBusInterConnectorUnitNoParam = new IntegerParameter[7];
    protected IntegerParameter[] ModEcBusNoParam = new IntegerParameter[7];
    protected IntegerParameter[] ModEcBusconnectorUnitNumberParam = new IntegerParameter[7];
    protected Enumeration[] modEcBusConnectorTypeParam = new Enumeration[7];
    protected IntegerParameter[] modEcBusInterConnectorUnitNoParam = new IntegerParameter[7];
    protected HashMap sharedBatteryParam = new HashMap();
    protected HashMap chargingModeParam = new HashMap();
    protected HashMap testModeParam = new HashMap();
    protected HashMap minimumStateOfHealthParam = new HashMap();
    protected HashMap minimumBackupTimeParam = new HashMap();
    protected HashMap testStartDayParam = new HashMap();
    protected HashMap testStartTimeParam = new HashMap();
    protected HashMap batteryInstallationDateParam = new HashMap();
    protected HashMap testStartMonthParam = new HashMap();
    protected HashMap valueChargingVoltageParameter = new HashMap();
    protected HashMap valueTempCompVoltageSlopParameter = new HashMap();
    protected HashMap valueNominalTempParameter = new HashMap();
    protected HashMap valueTempCompMinVoltageParameter = new HashMap();
    protected HashMap valueTempCompMaxVoltageParameter = new HashMap();
    protected HashMap valueIncreasedChargeVoltageParameter = new HashMap();
    protected HashMap valueBoostChargeTimeParameter = new HashMap();
    protected HashMap valueBoostChargeTriggerVoltageParameter = new HashMap();
    protected HashMap valueEqualizeChargeTimeParameter = new HashMap();
    protected HashMap valueEqualizeChargeCyclicIntervalParameter = new HashMap();
    protected HashMap valueIntermittentChargeConnectVoltageParameter = new HashMap();
    protected HashMap valueIntermittentChargeConnectTimeParameter = new HashMap();
    protected HashMap valueIntermittentChargeDisconnectTimeParameter = new HashMap();
    private Vector hwGroupIdParams = new Vector();
    private Vector hwGroupPositionInfoParams = new Vector();
    private Vector hwGroupMois = new Vector();
    private Vector hwGroupRIs = new Vector();
    private Map hwGroupIdToIndex = new HashMap();
    private int noOfHwGroups = 0;
    private HashMap restMultiplePowerSystem = new HashMap();
    private HashMap restMultiplePowerSystemOptional = new HashMap();
    private HashMap restOptional = new HashMap();
    private HashMap restNoPsu = new HashMap();
    private HashMap psuRange = new HashMap();
    private HashMap pduRange = new HashMap();
    private HashMap restNoPdu = new HashMap();
    private HashMap restNoBfu = new HashMap();
    private HashMap bfuRange = new HashMap();
    protected HashMap restRangeNoOfBfu = new HashMap();
    private HashMap restFanSpeedSupervision = new HashMap();
    private HashMap restEcBusNumber = new HashMap();
    private HashMap restBatteryNoDelete = new HashMap();
    private HashMap restBatteryTypeOptional = new HashMap();
    private HashMap restBatteryIgnored = new HashMap();
    private HashMap restPowSupplyModifyPsu = new HashMap();
    private HashMap restPowSupplyNoDelete = new HashMap();
    private HashMap restPowerSupplyIgnored = new HashMap();
    private HashMap restSmokeDetectorIgnored = new HashMap();
    private HashMap restBatteryType = new HashMap();
    private HashMap restBatteryInstallationDate = new HashMap();
    private HashMap restMinimumStateOfHealth = new HashMap();
    private HashMap restMinimumBackupTime = new HashMap();
    private HashMap restBatteryBackupAttributes = new HashMap();
    private HashMap restClimateSystem = new HashMap();
    private HashMap restClimateRegulationSystem = new HashMap();
    private HashMap restTestModeRelatedCPs = new HashMap();
    private HashMap restChargingModeRelatedCPs = new HashMap();
    private boolean isOpen = false;
    protected ApcHwCapabilityMetaData apcConfigurationData4Rbs = null;
    protected ApcConfigurationManager apcConfigurationManager = null;
    private EcBusRI[] ecBusRI = new EcBusRI[7];

    public AbstractPowerSystemCI(Rbs rbs) {
        super(rbs);
        this.apcConfigurationManager = ApcConfigurationManager.getApcConfigurationManager();
        if (this.apcConfigurationManager.isInitializedInMap(BemUtil.getCabinetType(rbs.getRbsType()))) {
            this.apcConfigurationData4Rbs = ApcConfigurationManager.getApcConfigurationManager().getApcHwCapabilityMetaData(BemUtil.getCabinetType(rbs.getRbsType()));
        }
    }

    public boolean open() throws BemException {
        try {
            if (this.isOpen) {
                throw new BemException("AbstractPowerSystemCI.open(): Already open");
            }
            ConfigurationItem configurationItem = this.rbs.getConfigItem("CabinetBasicCI");
            if (configurationItem != null && this.isDuwV2In6601() && !configurationItem.isOpen()) {
                this.rbs.openConfigurationItem("CabinetBasicCI");
            }
            this.initializeRestrictions();
            this.initializeResourceManagers();
            this.updateHWPostfixList();
            this.createAllRIs();
            this.createAllCustomerParameters();
            this.setDefaultParameterValues();
            this.updateLoadedValues();
            this.setCustomerParameterRestrictions();
            this.setCustomerParameterListeners();
            this.initialiseResourceForHwGroups();
            this.isOpen = true;
        }
        catch (BemException bemException) {
            throw bemException;
        }
        catch (Exception exception) {
            throw new BemException("AbstractPowerSystemCI.open() got exception=" + exception.toString());
        }
        return true;
    }

    void initializeRestrictions() {
        Iterator iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            int n = Integer.parseInt(iterator.next().toString());
            String string = BemUtil.generateCabinetKey(n);
            this.restFanSpeedSupervision.put(string, new ParameterRestriction("fanSpeedSupervisions are not needed", 1));
            this.restOptional.put(string, new ParameterRestriction("", 2));
            this.restRangeNoOfBfu.put(string, new ParameterRestriction("BFUs are not needed", 1));
            this.restNoPsu.put(string, new ParameterRestriction("PSUs are not needed when no power supply is selected", 1));
            this.restNoPdu.put(string, new ParameterRestriction("PDUs are not needed", 1));
            this.restNoBfu.put(string, new ParameterRestriction("BFUs are not needed", 1));
            this.restBatteryNoDelete.put(string, new ParameterRestriction("Cannot delete an existing battery", 0));
            this.restBatteryTypeOptional.put(string, new ParameterRestriction("", 2));
            this.restBatteryIgnored.put(string, new ParameterRestriction("Battery Backup is only allowed when Support System Control is chosen", 1));
            this.restMultiplePowerSystemOptional.put(string, new ParameterRestriction("", 2));
            this.restMultiplePowerSystem.put(string, new ParameterRestriction("", 1));
            this.restPowSupplyModifyPsu.put(string, new ParameterRestriction("\nNo power supply system was installed at cabinet or site configuration - \n not allowed to modify no of PSUs", 0));
            this.restPowSupplyNoDelete.put(string, new ParameterRestriction("Cannot delete an existing power supply", 0));
            this.restPowerSupplyIgnored.put(string, new ParameterRestriction("Power Supply is only allowed when Support System Control is chosen", 1));
            this.restSmokeDetectorIgnored.put(string, new ParameterRestriction("Smoke Detector is only allowed when Support System Control is chosen", 1));
            this.restBatteryType.put(string, new ParameterRestriction("Cannot configure battery type when no battery", 1));
            this.restBatteryInstallationDate.put(string, new ParameterRestriction("Cannot configure battery Installation date when no battery", 1));
            this.restMinimumStateOfHealth.put(string, new ParameterRestriction("Cannot configure Minimum state of health when shared battery is Yes", 1));
            this.restMinimumBackupTime.put(string, new ParameterRestriction("Cannot config Minimum backup time when shared battery is No", 1));
            this.restEcBusNumber.put(string, new ParameterRestriction("EcbusNumber is only allowed when Support System Control is true", 1));
            this.restBatteryBackupAttributes.put(string, new ParameterRestriction("Attributes of battery backup are not allowed because battery backup is not configured", 1));
            this.restClimateSystem.put(string, new ParameterRestriction("Climate system is only needed when Support System Control is chosen", 1));
            this.restClimateRegulationSystem.put(string, new ParameterRestriction("Climate regulation system is only needed when Support System Control is chosen", 1));
            this.restTestModeRelatedCPs.put(string, new ParameterRestriction("Attributes test mode related are not supported when test mode is not configured", 1));
            this.restChargingModeRelatedCPs.put(string, new ParameterRestriction("Attributes charging mode related are not supported when charging mode is not user defined", 1));
        }
    }

    void initializeResourceManagers() throws BemException {
        this.supportSystemManager = this.getSupportSystemManager();
        this.powerSupplyManagerMap.put(BemUtil.cabinetWithPDuw, this.getPowerSupplyManager());
        this.powerDistributionManagerMap.put(BemUtil.cabinetWithPDuw, this.getPowerDistributionManager());
        this.batteryManagerMap.put(BemUtil.cabinetWithPDuw, this.getBatteryManager());
        this.climateManagerMap.put(BemUtil.cabinetWithPDuw, this.getClimateManager());
        Iterator iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            Object object;
            int n = Integer.parseInt(iterator.next().toString());
            if (n <= 1) continue;
            String string = BemUtil.generateCabinetKey(n);
            String string2 = PrefixUtil.getCabinetPrefix(String.valueOf(n)) + "cabinetType";
            String string3 = "";
            if (this.rbs.isCabinetWiz() && n == 2 && BemUtil.isDualBoxSupported(this.rbs.getRbsType())) {
                object = (ClimateManager)this.climateManagerMap.get(BemUtil.cabinetWithPDuw);
                this.climateManagerMap.put(BemUtil.cabinetWithSDuw, new ClimateManager(this.rbs, ((ClimateManager)object).hasClu(), ((ClimateManager)object).hasScu(), ((ClimateManager)object).hasSup(), ((ClimateManager)object).getClimateSystemRange(), ((ClimateManager)object).getClimateRegulationSystemRange(), n, null));
                continue;
            }
            if (this.rbs.isParameterSupported(string2) && this.rbs.getCustomerParameter(string2) != null) {
                string3 = this.rbs.getCustomerParameter(string2);
            }
            if (this.apcConfigurationManager.isInitializedInMap(string3)) {
                object = this.apcConfigurationManager.getApcHwCapabilityMetaData(string3);
                this.batteryManagerMap.put(string, new BatteryManager(this.rbs, ((ApcHwCapabilityMetaData)object).getBfuPosition(), ((ApcHwCapabilityMetaData)object).getBfuRange(), ((ApcHwCapabilityMetaData)object).isBatteryBackupSupported(), n, string3));
                this.powerSupplyManagerMap.put(string, new PowerSupplyManager(this.rbs, ((ApcHwCapabilityMetaData)object).getPsuPosition(), ((ApcHwCapabilityMetaData)object).getPsuRange(), ((ApcHwCapabilityMetaData)object).isPowerSupplySupported(), n, string3));
                this.powerDistributionManagerMap.put(string, new PowerDistributionManager(this.rbs, ((ApcHwCapabilityMetaData)object).getPduPosition(), ((ApcHwCapabilityMetaData)object).getPduRange(), ((ApcHwCapabilityMetaData)object).isPowerDistributionSupported(), n, string3));
                this.climateManagerMap.put(string, new ClimateManager(this.rbs, ((ApcHwCapabilityMetaData)object).hasClu(), ((ApcHwCapabilityMetaData)object).hasScu(), ((ApcHwCapabilityMetaData)object).hasSup(), ((ApcHwCapabilityMetaData)object).getClimateSystemRange(), ((ApcHwCapabilityMetaData)object).getClimateRegulationSystemRange(), n, string3));
                continue;
            }
            if (this.rbs.isCabinetWiz() || !string3.equals("##UNDEFINED") || null == (object = (ClimateManager)this.climateManagerMap.get(BemUtil.cabinetWithPDuw))) continue;
            this.climateManagerMap.put(string, new ClimateManager(this.rbs, false, false, false, ((ClimateManager)object).getClimateSystemRange(), ((ClimateManager)object).getClimateRegulationSystemRange(), n, null));
        }
    }

    private void createAllRIs() throws BemException {
        int n;
        this.supportSystemManager.createAllRIs();
        Iterator iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            ClimateManager climateManager;
            PowerSupplyManager powerSupplyManager;
            PowerDistributionManager powerDistributionManager;
            n = Integer.parseInt(iterator.next().toString());
            String string = BemUtil.generateCabinetKey(n);
            BatteryManager batteryManager = (BatteryManager)this.batteryManagerMap.get(string);
            if (null != batteryManager) {
                batteryManager.createAllRIs();
            }
            if (null != (powerDistributionManager = (PowerDistributionManager)this.powerDistributionManagerMap.get(string))) {
                powerDistributionManager.createAllRIs();
            }
            if (null != (powerSupplyManager = (PowerSupplyManager)this.powerSupplyManagerMap.get(string))) {
                powerSupplyManager.createAllRIs();
            }
            if (null == (climateManager = (ClimateManager)this.climateManagerMap.get(string))) continue;
            climateManager.createAllRIs();
        }
        this.ecBusRI[0] = new EcBusRI(this.rbs, 1, "EC");
        if (DuwUtil.isDualBoxConfiguration(this.rbs.getRbsType())) {
            this.ecBusRI[1] = new EcBusRI(this.rbs, 2, "AUX");
        } else {
            for (n = 1; n < 7; ++n) {
                this.ecBusRI[n] = new EcBusRI(this.rbs, n + 1, "EC");
            }
        }
    }

    private void createAllCustomerParameters() throws BemException {
        Object object;
        String string;
        int n;
        Iterator iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            CustomerParameterImpl customerParameterImpl;
            Enumeration enumeration;
            Object object2;
            Object object3;
            Object object4;
            n = Integer.parseInt(iterator.next().toString());
            String string2 = BemUtil.generateCabinetKey(n);
            string = PrefixUtil.getCabinetPrefix(String.valueOf(n));
            object = (PowerSupplyManager)this.powerSupplyManagerMap.get(string2);
            if (null != object) {
                object4 = new NoOfPsuParameter(string + "noOfPsu", ((PowerSupplyManager)object).getPsuRange());
                this.addParameter((CustomerParameter)object4);
                this.noOfPsuCustParamMap.put(string2, object4);
            }
            if (null != (object4 = (PowerDistributionManager)this.powerDistributionManagerMap.get(string2))) {
                object3 = new NoOfPduParameter(string + "noOfPdu", ((PowerDistributionManager)object4).getPduRange());
                this.addParameter((CustomerParameter)object3);
                this.noOfPduCustParamMap.put(string2, object3);
            }
            if (null != (object3 = (BatteryManager)this.batteryManagerMap.get(string2))) {
                object2 = new NoOfBfuParameter(string + "noOfBfu", ((BatteryManager)object3).getBfuRange());
                this.addParameter((CustomerParameter)object2);
                this.noOfBfuCustParamMap.put(string2, object2);
                if (((BatteryManager)object3).isBatterySupported()) {
                    object2.setDefaultValue("1");
                    object2.addCustomerParameterListener(new NumberOfBfuListener(n));
                }
            }
            if (null != (object2 = (ClimateManager)this.climateManagerMap.get(string2))) {
                enumeration = new FanSpeedSupervisionParameter(string + "fanSpeedSupervision");
                enumeration.setDefaultValue("0");
                this.addParameter(enumeration);
                this.fanSpeedSupervisionParamMap.put(string2, enumeration);
            }
            enumeration = new MultiplePowerSystemParameter(string + "multiplePowerSystem");
            this.multiplePowerSystemCustParam.put(string2, enumeration);
            enumeration.setDefaultValue(MimPowerSupply.DEFAULT_MULTIPLEPOWERSYSTEM.toString().toUpperCase());
            enumeration.setMomConverter(new MultiplePowerSystemConversion());
            this.addParameter(enumeration);
            IntegerParameter integerParameter = new IntegerParameter(string + "cabinetNumber", new IntegerRange(1, this.rbs.getMaxCabinetNo()));
            this.optionalEquipmentcabinetNoParam.put(string2, integerParameter);
            ConfigureBatteryBackupParameter configureBatteryBackupParameter = new ConfigureBatteryBackupParameter(string + "configureBatteryBackup");
            this.confBatteryBackupCustParam.put(string2, configureBatteryBackupParameter);
            ConfigurePowerSupplyParameter configurePowerSupplyParameter = new ConfigurePowerSupplyParameter(string + "configurePowerSupply");
            this.confPowerSupplyCustParam.put(string2, configurePowerSupplyParameter);
            BatteryTypeParameter batteryTypeParameter = new BatteryTypeParameter(string + "batteryType");
            this.batteryTypeParam.put(string2, batteryTypeParameter);
            batteryTypeParameter.setMomConverter(new BatteryTypeConversion());
            batteryTypeParameter.setDefaultValue("TYPE01");
            Enumeration enumeration2 = new Enumeration(string + "chargingMode", new String[]{"AUTOMATIC", "USER_DEFINED"});
            this.chargingModeParam.put(string2, enumeration2);
            enumeration2.setMomConverter(new ChargingModeConversion());
            enumeration2.setDefaultValue("AUTOMATIC");
            TrueFalseCustomerParameter trueFalseCustomerParameter = new TrueFalseCustomerParameter(string + "sharedBattery");
            this.sharedBatteryParam.put(string2, trueFalseCustomerParameter);
            trueFalseCustomerParameter.setDefaultValue(MimBatteryBackup.DEFAULT_SHAREDBATTERY.toString().toUpperCase());
            trueFalseCustomerParameter.setMomConverter(new SharedBatteryConversion());
            Enumeration enumeration3 = new Enumeration(string + "testMode", new String[]{"AUTOMATIC", "CONFIGURED", "DISABLED"});
            this.testModeParam.put(string2, enumeration3);
            enumeration3.setMomConverter(new TestModeConversion());
            enumeration3.setDefaultValue("DISABLED");
            IntegerParameter integerParameter2 = new IntegerParameter(string + "minimumStateOfHealth", new IntegerRange(MimBatteryBackup.MIN_MINIMUMSTATEOFHEALTH, MimBatteryBackup.MAX_MINIMUMSTATEOFHEALTH));
            this.minimumStateOfHealthParam.put(string2, integerParameter2);
            integerParameter2.setMomConverter(new IntegerConversion("minimumStateOfHealth"));
            integerParameter2.setDefaultValue(MimBatteryBackup.DEFAULT_MINIMUMSTATEOFHEALTH.toString());
            IntegerParameter integerParameter3 = new IntegerParameter(string + "minimumBackupTime", new IntegerRange(MimBatteryBackup.MIN_MINIMUMBACKUPTIME, MimBatteryBackup.MAX_MINIMUMBACKUPTIME));
            this.minimumBackupTimeParam.put(string2, integerParameter3);
            integerParameter3.setMomConverter(new IntegerConversion("minimumBackupTime"));
            integerParameter3.setDefaultValue(MimBatteryBackup.DEFAULT_MINIMUMBACKUPTIME.toString());
            IntegerParameter integerParameter4 = new IntegerParameter(string + "testStartDay", new IntegerRange(MimBatteryBackup.MIN_TESTSTARTDAY, MimBatteryBackup.MAX_TESTSTARTDAY));
            this.testStartDayParam.put(string2, integerParameter4);
            integerParameter4.setMomConverter(new IntegerConversion("testStartDay"));
            integerParameter4.setDefaultValue(MimBatteryBackup.DEFAULT_TESTSTARTDAY.toString());
            StringParameter stringParameter = new StringParameter(string + "testStartTime", new StringRange(MimBatteryBackup.MINLEN_TESTSTARTTIME, MimBatteryBackup.MAXLEN_TESTSTARTTIME));
            this.testStartTimeParam.put(string2, stringParameter);
            stringParameter.setDefaultValue(MimBatteryBackup.DEFAULT_TESTSTARTTIME);
            StringParameter stringParameter2 = new StringParameter(string + "batteryInstallationDate", new StringRange(MimBatteryBackup.MINLEN_BATTERYINSTALLATIONDATE, MimBatteryBackup.MAXLEN_BATTERYINSTALLATIONDATE));
            this.batteryInstallationDateParam.put(string2, stringParameter2);
            stringParameter2.setDefaultValue(MimBatteryBackup.DEFAULT_BATTERYINSTALLATIONDATE);
            SmokeDetectorParameter smokeDetectorParameter = new SmokeDetectorParameter(string + "smokeDetector");
            this.smokeDetectorParam.put(string2, smokeDetectorParameter);
            if (n == 1) {
                smokeDetectorParameter.setDefaultValue("FALSE");
            }
            IntegerParameter integerParameter5 = new IntegerParameter(string + "chargingVoltage", new IntegerRange(MimBatteryBackup.MIN_CHARGINGVOLTAGE, MimBatteryBackup.MAX_CHARGINGVOLTAGE));
            this.valueChargingVoltageParameter.put(string2, integerParameter5);
            integerParameter5.setDefaultValue(MimBatteryBackup.DEFAULT_CHARGINGVOLTAGE.toString());
            integerParameter5.setMomConverter(new IntegerConversion("chargingVoltage"));
            IntegerParameter integerParameter6 = new IntegerParameter(string + "tempCompVoltageSlope", new IntegerRange(MimBatteryBackup.MIN_TEMPCOMPVOLTAGESLOPE, MimBatteryBackup.MAX_TEMPCOMPVOLTAGESLOPE));
            this.valueTempCompVoltageSlopParameter.put(string2, integerParameter6);
            integerParameter6.setDefaultValue(MimBatteryBackup.DEFAULT_TEMPCOMPVOLTAGESLOPE.toString());
            integerParameter6.setMomConverter(new IntegerConversion("tempCompVoltageSlope"));
            IntegerParameter integerParameter7 = new IntegerParameter(string + "nominalTemp", new IntegerRange(MimBatteryBackup.MIN_NOMINALTEMP, MimBatteryBackup.MAX_NOMINALTEMP));
            this.valueNominalTempParameter.put(string2, integerParameter7);
            integerParameter7.setDefaultValue(MimBatteryBackup.DEFAULT_NOMINALTEMP.toString());
            integerParameter7.setMomConverter(new IntegerConversion("nominalTemp"));
            IntegerParameter integerParameter8 = new IntegerParameter(string + "tempCompMinVoltage", new IntegerRange(MimBatteryBackup.MIN_TEMPCOMPMINVOLTAGE, MimBatteryBackup.MAX_TEMPCOMPMINVOLTAGE));
            this.valueTempCompMinVoltageParameter.put(string2, integerParameter8);
            integerParameter8.setDefaultValue(MimBatteryBackup.DEFAULT_TEMPCOMPMINVOLTAGE.toString());
            integerParameter8.setMomConverter(new IntegerConversion("tempCompMinVoltage"));
            IntegerParameter integerParameter9 = new IntegerParameter(string + "tempCompMaxVoltage", new IntegerRange(MimBatteryBackup.MIN_TEMPCOMPMAXVOLTAGE, MimBatteryBackup.MAX_TEMPCOMPMAXVOLTAGE));
            this.valueTempCompMaxVoltageParameter.put(string2, integerParameter9);
            integerParameter9.setDefaultValue(MimBatteryBackup.DEFAULT_TEMPCOMPMAXVOLTAGE.toString());
            integerParameter9.setMomConverter(new IntegerConversion("tempCompMaxVoltage"));
            IntegerParameter integerParameter10 = new IntegerParameter(string + "increasedChargeVoltage", new IntegerRange(MimBatteryBackup.MIN_INCREASEDCHARGEVOLTAGE, MimBatteryBackup.MAX_INCREASEDCHARGEVOLTAGE));
            this.valueIncreasedChargeVoltageParameter.put(string2, integerParameter10);
            integerParameter10.setDefaultValue(MimBatteryBackup.DEFAULT_INCREASEDCHARGEVOLTAGE.toString());
            integerParameter10.setMomConverter(new IntegerConversion("increasedChargeVoltage"));
            IntegerParameter integerParameter11 = new IntegerParameter(string + "boostChargeTime", new IntegerRange(MimBatteryBackup.MIN_BOOSTCHARGETIME, MimBatteryBackup.MAX_BOOSTCHARGETIME));
            this.valueBoostChargeTimeParameter.put(string2, integerParameter11);
            integerParameter11.setDefaultValue(MimBatteryBackup.DEFAULT_BOOSTCHARGETIME.toString());
            integerParameter11.setMomConverter(new IntegerConversion("boostChargeTime"));
            IntegerParameter integerParameter12 = new IntegerParameter(string + "boostChargeTriggerVoltage", new IntegerRange(MimBatteryBackup.MIN_BOOSTCHARGETRIGGERVOLTAGE, MimBatteryBackup.MAX_BOOSTCHARGETRIGGERVOLTAGE));
            this.valueBoostChargeTriggerVoltageParameter.put(string2, integerParameter12);
            integerParameter12.setDefaultValue(MimBatteryBackup.DEFAULT_BOOSTCHARGETRIGGERVOLTAGE.toString());
            integerParameter12.setMomConverter(new IntegerConversion("boostChargeTriggerVoltage"));
            IntegerParameter integerParameter13 = new IntegerParameter(string + "equalizeChargeTime", new IntegerRange(MimBatteryBackup.MIN_EQUALIZECHARGETIME, MimBatteryBackup.MAX_EQUALIZECHARGETIME));
            this.valueEqualizeChargeTimeParameter.put(string2, integerParameter13);
            integerParameter13.setDefaultValue(MimBatteryBackup.DEFAULT_EQUALIZECHARGETIME.toString());
            integerParameter13.setMomConverter(new IntegerConversion("equalizeChargeTime"));
            IntegerParameter integerParameter14 = new IntegerParameter(string + "equalizeChargeCyclicInterval", new IntegerRange(MimBatteryBackup.MIN_EQUALIZECHARGECYCLICINTERVAL, MimBatteryBackup.MAX_EQUALIZECHARGECYCLICINTERVAL));
            this.valueEqualizeChargeCyclicIntervalParameter.put(string2, integerParameter14);
            integerParameter14.setDefaultValue(MimBatteryBackup.DEFAULT_EQUALIZECHARGECYCLICINTERVAL.toString());
            integerParameter14.setMomConverter(new IntegerConversion("equalizeChargeCyclicInterval"));
            IntegerParameter integerParameter15 = new IntegerParameter(string + "intermittentChargeConnectVoltage", new IntegerRange(MimBatteryBackup.MIN_INTERMITTENTCHARGECONNECTVOLTAGE, MimBatteryBackup.MAX_INTERMITTENTCHARGECONNECTVOLTAGE));
            this.valueIntermittentChargeConnectVoltageParameter.put(string2, integerParameter15);
            integerParameter15.setDefaultValue(MimBatteryBackup.DEFAULT_INTERMITTENTCHARGECONNECTVOLTAGE.toString());
            integerParameter15.setMomConverter(new IntegerConversion("intermittentChargeConnectVoltage"));
            IntegerParameter integerParameter16 = new IntegerParameter(string + "intermittentChargeConnectTime", new IntegerRange(MimBatteryBackup.MIN_INTERMITTENTCHARGECONNECTTIME, MimBatteryBackup.MAX_INTERMITTENTCHARGECONNECTTIME));
            this.valueIntermittentChargeConnectTimeParameter.put(string2, integerParameter16);
            integerParameter16.setDefaultValue(MimBatteryBackup.DEFAULT_INTERMITTENTCHARGECONNECTTIME.toString());
            integerParameter16.setMomConverter(new IntegerConversion("intermittentChargeConnectTime"));
            IntegerParameter integerParameter17 = new IntegerParameter(string + "intermittentChargeDisconnectTime", new IntegerRange(MimBatteryBackup.MIN_INTERMITTENTCHARGEDISCONNECTTIME, MimBatteryBackup.MAX_INTERMITTENTCHARGEDISCONNECTTIME));
            this.valueIntermittentChargeDisconnectTimeParameter.put(string2, integerParameter17);
            integerParameter17.setDefaultValue(MimBatteryBackup.DEFAULT_INTERMITTENTCHARGEDISCONNECTTIME.toString());
            integerParameter17.setMomConverter(new IntegerConversion("intermittentChargeDisconnectTime"));
            YesNoCustomerParameter yesNoCustomerParameter = new YesNoCustomerParameter(string + "configureClimate");
            this.configureClimateCustParamMap.put(string2, yesNoCustomerParameter);
            yesNoCustomerParameter.setDefaultValue("YES");
            this.addParameter(yesNoCustomerParameter);
            ClimateSystem climateSystem = new ClimateSystem(string + "climateSystem");
            this.climateSystemCustParam.put(string2, climateSystem);
            if (n > 1) {
                climateSystem.setDefaultValue("Standard");
            }
            ClimateRegulationSystem climateRegulationSystem = new ClimateRegulationSystem(string + "climateRegulationSystem");
            this.climateRegulationSystemCustParamMap.put(string2, climateRegulationSystem);
            if (n > 1) {
                climateRegulationSystem.setDefaultValue("NotApplicable");
            }
            HashMap<Integer, YesNoCustomerParameter> hashMap = new HashMap<Integer, YesNoCustomerParameter>();
            this.testStartMonthParam.put(string2, hashMap);
            HashMap hashMap2 = (HashMap)this.testStartMonthParam.get(string2);
            for (int i = 0; i < 12; ++i) {
                int n2 = i + 1;
                hashMap.put(new Integer(i), new YesNoCustomerParameter(string + "testStartMonths" + n2));
                customerParameterImpl = (YesNoCustomerParameter)hashMap2.get(new Integer(i));
                if (n2 == 3 || n2 == 9) {
                    ((YesNoCustomerParameter)customerParameterImpl).setDefaultValue("YES");
                } else {
                    ((YesNoCustomerParameter)customerParameterImpl).setDefaultValue("NO");
                }
                this.addParameter(customerParameterImpl);
            }
            this.addParameter(batteryTypeParameter);
            this.addParameter(configurePowerSupplyParameter);
            this.addParameter(configureBatteryBackupParameter);
            this.addParameter(enumeration2);
            this.addParameter(trueFalseCustomerParameter);
            this.addParameter(enumeration3);
            this.addParameter(integerParameter2);
            this.addParameter(integerParameter3);
            this.addParameter(integerParameter4);
            this.addParameter(stringParameter);
            this.addParameter(stringParameter2);
            this.addParameter(integerParameter5);
            this.addParameter(integerParameter6);
            this.addParameter(integerParameter7);
            this.addParameter(integerParameter8);
            this.addParameter(integerParameter9);
            this.addParameter(integerParameter10);
            this.addParameter(integerParameter11);
            this.addParameter(integerParameter12);
            this.addParameter(integerParameter13);
            this.addParameter(integerParameter14);
            this.addParameter(integerParameter15);
            this.addParameter(integerParameter16);
            this.addParameter(integerParameter17);
            IntegerParameter integerParameter18 = new IntegerParameter(string + "cabinetNumber", new IntegerRange(1, n));
            this.cabinetNumberParam.put(string2, integerParameter18);
            integerParameter18.setDefaultValue("##UNDEFINED");
            IntegerParameter integerParameter19 = new IntegerParameter(string + "referredCabinetNumber", new IntegerRange(1, this.rbs.getMaxCabinetNo()));
            this.referredCabinetNumberParam.put(string2, integerParameter19);
            customerParameterImpl = new StringParameter(string + "sharedCabinetIdentifier", new StringRange(MimCabinet.MINLEN_SHAREDCABINETIDENTIFIER, MimCabinet.MAXLEN_SHAREDCABINETIDENTIFIER));
            this.sharedCabinetIdentifierParam.put(string2, customerParameterImpl);
            customerParameterImpl.setDefaultValue("");
            IntegerParameter integerParameter20 = new IntegerParameter(string + "ecBusNumber", new IntegerRange(1, 7));
            this.cabEcBusNoParam.put(string2, integerParameter20);
            integerParameter20.setDefaultValue("##UNDEFINED");
            this.addParameter(integerParameter18);
            this.addParameter(integerParameter19);
            this.addParameter(customerParameterImpl);
            this.addParameter(integerParameter20);
            this.addParameter(smokeDetectorParameter);
            this.addParameter(climateSystem);
            this.addParameter(climateRegulationSystem);
            string = PrefixUtil.getDeleteCabinetPrefix(String.valueOf(n));
            IntegerParameter integerParameter21 = new IntegerParameter(string + "cabinetNumber", new IntegerRange(2, 7));
            this.delCabinetNumberParam.put(string2, integerParameter21);
            integerParameter21.setDefaultValue("##UNDEFINED");
            this.addParameter(integerParameter21);
        }
        for (n = 0; n < 7; ++n) {
            int n3 = n + 1;
            string = MessageFormat.format("EcBus{0}_", new Integer(n3));
            this.ecBusNoParam[n] = new IntegerParameter(string + "ecBusNumber", new IntegerRange(2, 7));
            this.ecBusNoParam[n].setDefaultValue("##UNDEFINED");
            this.ecBusconnectorUnitNumberParam[n] = new IntegerParameter(string + "connectorUnitNumber", new IntegerRange(1, this.rbs.getMaxNumberOfSectors()));
            this.ecBusconnectorUnitNumberParam[n].setDefaultValue("##UNDEFINED");
            this.ecBusConnectorTypeParam[n] = new Enumeration(string + "connectorType", new String[]{"DU", "RU"});
            this.ecBusInterConnectorUnitNoParam[n] = new IntegerParameter(string + "internalConnectorUnitNumber", new IntegerRange(1, 3));
            this.addParameter(this.ecBusNoParam[n]);
            this.addParameter(this.ecBusconnectorUnitNumberParam[n]);
            this.addParameter(this.ecBusConnectorTypeParam[n]);
            this.addParameter(this.ecBusInterConnectorUnitNoParam[n]);
            object = MessageFormat.format("ModEcBus{0}_", new Integer(n3));
            this.ModEcBusNoParam[n] = new IntegerParameter((String)object + "ecBusNumber", new IntegerRange(2, 7));
            this.ModEcBusNoParam[n].setDefaultValue("##UNDEFINED");
            this.ModEcBusconnectorUnitNumberParam[n] = new IntegerParameter((String)object + "connectorUnitNumber", new IntegerRange(1, this.rbs.getMaxNumberOfSectors()));
            this.ModEcBusconnectorUnitNumberParam[n].setDefaultValue("##UNDEFINED");
            this.modEcBusConnectorTypeParam[n] = new Enumeration((String)object + "connectorType", new String[]{"DU", "RU"});
            this.modEcBusInterConnectorUnitNoParam[n] = new IntegerParameter((String)object + "internalConnectorUnitNumber", new IntegerRange(1, 3));
            this.addParameter(this.ModEcBusNoParam[n]);
            this.addParameter(this.ModEcBusconnectorUnitNumberParam[n]);
            this.addParameter(this.modEcBusConnectorTypeParam[n]);
            this.addParameter(this.modEcBusInterConnectorUnitNoParam[n]);
        }
        this.supportSystemControlCustParam = new SupportSystemControlParameter();
        this.addParameter(this.supportSystemControlCustParam);
    }

    private void updateLoadedValues() throws BemException, MoHandlerException {
        this.updateLoadedEquipmentSupportFunctionValues();
        this.updateHubPosition();
        this.updateLoadedPowerSupplyValues();
        this.updateLoadedPowerDistributionValues();
        this.updateLoadedBatteryValues();
        this.updateLoadedClimateValues();
        this.updateLoadedEcBusValues();
    }

    private void updateHubPosition() throws BemException {
        Iterator iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            ClimateManager climateManager;
            PowerSupplyManager powerSupplyManager;
            PowerDistributionManager powerDistributionManager;
            int n = Integer.parseInt(iterator.next().toString());
            String string = BemUtil.generateCabinetKey(n);
            BatteryManager batteryManager = (BatteryManager)this.batteryManagerMap.get(string);
            if (null != batteryManager) {
                batteryManager.updateBoards("BFU");
            }
            if (null != (powerDistributionManager = (PowerDistributionManager)this.powerDistributionManagerMap.get(string))) {
                powerDistributionManager.updateBoards("PDU");
            }
            if (null != (powerSupplyManager = (PowerSupplyManager)this.powerSupplyManagerMap.get(string))) {
                powerSupplyManager.updateBoards("PSU");
            }
            if (null == (climateManager = (ClimateManager)this.climateManagerMap.get(string))) continue;
            climateManager.updateBoards("CLU");
            climateManager.updateBoards("SCU");
            climateManager.updateBoards("SUP");
        }
    }

    private void apcHWAddToList(BemMo bemMo, String string) {
        if (bemMo.getLastRDN().indexOf("PDU") > -1) {
            int n = bemMo.getLastRDN().indexOf("-") + 1;
            ((ArrayList)this.pduMap.get(string)).add(Integer.valueOf(bemMo.getLastRDN().substring(n)));
        } else if (bemMo.getLastRDN().indexOf("PSU") > -1) {
            int n = bemMo.getLastRDN().indexOf("-") + 1;
            ((ArrayList)this.psuMap.get(string)).add(Integer.valueOf(bemMo.getLastRDN().substring(n)));
        } else if (bemMo.getLastRDN().indexOf("BFU") > -1) {
            int n = bemMo.getLastRDN().indexOf("-") + 1;
            ((ArrayList)this.bfuMap.get(string)).add(Integer.valueOf(bemMo.getLastRDN().substring(n)));
        }
    }

    private void updateHWPostfixList() throws MoHandlerException, BemException {
        MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
        RDNHelper rDNHelper = RDNHelper.getInstance();
        rDNHelper.initRDNHelper();
        Iterator iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            int n;
            Object object;
            Object object2;
            int n2 = Integer.parseInt(iterator.next().toString());
            String string = BemUtil.generateCabinetKey(n2);
            this.psuMap.put(string, new ArrayList());
            this.bfuMap.put(string, new ArrayList());
            this.pduMap.put(string, new ArrayList());
            MoInstance moInstance = this.rbs.getMoiRefs().getEquipmentMoi();
            String string2 = new FixedRdnMoi(moInstance, MimCabinet.MOTYPENAME, String.valueOf(n2)).getLdn();
            BemMo bemMo = moHandlerImpl.getMo(string2);
            if (bemMo.isExisting() && (object2 = (Object[])moHandlerImpl.getAttribute(bemMo, "reservedBy")) != null && ((Object[])object2).length > 0 && object2 instanceof BemMo[]) {
                object = (BemMo[])object2;
                for (n = ((Object)object2).length - 1; n >= 0; --n) {
                    Object object3 = object[n];
                    if (!object3.getType().equals(MimHwUnit.MOTYPENAME)) continue;
                    this.apcHWAddToList((BemMo)object3, string);
                }
            }
            object2 = (ArrayList)this.pduMap.get(string);
            for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
                rDNHelper.getPduRdnList().add(((ArrayList)object2).get(i));
            }
            object = (ArrayList)this.psuMap.get(string);
            for (n = 0; n < ((ArrayList)object).size(); ++n) {
                rDNHelper.getPsuRdnList().add(((ArrayList)object).get(n));
            }
            ArrayList arrayList = (ArrayList)this.bfuMap.get(string);
            for (int i = 0; i < arrayList.size(); ++i) {
                rDNHelper.getBfuRdnList().add(arrayList.get(i));
            }
        }
    }

    private void updateLoadedEquipmentSupportFunctionValues() throws BemException {
        boolean bl = this.supportSystemManager.isSupportSystemControlInstalled();
        if (bl) {
            String string = this.supportSystemManager.getLoadedValue();
            this.supportSystemControlCustParam.setLoadedValue(string);
        } else {
            this.supportSystemControlCustParam.setLoadedValue("TRUE");
        }
    }

    private void updateLoadedClimateValues() throws BemException {
        Iterator iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            int n = Integer.parseInt(iterator.next().toString());
            String string = BemUtil.generateCabinetKey(n);
            ClimateManager climateManager = (ClimateManager)this.climateManagerMap.get(string);
            if (null == climateManager) continue;
            climateManager.updateLoadedValues();
        }
    }

    private void updateLoadedEcBusValues() throws BemException {
        for (int i = 0; i < 7; ++i) {
            if (null == this.ecBusRI[i]) continue;
            this.ecBusRI[i].updateLoadedValues();
        }
    }

    private void updateLoadedBatteryValues() throws BemException {
        Iterator iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            int n = Integer.parseInt(iterator.next().toString());
            String string = BemUtil.generateCabinetKey(n);
            BatteryManager batteryManager = (BatteryManager)this.batteryManagerMap.get(string);
            ConfigureBatteryBackupParameter configureBatteryBackupParameter = (ConfigureBatteryBackupParameter)this.confBatteryBackupCustParam.get(string);
            if (null == batteryManager) continue;
            boolean bl = batteryManager.isBatteryBackupInstalled();
            if (bl) {
                configureBatteryBackupParameter.setLoadedValue("YES");
                Integer n2 = batteryManager.getBatteryType();
                ((BatteryTypeParameter)this.batteryTypeParam.get(string)).setLoadedValue(n2);
                ((StringParameter)this.batteryInstallationDateParam.get(string)).setLoadedValue(batteryManager.getbatteryInstallationDate());
                Integer n3 = batteryManager.getChargingMode();
                configureBatteryBackupParameter.addRestriction((ParameterRestriction)this.restBatteryNoDelete.get(string));
                int n4 = ((ArrayList)this.bfuMap.get(string)).size();
                if (n4 > 0) {
                    ((NoOfBfuParameter)this.noOfBfuCustParamMap.get(string)).setLoadedValue(String.valueOf(n4));
                }
                Integer n5 = batteryManager.getTestMode();
                Boolean bl2 = batteryManager.getSharedBattery();
                ((Enumeration)this.chargingModeParam.get(string)).setLoadedValue(n3);
                ((Enumeration)this.testModeParam.get(string)).setLoadedValue(n5);
                ((TrueFalseCustomerParameter)this.sharedBatteryParam.get(string)).setLoadedValue(bl2);
                if (n5 == 1) {
                    if (bl2.booleanValue()) {
                        ((IntegerParameter)this.minimumBackupTimeParam.get(string)).setLoadedValue(batteryManager.getMinimumBackupTime());
                    } else {
                        ((IntegerParameter)this.minimumStateOfHealthParam.get(string)).setLoadedValue(batteryManager.getMinimumStateOfHealth());
                    }
                    ((IntegerParameter)this.testStartDayParam.get(string)).setLoadedValue(batteryManager.getTestStartDay());
                    ((StringParameter)this.testStartTimeParam.get(string)).setLoadedValue(batteryManager.getTestStartTime());
                    int[] nArray = batteryManager.getTestStartMonths();
                    for (int i = 0; i < 12; ++i) {
                        int n6 = i + 1;
                        boolean bl3 = false;
                        for (int j = 0; j < nArray.length; ++j) {
                            if (nArray[j] != n6) continue;
                            bl3 = true;
                            break;
                        }
                        ((YesNoCustomerParameter)((HashMap)this.testStartMonthParam.get(string)).get(new Integer(i))).setLoadedValue(bl3 ? "YES" : "NO");
                    }
                }
                if (n3 != 1) continue;
                ((IntegerParameter)this.valueChargingVoltageParameter.get(string)).setLoadedValue(batteryManager.getChargingVoltage());
                ((IntegerParameter)this.valueTempCompVoltageSlopParameter.get(string)).setLoadedValue(batteryManager.getTempCompVoltageSlop());
                ((IntegerParameter)this.valueNominalTempParameter.get(string)).setLoadedValue(batteryManager.getNominalTemp());
                ((IntegerParameter)this.valueTempCompMinVoltageParameter.get(string)).setLoadedValue(batteryManager.getTempCompMinVoltage());
                ((IntegerParameter)this.valueTempCompMaxVoltageParameter.get(string)).setLoadedValue(batteryManager.getTempCompMaxVoltage());
                ((IntegerParameter)this.valueIncreasedChargeVoltageParameter.get(string)).setLoadedValue(batteryManager.getIncreasedChargeVoltage());
                ((IntegerParameter)this.valueBoostChargeTimeParameter.get(string)).setLoadedValue(batteryManager.getBoostChargeTime());
                ((IntegerParameter)this.valueBoostChargeTriggerVoltageParameter.get(string)).setLoadedValue(batteryManager.getBoostChargeTriggerVoltage());
                ((IntegerParameter)this.valueEqualizeChargeTimeParameter.get(string)).setLoadedValue(batteryManager.getEqualizeChargeTime());
                ((IntegerParameter)this.valueEqualizeChargeCyclicIntervalParameter.get(string)).setLoadedValue(batteryManager.getEqualizeChargeCyclicInterval());
                ((IntegerParameter)this.valueIntermittentChargeConnectVoltageParameter.get(string)).setLoadedValue(batteryManager.getIntermittentChargeConnectVoltage());
                ((IntegerParameter)this.valueIntermittentChargeConnectTimeParameter.get(string)).setLoadedValue(batteryManager.getIntermittentChargeConnectTime());
                ((IntegerParameter)this.valueIntermittentChargeDisconnectTimeParameter.get(string)).setLoadedValue(batteryManager.getIntermittentChargeDisconnectTime());
                continue;
            }
            configureBatteryBackupParameter.setLoadedValue("NO");
            if (batteryManager.isBatterySupported()) continue;
            configureBatteryBackupParameter.addRestriction((ParameterRestriction)this.restBatteryIgnored.get(string));
        }
    }

    private void updateLoadedPowerSupplyValues() throws BemException {
        Iterator iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            Comparable<Boolean> comparable;
            int n = Integer.parseInt(iterator.next().toString());
            String string = BemUtil.generateCabinetKey(n);
            PowerSupplyManager powerSupplyManager = (PowerSupplyManager)this.powerSupplyManagerMap.get(string);
            ConfigurePowerSupplyParameter configurePowerSupplyParameter = (ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(string);
            if (null == powerSupplyManager) continue;
            boolean bl = powerSupplyManager.isPowerSupplyInstalled();
            if (bl) {
                comparable = (Boolean)powerSupplyManager.getAttributeValue("multiplePowerSystem");
                ((MultiplePowerSystemParameter)this.multiplePowerSystemCustParam.get(string)).setLoadedValue(comparable);
                int n2 = ((ArrayList)this.psuMap.get(string)).size();
                if (n2 > 0) {
                    NoOfPsuParameter noOfPsuParameter = (NoOfPsuParameter)this.noOfPsuCustParamMap.get(string);
                    noOfPsuParameter.setLoadedValue(String.valueOf(n2));
                    configurePowerSupplyParameter.setLoadedValue("YES");
                    configurePowerSupplyParameter.addRestriction((ParameterRestriction)this.restPowSupplyNoDelete.get(string));
                    continue;
                }
                configurePowerSupplyParameter.setLoadedValue("NO");
                continue;
            }
            configurePowerSupplyParameter.setLoadedValue("NO");
            if (powerSupplyManager.isPowerSupplySupported()) continue;
            configurePowerSupplyParameter.addRestriction((ParameterRestriction)this.restPowerSupplyIgnored.get(string));
            comparable = (NoOfPsuParameter)this.noOfPsuCustParamMap.get(string);
            ((CustomerParameterImpl)comparable).addRestriction((ParameterRestriction)this.restNoPsu.get(string));
        }
    }

    private void updateLoadedPowerDistributionValues() throws BemException {
        Iterator iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            int n = Integer.parseInt(iterator.next().toString());
            String string = BemUtil.generateCabinetKey(n);
            PowerDistributionManager powerDistributionManager = (PowerDistributionManager)this.powerDistributionManagerMap.get(string);
            NoOfPduParameter noOfPduParameter = (NoOfPduParameter)this.noOfPduCustParamMap.get(string);
            if (null == powerDistributionManager) continue;
            boolean bl = powerDistributionManager.isPowerDistributionInstalled();
            if (bl) {
                int n2 = ((ArrayList)this.pduMap.get(string)).size();
                noOfPduParameter.setLoadedValue(String.valueOf(n2));
                continue;
            }
            if (powerDistributionManager.isPowerDistributionSupported()) continue;
            noOfPduParameter.addRestriction((ParameterRestriction)this.restNoPdu.get(string));
        }
    }

    public void setCustomerParameterRestrictions() throws BemException {
        Comparable comparable;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Iterator iterator = this.climateSystemCustParam.entrySet().iterator();
        while (iterator.hasNext()) {
            object6 = iterator.next();
            object5 = object6.getKey().toString();
            object4 = (ClimateSystem)object6.getValue();
            object3 = (ClimateManager)this.climateManagerMap.get(object5);
            if (null == object3) continue;
            object2 = ((ClimateManager)object3).getClimateSystemRange();
            ((CustomerParameterImpl)object4).addRestriction(new ParameterRestriction("Allowed Range:" + ((EnumeratedRange)object2).toString(), (ParameterRange)object2, true));
        }
        object6 = this.climateRegulationSystemCustParamMap.entrySet().iterator();
        while (object6.hasNext()) {
            object5 = (Map.Entry)object6.next();
            object4 = object5.getKey().toString();
            object3 = (ClimateRegulationSystem)object5.getValue();
            object2 = (ClimateManager)this.climateManagerMap.get(object4);
            if (null == object2) continue;
            object = ((ClimateManager)object2).getClimateRegulationSystemRange();
            ((CustomerParameterImpl)object3).addRestriction(new ParameterRestriction("Allowed Range:" + ((EnumeratedRange)object).toString(), (ParameterRange)object, true));
        }
        if (this.supportSystemControlCustParam.getBooleanValue()) {
            iterator = this.rbs.getCabinetNumberList().iterator();
            while (iterator.hasNext()) {
                ConfigureBatteryBackupParameter configureBatteryBackupParameter;
                int n = Integer.parseInt(iterator.next().toString());
                object4 = BemUtil.generateCabinetKey(n);
                object3 = (NoOfPsuParameter)this.noOfPsuCustParamMap.get(object4);
                ((ClimateSystem)this.climateSystemCustParam.get(object4)).removeRestriction((ParameterRestriction)this.restClimateSystem.get(object4));
                ((ClimateRegulationSystem)this.climateRegulationSystemCustParamMap.get(object4)).removeRestriction((ParameterRestriction)this.restClimateRegulationSystem.get(object4));
                ((IntegerParameter)this.cabEcBusNoParam.get(object4)).removeRestriction((ParameterRestriction)this.restEcBusNumber.get(object4));
                object2 = (FanSpeedSupervisionParameter)this.fanSpeedSupervisionParamMap.get(object4);
                if (null != object2) {
                    ((CustomerParameterImpl)object2).removeRestriction((ParameterRestriction)this.restFanSpeedSupervision.get(object4));
                    ((CustomerParameterImpl)object2).addRestriction((ParameterRestriction)this.restOptional.get(object4));
                }
                if (null != (object = (NoOfPduParameter)this.noOfPduCustParamMap.get(object4))) {
                    ((CustomerParameterImpl)object).removeRestriction((ParameterRestriction)this.restNoPdu.get(object4));
                    ((CustomerParameterImpl)object).addRestriction((ParameterRestriction)this.restOptional.get(object4));
                }
                if (null != object3) {
                    ((CustomerParameterImpl)object3).removeRestriction((ParameterRestriction)this.restNoPsu.get(object4));
                    ((CustomerParameterImpl)object3).addRestriction((ParameterRestriction)this.restOptional.get(object4));
                }
                if (null != (comparable = (ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(object4))) {
                    comparable.removeRestriction((ParameterRestriction)this.restPowerSupplyIgnored.get(object4));
                    comparable.addRestriction((ParameterRestriction)this.restOptional.get(object4));
                }
                if (null != (configureBatteryBackupParameter = (ConfigureBatteryBackupParameter)this.confBatteryBackupCustParam.get(object4))) {
                    configureBatteryBackupParameter.removeRestriction((ParameterRestriction)this.restBatteryIgnored.get(object4));
                    configureBatteryBackupParameter.addRestriction((ParameterRestriction)this.restOptional.get(object4));
                }
                if (null == this.smokeDetectorParam) continue;
                ((SmokeDetectorParameter)this.smokeDetectorParam.get(object4)).removeRestriction((ParameterRestriction)this.restSmokeDetectorIgnored.get(object4));
            }
        } else {
            iterator = this.rbs.getCabinetNumberList().iterator();
            while (iterator.hasNext()) {
                int n = Integer.parseInt(iterator.next().toString());
                object4 = BemUtil.generateCabinetKey(n);
                object3 = (NoOfPsuParameter)this.noOfPsuCustParamMap.get(object4);
                ((ClimateSystem)this.climateSystemCustParam.get(object4)).addRestriction((ParameterRestriction)this.restClimateSystem.get(object4));
                ((ClimateRegulationSystem)this.climateRegulationSystemCustParamMap.get(object4)).addRestriction((ParameterRestriction)this.restClimateRegulationSystem.get(object4));
                ((IntegerParameter)this.cabEcBusNoParam.get(object4)).addRestriction((ParameterRestriction)this.restEcBusNumber.get(object4));
                object2 = (NoOfPduParameter)this.noOfPduCustParamMap.get(object4);
                if (null != object2) {
                    ((CustomerParameterImpl)object2).addRestriction((ParameterRestriction)this.restNoPdu.get(object4));
                    ((CustomerParameterImpl)object2).removeRestriction((ParameterRestriction)this.restOptional.get(object4));
                }
                if (null != object3) {
                    ((CustomerParameterImpl)object3).addRestriction((ParameterRestriction)this.restNoPsu.get(object4));
                    ((CustomerParameterImpl)object3).removeRestriction((ParameterRestriction)this.restOptional.get(object4));
                }
                if (null != (object = (ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(object4))) {
                    ((CustomerParameterImpl)object).removeRestriction((ParameterRestriction)this.restOptional.get(object4));
                    ((CustomerParameterImpl)object).addRestriction((ParameterRestriction)this.restPowerSupplyIgnored.get(object4));
                }
                if (null != (comparable = (ConfigureBatteryBackupParameter)this.confBatteryBackupCustParam.get(object4))) {
                    comparable.removeRestriction((ParameterRestriction)this.restOptional.get(object4));
                    comparable.addRestriction((ParameterRestriction)this.restBatteryIgnored.get(object4));
                }
                if (null == this.smokeDetectorParam.get(object4)) continue;
                ((SmokeDetectorParameter)this.smokeDetectorParam.get(object4)).addRestriction((ParameterRestriction)this.restSmokeDetectorIgnored.get(object4));
            }
        }
        this.addRestrictionsForBatteryBackupCPs();
        this.addRestrictionForStateOfHealthParam();
        this.addRestrictionForMinimumBackupTime();
        this.addRestrictionsForTestModeRelatedCPs();
        this.addRestrictionForChargingModeRelatedCPs();
        iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            int n = Integer.parseInt(iterator.next().toString());
            this.setRestrictionsForBatteryBackupCPs(this.supportSystemControlCustParam.getBooleanValue(), n);
        }
        iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            int n = Integer.parseInt(iterator.next().toString());
            object4 = BemUtil.generateCabinetKey(n);
            object3 = (PowerSupplyManager)this.powerSupplyManagerMap.get(object4);
            if (null != object3) {
                this.psuRange.put(object4, ((PowerSupplyManager)object3).getPsuRange());
            }
            if (null != (object2 = (PowerDistributionManager)this.powerDistributionManagerMap.get(object4))) {
                this.pduRange.put(object4, ((PowerDistributionManager)object2).getPduRange());
            }
            if (this.psuRange.get(object4) != null) {
                object = (NoOfPsuParameter)this.noOfPsuCustParamMap.get(object4);
                ((CustomerParameterImpl)object).addRestriction((ParameterRestriction)this.restPowSupplyModifyPsu.get(object4));
                ((ParameterRestriction)this.restPowSupplyModifyPsu.get(object4)).setActive(false);
                if ("NO".equals(((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(object4)).getValue())) {
                    ((CustomerParameterImpl)object).addRestriction((ParameterRestriction)this.restNoPsu.get(object4));
                    if (this.getRbs().getRbsStep().equals("STEP_EXPANSION")) {
                        ((ParameterRestriction)this.restPowSupplyModifyPsu.get(object4)).setActive(true);
                        ((CustomerParameterImpl)object).setLoadedValue("0");
                        ((CustomerParameterImpl)object).setDefaultValue("0");
                        ((CustomerParameterImpl)object).setValue("0");
                    }
                } else {
                    ((CustomerParameterImpl)object).removeRestriction((ParameterRestriction)this.restNoPsu.get(object4));
                    ((ParameterRestriction)this.restPowSupplyModifyPsu.get(object4)).setActive(false);
                }
                comparable = this.rbs.isSiteWiz() ? new Integer(((ArrayList)this.psuMap.get(object4)).size()) : ((IntegerRange)this.psuRange.get(object4)).getMinValue();
                this.psuRange.put(object4, new IntegerRange((Integer)comparable, ((IntegerRange)this.psuRange.get(object4)).getMaxValue()));
                ((CustomerParameterImpl)object).addRestriction(new ParameterRestriction("Cannot delete existing PSUs", (IntegerRange)this.psuRange.get(object4), true));
            }
            if (this.pduRange.get(object4) == null) continue;
            object = this.rbs.isSiteWiz() ? new Integer(((ArrayList)this.pduMap.get(object4)).size()) : ((IntegerRange)this.pduRange.get(object4)).getMinValue();
            this.pduRange.put(object4, new IntegerRange((Integer)object, ((IntegerRange)this.pduRange.get(object4)).getMaxValue()));
            ((NoOfPduParameter)this.noOfPduCustParamMap.get(object4)).addRestriction(new ParameterRestriction("Cannot delete existing PDUs", (IntegerRange)this.pduRange.get(object4), true));
        }
    }

    private void addRestrictionsForBatteryBackupCPs() throws BemException {
        Iterator iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            Object object;
            BatteryManager batteryManager;
            int n = Integer.parseInt(iterator.next().toString());
            String string = BemUtil.generateCabinetKey(n);
            BatteryTypeParameter batteryTypeParameter = (BatteryTypeParameter)this.batteryTypeParam.get(string);
            StringParameter stringParameter = (StringParameter)this.batteryInstallationDateParam.get(string);
            if (null != batteryTypeParameter) {
                batteryTypeParameter.addRestriction((ParameterRestriction)this.restBatteryType.get(string));
                batteryTypeParameter.addRestriction((ParameterRestriction)this.restBatteryTypeOptional.get(string));
            }
            MultiplePowerSystemParameter multiplePowerSystemParameter = (MultiplePowerSystemParameter)this.multiplePowerSystemCustParam.get(string);
            multiplePowerSystemParameter.addRestriction((ParameterRestriction)this.restMultiplePowerSystem.get(string));
            multiplePowerSystemParameter.addRestriction((ParameterRestriction)this.restMultiplePowerSystemOptional.get(string));
            if (null != stringParameter) {
                stringParameter.addRestriction((ParameterRestriction)this.restBatteryInstallationDate.get(string));
                stringParameter.addRestriction((ParameterRestriction)this.restBatteryTypeOptional.get(string));
                stringParameter.addRestriction((ParameterRestriction)this.restOptional.get(string));
            }
            if (null != (batteryManager = (BatteryManager)this.batteryManagerMap.get(string))) {
                object = batteryManager.getBfuRange();
                this.bfuRange.put(string, object);
                this.restRangeNoOfBfu.put(string, new ParameterRestriction("Cannot delete existing BFUs", (IntegerRange)this.bfuRange.get(string), true));
                ((ParameterRestriction)this.restRangeNoOfBfu.get(string)).setRange((ParameterRange)object, true);
            }
            if (null != (object = (NoOfBfuParameter)this.noOfBfuCustParamMap.get(string))) {
                ((CustomerParameterImpl)object).addRestriction((ParameterRestriction)this.restRangeNoOfBfu.get(string));
                ((CustomerParameterImpl)object).addRestriction((ParameterRestriction)this.restNoBfu.get(string));
                ((CustomerParameterImpl)object).addRestriction((ParameterRestriction)this.restOptional.get(string));
            }
            TrueFalseCustomerParameter trueFalseCustomerParameter = (TrueFalseCustomerParameter)this.sharedBatteryParam.get(string);
            Enumeration enumeration = (Enumeration)this.chargingModeParam.get(string);
            Enumeration enumeration2 = (Enumeration)this.testModeParam.get(string);
            IntegerParameter integerParameter = (IntegerParameter)this.minimumStateOfHealthParam.get(string);
            IntegerParameter integerParameter2 = (IntegerParameter)this.minimumBackupTimeParam.get(string);
            IntegerParameter integerParameter3 = (IntegerParameter)this.testStartDayParam.get(string);
            StringParameter stringParameter2 = (StringParameter)this.testStartTimeParam.get(string);
            ParameterRestriction parameterRestriction = (ParameterRestriction)this.restBatteryBackupAttributes.get(string);
            trueFalseCustomerParameter.addRestriction(parameterRestriction);
            enumeration.addRestriction(parameterRestriction);
            enumeration2.addRestriction(parameterRestriction);
            integerParameter2.addRestriction(parameterRestriction);
            integerParameter.addRestriction(parameterRestriction);
            integerParameter3.addRestriction(parameterRestriction);
            stringParameter2.addRestriction(parameterRestriction);
            ParameterRestriction parameterRestriction2 = (ParameterRestriction)this.restOptional.get(string);
            trueFalseCustomerParameter.addRestriction(parameterRestriction2);
            enumeration.addRestriction(parameterRestriction2);
            enumeration2.addRestriction(parameterRestriction2);
            integerParameter2.addRestriction(parameterRestriction2);
            integerParameter.addRestriction(parameterRestriction2);
            integerParameter3.addRestriction(parameterRestriction2);
            stringParameter2.addRestriction(parameterRestriction2);
            for (int i = 0; i < 12; ++i) {
                ((YesNoCustomerParameter)((HashMap)this.testStartMonthParam.get(string)).get(new Integer(i))).addRestriction(parameterRestriction);
                ((YesNoCustomerParameter)((HashMap)this.testStartMonthParam.get(string)).get(new Integer(i))).addRestriction(parameterRestriction2);
            }
        }
    }

    private void setRestrictionsForBatteryBackupCPs(boolean bl, int n) {
        String string = BemUtil.generateCabinetKey(n);
        ConfigureBatteryBackupParameter configureBatteryBackupParameter = (ConfigureBatteryBackupParameter)this.confBatteryBackupCustParam.get(string);
        ParameterRestriction parameterRestriction = (ParameterRestriction)this.restBatteryType.get(string);
        ParameterRestriction parameterRestriction2 = (ParameterRestriction)this.restBatteryTypeOptional.get(string);
        ParameterRestriction parameterRestriction3 = (ParameterRestriction)this.restBatteryInstallationDate.get(string);
        ParameterRestriction parameterRestriction4 = (ParameterRestriction)this.restNoBfu.get(string);
        ParameterRestriction parameterRestriction5 = (ParameterRestriction)this.restBatteryBackupAttributes.get(string);
        ParameterRestriction parameterRestriction6 = (ParameterRestriction)this.restRangeNoOfBfu.get(string);
        if (!bl) {
            parameterRestriction.setActive(true);
            parameterRestriction2.setActive(true);
            parameterRestriction3.setActive(true);
            parameterRestriction4.setActive(true);
            parameterRestriction5.setActive(true);
        } else if (configureBatteryBackupParameter != null && configureBatteryBackupParameter.getValue().equals("YES")) {
            parameterRestriction.setActive(false);
            parameterRestriction2.setActive(true);
            parameterRestriction3.setActive(false);
            parameterRestriction6.setActive(true);
            parameterRestriction4.setActive(false);
            parameterRestriction5.setActive(false);
            this.setRestrictionForSharedBattery(n);
            this.setRestrictionForTestMode(n);
            this.setRestrictionForChargingMode(n);
        } else {
            parameterRestriction.setActive(true);
            parameterRestriction2.setActive(false);
            parameterRestriction3.setActive(true);
            if (null != parameterRestriction6) {
                parameterRestriction6.setActive(false);
            }
            parameterRestriction4.setActive(true);
            parameterRestriction5.setActive(true);
        }
    }

    private void addRestrictionForStateOfHealthParam() {
        Iterator iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            int n = Integer.parseInt(iterator.next().toString());
            String string = BemUtil.generateCabinetKey(n);
            ((IntegerParameter)this.minimumStateOfHealthParam.get(string)).addRestriction((ParameterRestriction)this.restMinimumStateOfHealth.get(string));
        }
    }

    private void setRestrictionForSharedBattery(int n) {
        String string = BemUtil.generateCabinetKey(n);
        if (((TrueFalseCustomerParameter)this.sharedBatteryParam.get(string)).getValue().equals("TRUE")) {
            ((ParameterRestriction)this.restMinimumStateOfHealth.get(string)).setActive(true);
            ((ParameterRestriction)this.restMinimumBackupTime.get(string)).setActive(false);
        } else {
            ((ParameterRestriction)this.restMinimumStateOfHealth.get(string)).setActive(false);
            ((ParameterRestriction)this.restMinimumBackupTime.get(string)).setActive(true);
        }
    }

    private void setRestrictionForTestMode(int n) {
        String string = BemUtil.generateCabinetKey(n);
        Enumeration enumeration = (Enumeration)this.testModeParam.get(string);
        if ((Integer)enumeration.getValueMom() == 1) {
            ((ParameterRestriction)this.restTestModeRelatedCPs.get(string)).setActive(false);
        } else {
            ((ParameterRestriction)this.restTestModeRelatedCPs.get(string)).setActive(true);
        }
    }

    private void setRestrictionForChargingMode(int n) {
        String string = BemUtil.generateCabinetKey(n);
        Enumeration enumeration = (Enumeration)this.chargingModeParam.get(string);
        if ((Integer)enumeration.getValueMom() == 1) {
            ((ParameterRestriction)this.restChargingModeRelatedCPs.get(string)).setActive(false);
        } else {
            ((ParameterRestriction)this.restChargingModeRelatedCPs.get(string)).setActive(true);
        }
    }

    private void addRestrictionsForTestModeRelatedCPs() {
        Iterator iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            int n = Integer.parseInt(iterator.next().toString());
            String string = BemUtil.generateCabinetKey(n);
            ((IntegerParameter)this.testStartDayParam.get(string)).addRestriction((ParameterRestriction)this.restTestModeRelatedCPs.get(string));
            ((StringParameter)this.testStartTimeParam.get(string)).addRestriction((ParameterRestriction)this.restTestModeRelatedCPs.get(string));
            for (int i = 0; i < 12; ++i) {
                ((YesNoCustomerParameter)((HashMap)this.testStartMonthParam.get(string)).get(new Integer(i))).addRestriction((ParameterRestriction)this.restTestModeRelatedCPs.get(string));
            }
            ((IntegerParameter)this.minimumBackupTimeParam.get(string)).addRestriction((ParameterRestriction)this.restTestModeRelatedCPs.get(string));
            ((IntegerParameter)this.minimumStateOfHealthParam.get(string)).addRestriction((ParameterRestriction)this.restTestModeRelatedCPs.get(string));
        }
    }

    private void addRestrictionForChargingModeRelatedCPs() {
        Iterator iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            int n = Integer.parseInt(iterator.next().toString());
            String string = BemUtil.generateCabinetKey(n);
            IntegerParameter integerParameter = (IntegerParameter)this.valueChargingVoltageParameter.get(string);
            IntegerParameter integerParameter2 = (IntegerParameter)this.valueTempCompVoltageSlopParameter.get(string);
            IntegerParameter integerParameter3 = (IntegerParameter)this.valueNominalTempParameter.get(string);
            IntegerParameter integerParameter4 = (IntegerParameter)this.valueTempCompMinVoltageParameter.get(string);
            IntegerParameter integerParameter5 = (IntegerParameter)this.valueTempCompMaxVoltageParameter.get(string);
            IntegerParameter integerParameter6 = (IntegerParameter)this.valueIncreasedChargeVoltageParameter.get(string);
            IntegerParameter integerParameter7 = (IntegerParameter)this.valueBoostChargeTimeParameter.get(string);
            IntegerParameter integerParameter8 = (IntegerParameter)this.valueBoostChargeTriggerVoltageParameter.get(string);
            IntegerParameter integerParameter9 = (IntegerParameter)this.valueEqualizeChargeTimeParameter.get(string);
            IntegerParameter integerParameter10 = (IntegerParameter)this.valueEqualizeChargeCyclicIntervalParameter.get(string);
            IntegerParameter integerParameter11 = (IntegerParameter)this.valueIntermittentChargeConnectVoltageParameter.get(string);
            IntegerParameter integerParameter12 = (IntegerParameter)this.valueIntermittentChargeConnectTimeParameter.get(string);
            IntegerParameter integerParameter13 = (IntegerParameter)this.valueIntermittentChargeDisconnectTimeParameter.get(string);
            ParameterRestriction parameterRestriction = (ParameterRestriction)this.restOptional.get(string);
            integerParameter.addRestriction(parameterRestriction);
            integerParameter2.addRestriction(parameterRestriction);
            integerParameter3.addRestriction(parameterRestriction);
            integerParameter4.addRestriction(parameterRestriction);
            integerParameter5.addRestriction(parameterRestriction);
            integerParameter6.addRestriction(parameterRestriction);
            integerParameter7.addRestriction(parameterRestriction);
            integerParameter8.addRestriction(parameterRestriction);
            integerParameter9.addRestriction(parameterRestriction);
            integerParameter10.addRestriction(parameterRestriction);
            integerParameter11.addRestriction(parameterRestriction);
            integerParameter12.addRestriction(parameterRestriction);
            integerParameter13.addRestriction(parameterRestriction);
            ParameterRestriction parameterRestriction2 = (ParameterRestriction)this.restChargingModeRelatedCPs.get(string);
            integerParameter.addRestriction(parameterRestriction2);
            integerParameter2.addRestriction(parameterRestriction2);
            integerParameter3.addRestriction(parameterRestriction2);
            integerParameter4.addRestriction(parameterRestriction2);
            integerParameter5.addRestriction(parameterRestriction2);
            integerParameter6.addRestriction(parameterRestriction2);
            integerParameter7.addRestriction(parameterRestriction2);
            integerParameter8.addRestriction(parameterRestriction2);
            integerParameter9.addRestriction(parameterRestriction2);
            integerParameter10.addRestriction(parameterRestriction2);
            integerParameter11.addRestriction(parameterRestriction2);
            integerParameter12.addRestriction(parameterRestriction2);
            integerParameter13.addRestriction(parameterRestriction2);
        }
    }

    private void addRestrictionForMinimumBackupTime() {
        Iterator iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            int n = Integer.parseInt(iterator.next().toString());
            String string = BemUtil.generateCabinetKey(n);
            ((IntegerParameter)this.minimumBackupTimeParam.get(string)).addRestriction((ParameterRestriction)this.restMinimumBackupTime.get(string));
        }
    }

    protected void setCustomerParameterListeners() {
        this.supportSystemControlCustParam.addCustomerParameterListener(this);
        Iterator iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            int n = Integer.parseInt(iterator.next().toString());
            String string = BemUtil.generateCabinetKey(n);
            ((MultiplePowerSystemParameter)this.multiplePowerSystemCustParam.get(string)).addCustomerParameterListener(this);
            ((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(string)).addCustomerParameterListener(this);
            ((ConfigureBatteryBackupParameter)this.confBatteryBackupCustParam.get(string)).addCustomerParameterListener(this);
            ((BatteryTypeParameter)this.batteryTypeParam.get(string)).addCustomerParameterListener(this);
            ((TrueFalseCustomerParameter)this.sharedBatteryParam.get(string)).addCustomerParameterListener(this);
            ((Enumeration)this.testModeParam.get(string)).addCustomerParameterListener(this);
            ((Enumeration)this.chargingModeParam.get(string)).addCustomerParameterListener(this);
            ((ClimateSystem)this.climateSystemCustParam.get(string)).addCustomerParameterListener(this);
            ((ClimateRegulationSystem)this.climateRegulationSystemCustParamMap.get(string)).addCustomerParameterListener(this);
            ((SmokeDetectorParameter)this.smokeDetectorParam.get(string)).addCustomerParameterListener(this);
            if (null == this.fanSpeedSupervisionParamMap.get(string)) continue;
            ((FanSpeedSupervisionParameter)this.fanSpeedSupervisionParamMap.get(string)).addCustomerParameterListener(this);
        }
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        if (parameterEvent.isValueChanged()) {
            String string = customerParameter.getName();
            Iterator iterator = this.rbs.getCabinetNumberList().iterator();
            while (iterator.hasNext()) {
                String string2;
                int n = Integer.parseInt(iterator.next().toString());
                String string3 = BemUtil.generateCabinetKey(n);
                FanSpeedSupervisionParameter fanSpeedSupervisionParameter = (FanSpeedSupervisionParameter)this.fanSpeedSupervisionParamMap.get(string3);
                NoOfPsuParameter noOfPsuParameter = (NoOfPsuParameter)this.noOfPsuCustParamMap.get(string3);
                NoOfPduParameter noOfPduParameter = (NoOfPduParameter)this.noOfPduCustParamMap.get(string3);
                ConfigurePowerSupplyParameter configurePowerSupplyParameter = (ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(string3);
                ConfigurePowerSupplyParameter configurePowerSupplyParameter2 = (ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(string3);
                ConfigureBatteryBackupParameter configureBatteryBackupParameter = (ConfigureBatteryBackupParameter)this.confBatteryBackupCustParam.get(string3);
                ClimateSystem climateSystem = (ClimateSystem)this.climateSystemCustParam.get(string3);
                ClimateRegulationSystem climateRegulationSystem = (ClimateRegulationSystem)this.climateRegulationSystemCustParamMap.get(string3);
                SmokeDetectorParameter smokeDetectorParameter = (SmokeDetectorParameter)this.smokeDetectorParam.get(string3);
                TrueFalseCustomerParameter trueFalseCustomerParameter = (TrueFalseCustomerParameter)this.sharedBatteryParam.get(string3);
                Enumeration enumeration = (Enumeration)this.chargingModeParam.get(string3);
                Enumeration enumeration2 = (Enumeration)this.testModeParam.get(string3);
                ParameterRestriction parameterRestriction = (ParameterRestriction)this.restFanSpeedSupervision.get(string3);
                ParameterRestriction parameterRestriction2 = (ParameterRestriction)this.restNoPsu.get(string3);
                ParameterRestriction parameterRestriction3 = (ParameterRestriction)this.restOptional.get(string3);
                ParameterRestriction parameterRestriction4 = (ParameterRestriction)this.restClimateRegulationSystem.get(string3);
                ParameterRestriction parameterRestriction5 = (ParameterRestriction)this.restClimateSystem.get(string3);
                ParameterRestriction parameterRestriction6 = (ParameterRestriction)this.restBatteryIgnored.get(string3);
                ParameterRestriction parameterRestriction7 = (ParameterRestriction)this.restSmokeDetectorIgnored.get(string3);
                ParameterRestriction parameterRestriction8 = (ParameterRestriction)this.restPowerSupplyIgnored.get(string3);
                ParameterRestriction parameterRestriction9 = (ParameterRestriction)this.restNoPdu.get(string3);
                if (configurePowerSupplyParameter != null && string.equalsIgnoreCase(configurePowerSupplyParameter.getName())) {
                    string2 = configurePowerSupplyParameter.getValue();
                    if ("YES".equalsIgnoreCase(string2)) {
                        if (this.rbs.getRbsStep().equals("STEP_EXPANSION")) {
                            ((ParameterRestriction)this.restPowSupplyModifyPsu.get(string3)).setActive(false);
                        }
                        if (noOfPsuParameter == null) continue;
                        noOfPsuParameter.removeRestriction(parameterRestriction2);
                        noOfPsuParameter.addRestriction(parameterRestriction3);
                        continue;
                    }
                    if (this.rbs.getRbsStep().equals("STEP_EXPANSION")) {
                        ((ParameterRestriction)this.restPowSupplyModifyPsu.get(string3)).setActive(true);
                    }
                    if (noOfPsuParameter == null) continue;
                    noOfPsuParameter.addRestriction(parameterRestriction2);
                    noOfPsuParameter.removeRestriction(parameterRestriction3);
                    continue;
                }
                if (this.supportSystemControlCustParam != null && string.equalsIgnoreCase(this.supportSystemControlCustParam.getName())) {
                    string2 = this.supportSystemControlCustParam.getValue();
                    if ("FALSE".equalsIgnoreCase(string2)) {
                        if (climateSystem != null) {
                            climateSystem.addRestriction(parameterRestriction5);
                        }
                        if (null != climateRegulationSystem) {
                            climateRegulationSystem.addRestriction(parameterRestriction4);
                        }
                        if (configurePowerSupplyParameter2 != null) {
                            configurePowerSupplyParameter2.addRestriction(parameterRestriction8);
                        }
                        if (smokeDetectorParameter != null) {
                            smokeDetectorParameter.addRestriction(parameterRestriction7);
                        }
                        if (configureBatteryBackupParameter != null) {
                            configureBatteryBackupParameter.addRestriction(parameterRestriction6);
                        }
                        if (noOfPduParameter != null) {
                            noOfPduParameter.addRestriction(parameterRestriction9);
                            noOfPduParameter.removeRestriction(parameterRestriction3);
                        }
                        if (noOfPsuParameter != null) {
                            noOfPsuParameter.addRestriction(parameterRestriction2);
                            noOfPsuParameter.removeRestriction(parameterRestriction3);
                        }
                        if (configurePowerSupplyParameter2 != null) {
                            configurePowerSupplyParameter2.removeRestriction(parameterRestriction3);
                        }
                        if (configureBatteryBackupParameter != null) {
                            configureBatteryBackupParameter.removeRestriction(parameterRestriction3);
                        }
                        if (fanSpeedSupervisionParameter != null) {
                            fanSpeedSupervisionParameter.addRestriction(parameterRestriction);
                            fanSpeedSupervisionParameter.removeRestriction(parameterRestriction3);
                        }
                        this.setRestrictionsForBatteryBackupCPs(false, n);
                        continue;
                    }
                    if (climateSystem != null) {
                        climateSystem.removeRestriction(parameterRestriction5);
                    }
                    if (null != climateRegulationSystem) {
                        climateRegulationSystem.addRestriction(parameterRestriction4);
                    }
                    if (configurePowerSupplyParameter2 != null) {
                        configurePowerSupplyParameter2.removeRestriction(parameterRestriction8);
                    }
                    if (smokeDetectorParameter != null) {
                        smokeDetectorParameter.removeRestriction(parameterRestriction7);
                    }
                    if (configureBatteryBackupParameter != null) {
                        configureBatteryBackupParameter.removeRestriction(parameterRestriction6);
                    }
                    if (noOfPduParameter != null) {
                        noOfPduParameter.removeRestriction(parameterRestriction9);
                        noOfPduParameter.addRestriction(parameterRestriction3);
                    }
                    if (noOfPsuParameter != null) {
                        noOfPsuParameter.removeRestriction(parameterRestriction2);
                        noOfPsuParameter.addRestriction(parameterRestriction3);
                    }
                    if (configurePowerSupplyParameter2 != null) {
                        configurePowerSupplyParameter2.addRestriction(parameterRestriction3);
                    }
                    if (configureBatteryBackupParameter != null) {
                        configureBatteryBackupParameter.addRestriction(parameterRestriction3);
                    }
                    if (fanSpeedSupervisionParameter != null) {
                        fanSpeedSupervisionParameter.removeRestriction(parameterRestriction);
                        fanSpeedSupervisionParameter.addRestriction(parameterRestriction3);
                    }
                    this.setRestrictionsForBatteryBackupCPs(true, n);
                    continue;
                }
                if (configureBatteryBackupParameter != null && string.equalsIgnoreCase(configureBatteryBackupParameter.getName())) {
                    this.setRestrictionsForBatteryBackupCPs(this.supportSystemControlCustParam.getBooleanValue(), n);
                    continue;
                }
                if (trueFalseCustomerParameter != null && string.equalsIgnoreCase(trueFalseCustomerParameter.getName())) {
                    this.setRestrictionForSharedBattery(n);
                    continue;
                }
                if (enumeration2 != null && string.equalsIgnoreCase(enumeration2.getName())) {
                    this.setRestrictionForTestMode(n);
                    continue;
                }
                if (enumeration == null || !string.equalsIgnoreCase(enumeration.getName())) continue;
                this.setRestrictionForChargingMode(n);
            }
        }
    }

    public List getRIsToUninstall() throws BemException {
        int n;
        if (!this.isOpen) {
            throw new BemException("getRIsToBeUnInstalled : CI not open");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList arrayList2 = null;
        Iterator iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            Object object;
            BemMo[] bemMoArray;
            Object object2;
            Object object3;
            String string;
            IntegerParameter integerParameter;
            n = Integer.parseInt(iterator.next().toString());
            String string2 = BemUtil.generateCabinetKey(n);
            NoOfPsuParameter noOfPsuParameter = (NoOfPsuParameter)this.noOfPsuCustParamMap.get(string2);
            NoOfBfuParameter noOfBfuParameter = (NoOfBfuParameter)this.noOfBfuCustParamMap.get(string2);
            NoOfPduParameter noOfPduParameter = (NoOfPduParameter)this.noOfPduCustParamMap.get(string2);
            ClimateManager climateManager = (ClimateManager)this.climateManagerMap.get(string2);
            if (null != climateManager) {
                arrayList.addAll(climateManager.getRIsToBeUnInstalled());
            }
            if (!(integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject((string = PrefixUtil.getDeleteCabinetPrefix(String.valueOf(n))) + "cabinetNumber")).getValue().equals("##UNDEFINED") && !((CustomerParameterImpl)(object3 = (IntegerParameter)this.rbs.getCustomerParameterObject((String)(object2 = PrefixUtil.getCabinetPrefix(String.valueOf(n)) + "ecBusNumber")))).getValue().equals("##UNDEFINED") && (bemMoArray = ((EcBusRI)(object = this.ecBusRI[Integer.valueOf(((CustomerParameterImpl)object3).getValue()) - 1])).getEcBusReservedByObjects()) != null && bemMoArray.length == 1) {
                arrayList.add(object);
            }
            if (null != (object2 = (PowerSupplyManager)this.powerSupplyManagerMap.get(string2)) && noOfPsuParameter.getValue() != "##UNDEFINED") {
                object3 = noOfPsuParameter.getValue();
                int n2 = Integer.parseInt((String)object3);
                arrayList2 = ((PowerSupplyManager)object2).getRIsToUninstall(n2, (ArrayList)this.psuMap.get(string2));
                arrayList.addAll(arrayList2);
            }
            if (null != (object3 = (BatteryManager)this.batteryManagerMap.get(string2)) && ((BatteryManager)object3).isBatterySupported() && noOfBfuParameter.getValue() != "##UNDEFINED") {
                object = noOfBfuParameter.getValue();
                int n3 = Integer.parseInt((String)object);
                arrayList2 = ((BatteryManager)object3).getRIsToUninstall(n3, (ArrayList)this.bfuMap.get(string2));
                arrayList.addAll(arrayList2);
            }
            if (null == (object = (PowerDistributionManager)this.powerDistributionManagerMap.get(string2)) || noOfPduParameter.getValue() == "##UNDEFINED") continue;
            bemMoArray = noOfPduParameter.getValue();
            int n4 = Integer.parseInt((String)bemMoArray);
            arrayList2 = ((PowerDistributionManager)object).getRIsToUninstall(n4, (ArrayList)this.pduMap.get(string2));
            arrayList.addAll(arrayList2);
        }
        arrayList.addAll(this.supportSystemManager.getRIsToUninstall());
        if ("FALSE".equals(this.rbs.getCustomerParameter("supportSystemControl"))) {
            for (n = 1; n < 7; ++n) {
                if (this.ecBusRI[n] == null) continue;
                arrayList.add(this.ecBusRI[n]);
            }
        }
        arrayList.addAll(this.hwGroupRIs);
        return arrayList;
    }

    /*
     * Could not resolve type clashes
     */
    public ArrayList getNeededRIs() throws BemException {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        String string;
        int n;
        Iterator iterator;
        if (!this.isOpen) {
            throw new BemException("getRIsToBeInstalled: CI not open");
        }
        ArrayList arrayList = new ArrayList();
        this.checkConsistency();
        arrayList.addAll(this.supportSystemManager.getRIsToBeInstalled());
        String string2 = this.supportSystemControlCustParam.getValue();
        if (string2.equalsIgnoreCase("TRUE")) {
            iterator = this.rbs.getCabinetNumberList().iterator();
            while (iterator.hasNext()) {
                BatteryManager batteryManager;
                Object object4;
                n = Integer.parseInt(iterator.next().toString());
                string = BemUtil.generateCabinetKey(n);
                if (PowerSystemUtil.isContainDelCabinetCp(this.rbs, n)) continue;
                object3 = (PowerSupplyManager)this.powerSupplyManagerMap.get(string);
                if (null != object3 && ((PowerSupplyManager)object3).isPowerSupplySupported()) {
                    object2 = ((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(string)).getValue();
                    boolean bl2 = ((String)object2).equalsIgnoreCase("YES");
                    object = ((NoOfPsuParameter)this.noOfPsuCustParamMap.get(string)).getValue();
                    if (1 == n || null != object && !((String)object).equalsIgnoreCase("##UNDEFINED") && !((String)object).equalsIgnoreCase("0")) {
                        bl = Integer.parseInt((String)object);
                        object4 = ((PowerSupplyManager)object3).getRIsToBeInstalled(bl2, bl ? 1 : 0, (List)this.psuMap.get(string));
                        this.setUnitInfo4MulCab((ArrayList)object4, n);
                        arrayList.addAll(object4);
                    }
                }
                if (null != (object2 = (PowerDistributionManager)this.powerDistributionManagerMap.get(string)) && ((PowerDistributionManager)object2).isPowerDistributionSupported()) {
                    String string3 = ((NoOfPduParameter)this.noOfPduCustParamMap.get(string)).getValue();
                    if (1 == n || null != string3 && !string3.equalsIgnoreCase("##UNDEFINED") && !string3.equalsIgnoreCase("0")) {
                        int n2 = Integer.parseInt(string3);
                        ArrayList arrayList2 = ((PowerDistributionManager)object2).getRIsToBeInstalled(true, n2, (List)this.pduMap.get(string));
                        this.setUnitInfo4MulCab(arrayList2, n);
                        arrayList.addAll(arrayList2);
                    }
                }
                if (null == (batteryManager = (BatteryManager)this.batteryManagerMap.get(string)) || !batteryManager.isBatterySupported()) continue;
                object = ((ConfigureBatteryBackupParameter)this.confBatteryBackupCustParam.get(string)).getValue();
                bl = ((String)object).equalsIgnoreCase("YES");
                object4 = ((NoOfBfuParameter)this.noOfBfuCustParamMap.get(string)).getValue();
                if (1 != n && (null == object4 || ((String)object4).equalsIgnoreCase("##UNDEFINED") || ((String)object4).equalsIgnoreCase("0"))) continue;
                int n3 = Integer.parseInt((String)object4);
                ArrayList arrayList3 = batteryManager.getRIsToBeInstalled(bl, n3, (ArrayList)this.bfuMap.get(string));
                this.setUnitInfo4MulCab(arrayList3, n);
                arrayList.addAll(arrayList3);
            }
        }
        iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            n = Integer.parseInt(iterator.next().toString());
            if (PowerSystemUtil.isContainDelCabinetCp(this.rbs, n) || null == (object3 = (ClimateManager)this.climateManagerMap.get(string = BemUtil.generateCabinetKey(n)))) continue;
            object2 = (CustomerParameter)this.confBatteryBackupCustParam.get(string);
            boolean bl3 = object2 == null ? false : object2.getValue().equalsIgnoreCase("YES");
            object = (BatteryManager)this.batteryManagerMap.get(string);
            bl = object == null ? false : ((BatteryManager)object).isBatterySupported();
            ((ClimateManager)object3).setBatteryInfoForClimate(bl3, bl);
            arrayList.addAll(((ClimateManager)object3).getRIsToBeInstalled());
        }
        this.addEcBusRI(arrayList);
        arrayList.addAll(this.hwGroupRIs);
        return arrayList;
    }

    private void addEcBusRI(ArrayList arrayList) throws BemException {
        arrayList.add(this.ecBusRI[0]);
        if (DuwUtil.isDualBoxConfiguration(this.rbs.getRbsType())) {
            arrayList.add(this.ecBusRI[1]);
        } else {
            RadioEquipmentProvider radioEquipmentProvider = (RadioEquipmentProvider)this.rbs.getProvider(RadioEquipmentProvider.class);
            for (int i = 1; i < 7; ++i) {
                boolean bl;
                int n = i + 1;
                String string = MessageFormat.format("EcBus{0}_", new Integer(n));
                String string2 = MessageFormat.format("ModEcBus{0}_", new Integer(n));
                if (!this.rbs.isParameterSupported(string + "connectorUnitNumber") && !this.rbs.isParameterSupported(string2 + "connectorUnitNumber")) continue;
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string + "connectorUnitNumber");
                CustomerParameter customerParameter2 = this.rbs.getCustomerParameterObject(string2 + "connectorUnitNumber");
                boolean bl2 = bl = !customerParameter2.getValue().equals("##UNDEFINED");
                if (!bl && (customerParameter.getValue().equals("##UNDEFINED") || !customerParameter.hasValueChanged())) continue;
                String string3 = bl ? string2 : string;
                int n2 = Integer.parseInt(this.rbs.getCustomerParameter(string3 + "connectorUnitNumber"));
                if ("DU".equals(this.rbs.getCustomerParameter(string3 + "connectorType"))) {
                    this.setEcBusConnectionRefForDu(i, n2);
                    arrayList.add(this.ecBusRI[i]);
                    continue;
                }
                this.checkEcBusConnectorUnitNo(n2, radioEquipmentProvider);
                AbstractRuRI[] abstractRuRIArray = radioEquipmentProvider.getSectorRadioUnits(n2);
                TrueFalseCustomerParameter trueFalseCustomerParameter = (TrueFalseCustomerParameter)this.rbs.getCustomerParameterObject("supportSystemControl");
                if (!trueFalseCustomerParameter.getBooleanValue()) continue;
                this.setEcBusConnectionRefForRu(i, abstractRuRIArray, string3);
                arrayList.add(this.ecBusRI[i]);
            }
        }
    }

    private void setUnitInfo4MulCab(ArrayList arrayList, int n) throws BemException {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ResourceItem resourceItem = (ResourceItem)iterator.next();
            if (!(resourceItem instanceof AbstractHwUnitWithEcPortRI)) continue;
            ((AbstractHwUnitWithEcPortRI)resourceItem).setReferredCabinetNumber(String.valueOf(n));
            String string = PrefixUtil.getCabinetPrefix(String.valueOf(n));
            IntegerParameter integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject(string + "ecBusNumber");
            if (integerParameter.getValue().equalsIgnoreCase("##UNDEFINED")) continue;
            ((AbstractHwUnitWithEcPortRI)resourceItem).setEcBusNo4MulCab(integerParameter.getValue());
        }
    }

    public boolean open(ServiceValue serviceValue) throws BemException {
        boolean bl = true;
        if (serviceValue.getValue("noOfPsu") == null || serviceValue.getValue("noOfPdu") == null) {
            return false;
        }
        try {
            this.open();
            this.checkConsistency();
        }
        catch (BemException bemException) {
            throw bemException;
        }
        catch (Exception exception) {
            throw new BemException("AbstractPowerSystemCI.open(sv) got exception=" + exception.toString());
        }
        return bl;
    }

    public final String getName() {
        return name;
    }

    protected abstract void setDefaultParameterValues() throws BemException;

    protected abstract SupportSystemManager getSupportSystemManager() throws BemException;

    protected abstract PowerSupplyManager getPowerSupplyManager() throws BemException;

    protected abstract PowerDistributionManager getPowerDistributionManager() throws BemException;

    protected abstract BatteryManager getBatteryManager() throws BemException;

    protected abstract ClimateManager getClimateManager() throws BemException;

    public void setCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, CustomerParameterException, BemException {
        String string;
        int n;
        this.checkCabinetCustomerParameter(serviceValue);
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            FanSpeedSupervisionParameter fanSpeedSupervisionParameter;
            NoOfBfuParameter noOfBfuParameter;
            NoOfPduParameter noOfPduParameter;
            n = Integer.parseInt(iterator.next().toString());
            string = BemUtil.generateCabinetKey(n);
            arrayList.add(((MultiplePowerSystemParameter)this.multiplePowerSystemCustParam.get(string)).getName());
            arrayList.add(((YesNoCustomerParameter)this.configureClimateCustParamMap.get(string)).getName());
            arrayList.add(((ClimateSystem)this.climateSystemCustParam.get(string)).getName());
            arrayList.add(((ClimateRegulationSystem)this.climateRegulationSystemCustParamMap.get(string)).getName());
            arrayList.add(((ConfigureBatteryBackupParameter)this.confBatteryBackupCustParam.get(string)).getName());
            arrayList.add(((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(string)).getName());
            arrayList.add(((Enumeration)this.chargingModeParam.get(string)).getName());
            arrayList.add(((BatteryTypeParameter)this.batteryTypeParam.get(string)).getName());
            arrayList.add(((TrueFalseCustomerParameter)this.sharedBatteryParam.get(string)).getName());
            arrayList.add(((Enumeration)this.testModeParam.get(string)).getName());
            arrayList.add(((IntegerParameter)this.minimumBackupTimeParam.get(string)).getName());
            arrayList.add(((IntegerParameter)this.minimumStateOfHealthParam.get(string)).getName());
            arrayList.add(((IntegerParameter)this.testStartDayParam.get(string)).getName());
            arrayList.add(((StringParameter)this.testStartTimeParam.get(string)).getName());
            arrayList.add(((StringParameter)this.batteryInstallationDateParam.get(string)).getName());
            arrayList.add(((SmokeDetectorParameter)this.smokeDetectorParam.get(string)).getName());
            for (int i = 0; i < 12; ++i) {
                arrayList.add(((YesNoCustomerParameter)((HashMap)this.testStartMonthParam.get(string)).get(new Integer(i))).getName());
            }
            arrayList.add(((IntegerParameter)this.valueChargingVoltageParameter.get(string)).getName());
            arrayList.add(((IntegerParameter)this.valueTempCompVoltageSlopParameter.get(string)).getName());
            arrayList.add(((IntegerParameter)this.valueNominalTempParameter.get(string)).getName());
            arrayList.add(((IntegerParameter)this.valueTempCompMinVoltageParameter.get(string)).getName());
            arrayList.add(((IntegerParameter)this.valueTempCompMaxVoltageParameter.get(string)).getName());
            arrayList.add(((IntegerParameter)this.valueIncreasedChargeVoltageParameter.get(string)).getName());
            arrayList.add(((IntegerParameter)this.valueBoostChargeTimeParameter.get(string)).getName());
            arrayList.add(((IntegerParameter)this.valueBoostChargeTriggerVoltageParameter.get(string)).getName());
            arrayList.add(((IntegerParameter)this.valueEqualizeChargeTimeParameter.get(string)).getName());
            arrayList.add(((IntegerParameter)this.valueEqualizeChargeCyclicIntervalParameter.get(string)).getName());
            arrayList.add(((IntegerParameter)this.valueIntermittentChargeConnectVoltageParameter.get(string)).getName());
            arrayList.add(((IntegerParameter)this.valueIntermittentChargeConnectTimeParameter.get(string)).getName());
            arrayList.add(((IntegerParameter)this.valueIntermittentChargeDisconnectTimeParameter.get(string)).getName());
            NoOfPsuParameter noOfPsuParameter = (NoOfPsuParameter)this.noOfPsuCustParamMap.get(string);
            if (noOfPsuParameter != null) {
                arrayList.add(noOfPsuParameter.getName());
            }
            if ((noOfPduParameter = (NoOfPduParameter)this.noOfPduCustParamMap.get(string)) != null) {
                arrayList.add(noOfPduParameter.getName());
            }
            if ((noOfBfuParameter = (NoOfBfuParameter)this.noOfBfuCustParamMap.get(string)) != null) {
                arrayList.add(noOfBfuParameter.getName());
            }
            if ((fanSpeedSupervisionParameter = (FanSpeedSupervisionParameter)this.fanSpeedSupervisionParamMap.get(string)) != null) {
                arrayList.add(fanSpeedSupervisionParameter.getName());
            }
            arrayList.add(((IntegerParameter)this.optionalEquipmentcabinetNoParam.get(string)).getName());
        }
        arrayList.add(this.supportSystemControlCustParam.getName());
        for (n = 0; n < 7; ++n) {
            arrayList.add(this.ecBusNoParam[n].getName());
            arrayList.add(this.ecBusconnectorUnitNumberParam[n].getName());
            arrayList.add(this.ecBusConnectorTypeParam[n].getName());
            arrayList.add(this.ecBusInterConnectorUnitNoParam[n].getName());
            arrayList.add(this.ModEcBusNoParam[n].getName());
            arrayList.add(this.ModEcBusconnectorUnitNumberParam[n].getName());
            arrayList.add(this.modEcBusConnectorTypeParam[n].getName());
            arrayList.add(this.modEcBusInterConnectorUnitNoParam[n].getName());
        }
        iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            n = Integer.parseInt(iterator.next().toString());
            string = BemUtil.generateCabinetKey(n);
            arrayList.add(((IntegerParameter)this.cabinetNumberParam.get(string)).getName());
            arrayList.add(((IntegerParameter)this.referredCabinetNumberParam.get(string)).getName());
            arrayList.add(((StringParameter)this.sharedCabinetIdentifierParam.get(string)).getName());
            arrayList.add(((IntegerParameter)this.cabEcBusNoParam.get(string)).getName());
        }
        iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            n = Integer.parseInt(iterator.next().toString());
            if (n <= 1) continue;
            string = BemUtil.generateCabinetKey(n);
            arrayList.add(((IntegerParameter)this.delCabinetNumberParam.get(string)).getName());
        }
        String[] stringArray = arrayList.toArray(new String[0]);
        super.setCustomerParametersFromSV(stringArray, serviceValue);
        this.setCustomerParametersForHwGroupFromSV(serviceValue);
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public ConfigurationCheckReport checkConfiguration() {
        return null;
    }

    public boolean isConfPowerSupplySupported() {
        return this.psuRange != null;
    }

    public boolean isConfPowerDistributionSupported() {
        return this.pduRange != null;
    }

    public boolean hasSupportControlUnit() {
        ClimateManager climateManager = (ClimateManager)this.climateManagerMap.get(BemUtil.cabinetWithPDuw);
        boolean bl = climateManager.hasScu() || climateManager.hasSup();
        return bl;
    }

    public boolean isSupportSystemAvailable() {
        boolean bl = this.supportSystemManager.isSupportSystemAvailable();
        return bl;
    }

    void createParameters() throws Exception {
        this.createAllCustomerParameters();
    }

    void setManager(Object object) {
        if (object instanceof BatteryManager) {
            this.batteryManagerMap.put(BemUtil.cabinetWithPDuw, (BatteryManager)object);
        } else if (object instanceof ClimateManager) {
            this.climateManagerMap.put(BemUtil.cabinetWithPDuw, (ClimateManager)object);
        } else if (object instanceof PowerDistributionManager) {
            this.powerDistributionManagerMap.put(BemUtil.cabinetWithPDuw, (PowerDistributionManager)object);
        } else if (object instanceof PowerSupplyManager) {
            this.powerSupplyManagerMap.put(BemUtil.cabinetWithPDuw, (PowerSupplyManager)object);
        } else if (object instanceof SupportSystemManager) {
            this.supportSystemManager = (SupportSystemManager)object;
        }
    }

    void setOpen() {
        this.isOpen = true;
    }

    void setPsuRange(IntegerRange integerRange) {
        this.psuRange.put(BemUtil.cabinetWithPDuw, integerRange);
    }

    public void checkConsistency() throws BemException {
        super.checkConsistency();
        Iterator iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            String string;
            BatteryManager batteryManager;
            int n = Integer.parseInt(iterator.next().toString());
            String string2 = PrefixUtil.getCabinetPrefix(String.valueOf(n));
            YesNoCustomerParameter yesNoCustomerParameter = (YesNoCustomerParameter)this.rbs.getCustomerParameterObject(string2 + "configureBatteryBackup");
            if (yesNoCustomerParameter.getValue().equalsIgnoreCase("YES")) {
                this.checkTestStartTimeFormat(n);
                this.checkTestStartMonthsAndDay(n);
                this.checkChargingMode(n);
                this.checkBatteryInstallationDate(n);
                this.checkMultiplePowerSystem(n);
            }
            boolean bl = null == (batteryManager = (BatteryManager)this.batteryManagerMap.get(string = BemUtil.generateCabinetKey(n))) ? false : batteryManager.isBatterySupported();
            YesNoCustomerParameter yesNoCustomerParameter2 = (YesNoCustomerParameter)this.confBatteryBackupCustParam.get(string);
            if (!bl && yesNoCustomerParameter2.getValue().equalsIgnoreCase("YES")) {
                throw new BemException("Cabinet " + n + " does not support the battery backup!");
            }
            PowerSupplyManager powerSupplyManager = (PowerSupplyManager)this.powerSupplyManagerMap.get(string);
            boolean bl2 = null == powerSupplyManager ? false : powerSupplyManager.isPowerSupplySupported();
            PowerDistributionManager powerDistributionManager = (PowerDistributionManager)this.powerDistributionManagerMap.get(string);
            boolean bl3 = null == powerDistributionManager ? false : powerDistributionManager.isPowerDistributionSupported();
            YesNoCustomerParameter yesNoCustomerParameter3 = (YesNoCustomerParameter)this.confPowerSupplyCustParam.get(string);
            if (!bl2 && !bl3 && yesNoCustomerParameter3.getValue().equalsIgnoreCase("YES")) {
                throw new BemException("Cabinet " + n + " does not support the power supply!");
            }
            IntegerParameter integerParameter = (IntegerParameter)this.referredCabinetNumberParam.get(string);
            if (!integerParameter.getValue().equals(String.valueOf(n))) continue;
            throw new BemException("The positionRef of Cabinet " + n + " cannot refer to itself.");
        }
    }

    private void checkCabinetCustomerParameter(ServiceValue serviceValue) throws BemException {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.getCabinetOfRbs(arrayList, arrayList2);
        this.getCabinetOfServiceValueAndValidate(arrayList, arrayList2, serviceValue);
        this.checkEcBusConsistency(serviceValue);
    }

    private void checkEcBusConsistency(ServiceValue serviceValue) throws BemException {
        for (int i = 1; i <= 7; ++i) {
            String string;
            String string2;
            String string3 = MessageFormat.format("EcBus{0}_", new Integer(i));
            String string4 = serviceValue.getValue(string3 + "ecBusNumber");
            if (string4 != null) {
                boolean bl = false;
                string2 = serviceValue.getAttribute(string3 + "ecBusNumber").getServiceName();
                IntegerParameter integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject(string3 + "ecBusNumber");
                if (null != integerParameter && !integerParameter.getValue().equals("##UNDEFINED")) {
                    bl = true;
                }
                if (string2 != null && bl && (string2.equals("EcBus") || string2.equals("AddEcBus"))) {
                    throw new BemException("Ecbus_" + string4 + " has existed, can not be added!");
                }
            }
            if ((string2 = serviceValue.getValue((string = MessageFormat.format("ModEcBus{0}_", new Integer(i))) + "ecBusNumber")) == null) continue;
            boolean bl = false;
            String string5 = serviceValue.getAttribute(string + "ecBusNumber").getServiceName();
            IntegerParameter integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject(string3 + "ecBusNumber");
            if (null != integerParameter && !integerParameter.getValue().equals("##UNDEFINED")) {
                bl = true;
            }
            if (string5 == null || bl || !string5.equals("ModifyEcBus")) continue;
            throw new BemException("Ecbus_" + string2 + " has not existed, can not be modified!");
        }
    }

    private void getCabinetOfRbs(List arrayList, List arrayList2) throws BemException {
        if (null == arrayList) {
            arrayList = new ArrayList<String>();
        }
        if (null == arrayList2) {
            arrayList2 = new ArrayList<String>();
        }
        Iterator iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            StringParameter stringParameter;
            int n = Integer.parseInt(iterator.next().toString());
            String string = PrefixUtil.getCabinetPrefix(String.valueOf(n));
            IntegerParameter integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject(string + "cabinetNumber");
            if (null != integerParameter && !integerParameter.getValue().equals("##UNDEFINED")) {
                arrayList.add(integerParameter.getValue());
            }
            if (null == (stringParameter = (StringParameter)this.rbs.getCustomerParameterObject(string + "sharedCabinetIdentifier")) || stringParameter.getValue().equals("")) continue;
            arrayList2.add(stringParameter.getValue());
        }
    }

    private void getCabinetOfServiceValueAndValidate(List list, List list2, ServiceValue serviceValue) throws BemException {
        int n;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        if (list2.size() == 0) {
            for (n = 0; n < list.size(); ++n) {
                hashMap.put((String)list.get(n), "");
            }
        } else {
            for (n = 0; n < list.size(); ++n) {
                hashMap.put((String)list.get(n), (String)list2.get(n));
            }
        }
        Iterator iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            int n2 = Integer.parseInt(iterator.next().toString());
            String string3 = PrefixUtil.getCabinetPrefix(String.valueOf(n2));
            String string4 = serviceValue.getValue(string3 + "cabinetNumber");
            String string5 = serviceValue.getValue(string3 + "sharedCabinetIdentifier");
            if (null != string4) {
                string2 = serviceValue.getAttribute(string3 + "cabinetNumber").getServiceName();
                string = string5 == null ? "" : string5;
                boolean bl = false;
                if ("AddCabinet".equals(string2)) {
                    arrayList.add(string4);
                    if (hashMap.containsKey(string4)) {
                        throw new BemException("Cabinet_" + string4 + " has existed, can not be added!");
                    }
                } else if ("ModifyCabinet".equals(string2)) {
                    arrayList3.add(string4);
                    if (!hashMap.containsKey(string4)) {
                        throw new BemException("Cabinet_" + string4 + " has not existed, can not be modified!");
                    }
                    if (string5 == null) {
                        bl = true;
                    }
                }
                if (!bl) {
                    hashMap.put(string4, string);
                }
            }
            if (null != string5 && !"".equals(string5)) {
                string2 = serviceValue.getAttribute(string3 + "cabinetNumber").getServiceName();
                if ("AddCabinet".equals(string2)) {
                    arrayList2.add(string5);
                } else if ("ModifyCabinet".equals(string2)) {
                    arrayList4.add(string5);
                }
            }
            if (null == (string = serviceValue.getValue((string2 = PrefixUtil.getDeleteCabinetPrefix(String.valueOf(n2))) + "cabinetNumber"))) continue;
            arrayList5.add(string);
            if (!hashMap.containsKey(string)) {
                throw new BemException("Cabinet_" + string + " has not existed, can not be deleted!");
            }
            hashMap.remove(string);
        }
        this.checkSharedId(hashMap);
        this.checkCabinetList(serviceValue, arrayList, arrayList3, arrayList4, arrayList5);
    }

    private void checkSharedId(Map map) throws BemException {
        Collection collection = map.values();
        Iterator iterator = collection.iterator();
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if ("".equals(string)) {
                ++n;
                continue;
            }
            if (hashSet.add(string)) continue;
            throw new BemException("SharedCabinetIdentifier must be all empty or all configured different value!");
        }
        if (n != 0 && n != map.size()) {
            throw new BemException("SharedCabinetIdentifier must be all empty or all configured different value!");
        }
    }

    private void checkCabinetList(ServiceValue serviceValue, List list, List list2, List list3, List list4) throws BemException {
        String string = ((TrueFalseCustomerParameter)this.rbs.getCustomerParameterObject("supportSystemControl")).getValue();
        if (serviceValue.getValue("supportSystemControl") != null) {
            string = serviceValue.getValue("supportSystemControl");
        }
        if (!list2.isEmpty()) {
            Iterator iterator = this.rbs.getCabinetNumberList().iterator();
            while (iterator.hasNext()) {
                String string2;
                String string3;
                int n = Integer.parseInt(iterator.next().toString());
                String string4 = PrefixUtil.getCabinetPrefix(String.valueOf(n));
                if (string.equalsIgnoreCase("TRUE")) {
                    String string5;
                    Object object;
                    if (!list2.contains(Integer.toString(n)) || (string3 = serviceValue.getValue(string4 + "ecBusNumber")) == null) continue;
                    string2 = MessageFormat.format("EcBus{0}_", Integer.valueOf(string3));
                    EcBusRI ecBusRI = this.ecBusRI[Integer.parseInt(string3) - 1];
                    String string6 = serviceValue.getValue(string2 + "connectorType");
                    String string7 = serviceValue.getValue(string2 + "connectorUnitNumber");
                    BemMo bemMo = this.rbs.getMoHandler().getMo(ecBusRI.getLdn());
                    BemMo bemMo2 = null;
                    if (null != bemMo && bemMo.isExisting()) {
                        bemMo2 = (BemMo)bemMo.getAttribute("ecBusConnectorRef");
                    }
                    if ((null == string6 || null == string7) && null == bemMo2) continue;
                    if (null == string6) {
                        String string8 = string6 = bemMo2.getType().equals(MimPlugInUnit.MOTYPENAME) ? "DU" : "RU";
                    }
                    if (!"RU".equals(string6)) continue;
                    if (null == string7) {
                        object = (BemMoImpl[])bemMo2.getAttribute("reservedBy");
                        if (null == object) continue;
                        for (int i = 0; i < ((BemMoImpl[])object).length; ++i) {
                            if (!MimAntFeederCable.MOTYPENAME.equals(object[i].getType())) continue;
                            BemMo bemMo3 = (BemMo)object[i].getAttribute("antennaBranchRef");
                            String string9 = bemMo3.getParent().getDN();
                            string7 = string9.substring(string9.lastIndexOf("=") + 1, string9.lastIndexOf("-"));
                            break;
                        }
                    }
                    if (null == string7 || (string5 = serviceValue.getValue((String)(object = MessageFormat.format("S{0}_", string7)) + "deleteSector")) == null || string5.equals("")) continue;
                    throw new BemException("The Sector " + string7 + " cannot be deleted, it is referred by EcBus " + string3 + ".");
                }
                string3 = serviceValue.getValue(string4 + "climateSystem");
                string2 = serviceValue.getValue(string4 + "smokeDetector");
                if (null == string3 && null == string2) continue;
                throw new BemException("supportSystemControl is false, climateSystem and smokeDetector can not be modified!");
            }
        }
        if (!list4.isEmpty()) {
            this.isDelCabinetUseByRUorDU(list4);
        }
    }

    private void isDelCabinetUseByRUorDU(List list) throws BemException {
        if (null != list) {
            Iterator iterator = list.iterator();
            MoInstance moInstance = this.rbs.getMoiRefs().getEquipmentMoi();
            while (iterator.hasNext()) {
                Object[] objectArray;
                String string = (String)iterator.next();
                String string2 = new FixedRdnMoi(moInstance, MimCabinet.MOTYPENAME, String.valueOf(string)).getLdn();
                BemMo bemMo = this.rbs.getMoHandler().getMo(string2);
                if (null == bemMo || !bemMo.isExisting()) continue;
                try {
                    objectArray = (Object[])this.getRbs().getMoHandler().getAttribute(bemMo, "reservedBy");
                }
                catch (MoHandlerException moHandlerException) {
                    throw new BemException(moHandlerException);
                }
                if (objectArray == null || objectArray.length <= 0 || !(objectArray instanceof BemMo[])) continue;
                BemMo[] bemMoArray = (BemMo[])objectArray;
                for (int i = 0; i < bemMoArray.length; ++i) {
                    if (!bemMoArray[i].getType().equals(MimPlugInUnit.MOTYPENAME) && !bemMoArray[i].getType().equals(MimAuxPlugInUnit.MOTYPENAME)) continue;
                    throw new BemException("Cabinet_" + string + " can not be deleted, " + bemMoArray[i].getDN() + " is used now!");
                }
            }
        }
    }

    public void checkChargingMode(int n) throws BemException {
        String string = BemUtil.generateCabinetKey(n);
        if (((BatteryTypeParameter)this.batteryTypeParam.get(string)).getValue().equals("UNKNOWN") && ((Enumeration)this.chargingModeParam.get(string)).getValue().equals("AUTOMATIC")) {
            throw new BemException("batteryType = UNKNOWN is valid only when chargingMode = USER_DEFINED");
        }
    }

    public void checkConsistency(List list) throws CustomerParameterException, BemException {
        super.checkConsistency(list);
        this.checkConsistency();
    }

    private boolean isLeapYear(String string) {
        int n = Integer.parseInt(string);
        return n % 100 == 0 && n % 400 == 0 || n % 100 != 0 && n % 4 == 0;
    }

    private boolean checkStringDateFormat(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n = 0;
        int n2 = 0;
        string2 = string;
        string3 = string2.substring(0, 4);
        string4 = string2.substring(4, 6);
        string5 = string2.substring(6, 8);
        n = Integer.parseInt(string5);
        n2 = Integer.parseInt(string4);
        if (n2 > 12 || n2 < 1) {
            return false;
        }
        return !(string4.equals("01") || string4.equals("03") || string4.equals("05") || string4.equals("07") || string4.equals("08") || string4.equals("10") || string4.equals("12") ? n > 31 || n < 1 : (string4.equals("02") ? (this.isLeapYear(string3) ? n > 29 || n < 1 : n > 28 || n < 1) : !(!string4.equals("04") && !string4.equals("06") && !string4.equals("09") && !string4.equals("11") || n <= 30 && n >= 1)));
    }

    private void checkBatteryInstallationDate(int n) throws BemException {
        String string = PrefixUtil.getCabinetPrefix(String.valueOf(n));
        CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string + "batteryInstallationDate");
        String string2 = (String)customerParameterServer.getValueMom();
        if (string2.equals(MimBatteryBackup.DEFAULT_BATTERYINSTALLATIONDATE)) {
            return;
        }
        if (!this.checkStringDateFormat(string2)) {
            throw new BemException("batteryInstallationDate: " + string2 + " is not valid");
        }
        int n2 = Integer.parseInt(string2.substring(0, 4));
        int n3 = Integer.parseInt(string2.substring(4, 6));
        int n4 = Integer.parseInt(string2.substring(6, 8));
        Calendar calendar = Calendar.getInstance();
        int n5 = calendar.get(1);
        int n6 = calendar.get(2) + 1;
        int n7 = calendar.get(5);
        if (n2 > n5 || n2 == n5 && n3 > n6 || n2 == n5 && n3 == n6 && n4 > n7) {
            throw new BemException("batteryInstallationDate " + string2 + " must not be a future date. " + "Current system date is: " + n5 + n6 + n7);
        }
    }

    private boolean checkTimeFormat(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = 0;
        int n2 = 0;
        string2 = string;
        string3 = string2.substring(0, 2);
        string4 = string2.substring(3, 5);
        n = Integer.parseInt(string3);
        n2 = Integer.parseInt(string4);
        if (n > 23 || n2 > 59) {
            return false;
        }
        return string2.subSequence(2, 3).equals(":");
    }

    private void checkTestStartTimeFormat(int n) throws BemException {
        String string = PrefixUtil.getCabinetPrefix(String.valueOf(n));
        CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string + "testStartTime");
        String string2 = (String)customerParameterServer.getValueMom();
        if (!this.checkTimeFormat(string2)) {
            throw new BemException("testStartTime: " + string2 + " is invalid.");
        }
    }

    private void checkTestStartMonthsAndDay(int n) throws BemException {
        String string = PrefixUtil.getCabinetPrefix(String.valueOf(n));
        CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string + "testStartDay");
        int n2 = (Integer)customerParameterServer.getValueMom();
        int n3 = Calendar.getInstance().get(1);
        YesNoCustomerParameter yesNoCustomerParameter = (YesNoCustomerParameter)this.rbs.getCustomerParameterServerObject(string + "testStartMonths" + 2);
        if (yesNoCustomerParameter.getValue().equalsIgnoreCase("YES") && (n3 % 4 == 0 && n2 > 29 || n3 % 4 != 0 && n2 > 28)) {
            throw new BemException("Feb " + n2 + " is an invalid date");
        }
        if (n2 > 30) {
            YesNoCustomerParameter yesNoCustomerParameter2 = (YesNoCustomerParameter)this.rbs.getCustomerParameterServerObject(string + "testStartMonths" + 4);
            YesNoCustomerParameter yesNoCustomerParameter3 = (YesNoCustomerParameter)this.rbs.getCustomerParameterServerObject(string + "testStartMonths" + 6);
            YesNoCustomerParameter yesNoCustomerParameter4 = (YesNoCustomerParameter)this.rbs.getCustomerParameterServerObject(string + "testStartMonths" + 9);
            YesNoCustomerParameter yesNoCustomerParameter5 = (YesNoCustomerParameter)this.rbs.getCustomerParameterServerObject(string + "testStartMonths" + 11);
            if (yesNoCustomerParameter2.getValue().equalsIgnoreCase("YES") || yesNoCustomerParameter3.getValue().equalsIgnoreCase("YES") || yesNoCustomerParameter4.getValue().equalsIgnoreCase("YES") || yesNoCustomerParameter5.getValue().equalsIgnoreCase("YES")) {
                throw new BemException((yesNoCustomerParameter2.getValue().equalsIgnoreCase("YES") ? "Apr " + n2 + " " : "") + (yesNoCustomerParameter3.getValue().equalsIgnoreCase("YES") ? "Jun " + n2 + " " : "") + (yesNoCustomerParameter4.getValue().equalsIgnoreCase("YES") ? "Sep " + n2 + " " : "") + (yesNoCustomerParameter5.getValue().equalsIgnoreCase("YES") ? "Nov " + n2 + " " : "") + "is invalid date. ");
            }
        }
    }

    private void checkMultiplePowerSystem(int n) throws BemException {
        Iterator iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            int n2 = Integer.parseInt(iterator.next().toString());
            String string = BemUtil.generateCabinetKey(n2);
            if (n2 != n) continue;
            String string2 = ((MultiplePowerSystemParameter)this.multiplePowerSystemCustParam.get(string)).getValue();
            if (RbsInfo.RBS_6110W.NAME.equals(this.rbs.getRbsType()) || RbsInfo.RBS_6120W.NAME.equals(this.rbs.getRbsType()) || RbsInfo.RBS_6131W.NAME.equals(this.rbs.getRbsType())) {
                Integer n3 = new Integer(((NoOfBfuParameter)this.noOfBfuCustParamMap.get(string)).getValue());
                if (n3.compareTo(mimBfuNumberSupportParallelBfu) >= 0 || !string2.equalsIgnoreCase("FALSE")) continue;
                throw new BemException("MultiplePowerSystem can not be " + string2 + " when BFU number < 2 ,your current BFU number is " + n3);
            }
            if (!string2.equalsIgnoreCase("FALSE")) continue;
            throw new BemException("MultiplePowerSystem can not be " + string2 + " when RBS type is " + this.rbs.getRbsType());
        }
    }

    private boolean isDuwV2In6601() throws BemException {
        return DuwUtil.isDualDuwAndPrimaryIsV2() && RbsInfo.RBS_6601W.NAME.equals(this.rbs.getRbsType());
    }

    private void setCustomerParametersForHwGroup(String string, String string2) {
        Integer n = (Integer)this.hwGroupIdToIndex.get(string);
        if (null == n) {
            return;
        }
        StringParameter stringParameter = null;
        if (null != string) {
            stringParameter = (StringParameter)this.hwGroupIdParams.get(n);
            stringParameter.setValue(string);
        }
        if (null != string2) {
            stringParameter = (StringParameter)this.hwGroupPositionInfoParams.get(n);
            stringParameter.setValue(string2);
        }
    }

    protected void setCustomerParametersForHwGroupFromSV(ServiceValue serviceValue) throws BemException {
        String string;
        String string2;
        Vector vector = serviceValue.getAllAttributes();
        for (int i = 0; i < vector.size() && null != serviceValue.getAttribute(string2 = (string = PrefixUtil.getHwGroupPrefix(i)) + "hwGroupId"); ++i) {
            String string3 = serviceValue.getValue(string2);
            string2 = string + "positionInformation";
            String string4 = serviceValue.getValue(string2);
            this.createHwGroupResources(string3);
            this.setCustomerParametersForHwGroup(string3, string4);
        }
    }

    private void createHwGroupCP(int n) {
        StringRange stringRange = new StringRange(new Integer(1), new Integer(Integer.MAX_VALUE));
        StringRange stringRange2 = new StringRange(MimHwGroup.MINLEN_POSITIONINFORMATION, MimHwGroup.MAXLEN_POSITIONINFORMATION);
        ParameterRestriction parameterRestriction = new ParameterRestriction("", 3);
        ParameterRestriction parameterRestriction2 = new ParameterRestriction("", 2);
        String string = PrefixUtil.getHwGroupPrefix(n);
        String string2 = string + "hwGroupId";
        StringParameter stringParameter = new StringParameter(string2, stringRange);
        stringParameter.addRestriction(parameterRestriction);
        this.addParameter(stringParameter);
        this.hwGroupIdParams.add(stringParameter);
        string2 = string + "positionInformation";
        StringParameter stringParameter2 = new StringParameter(string2, stringRange2);
        stringParameter2.addRestriction(parameterRestriction2);
        stringParameter2.setDefaultValue(MimHwGroup.DEFAULT_POSITIONINFORMATION);
        this.addParameter(stringParameter2);
        this.hwGroupPositionInfoParams.add(stringParameter2);
    }

    private void createHwGroupMoi(String string) {
        if (null == string || string.length() <= 0) {
            return;
        }
        this.hwGroupMois.add(new FixedRdnMoi(this.rbs.getEquipmentMoi(), MimHwGroup.MOTYPENAME, string));
    }

    private void createHwGroupRI(int n) throws BemException {
        MoInstance moInstance = (MoInstance)this.hwGroupMois.get(n);
        HwGroupRI hwGroupRI = new HwGroupRI(this.rbs, moInstance.getLdn(), n);
        hwGroupRI.setLoadedValues();
        this.hwGroupRIs.add(hwGroupRI);
    }

    protected void createHwGroupResources(String string) throws BemException {
        if (null == string || string.length() <= 0 || this.hwGroupIdToIndex.containsKey(string)) {
            return;
        }
        int n = this.noOfHwGroups;
        this.hwGroupIdToIndex.put(string, new Integer(n));
        this.noOfHwGroups = n + 1;
        this.createHwGroupCP(n);
        this.createHwGroupMoi(string);
        this.createHwGroupRI(n);
    }

    protected void initialiseResourceForHwGroups() throws BemException {
        MoHandler moHandler = this.rbs.getMoHandler();
        BemMo bemMo = moHandler.getMo(this.rbs.getEquipmentMoi().getLdn());
        try {
            BemMo[] bemMoArray = moHandler.getChildren(bemMo, 1, MimHwGroup.MOTYPENAME, "");
            for (int i = 0; i < bemMoArray.length; ++i) {
                BemMo bemMo2 = bemMoArray[i];
                String string = bemMo2.getId();
                this.createHwGroupResources(string);
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(this.getClass() + ".initialiseResourceForHwGroups()", (Throwable)moHandlerException);
        }
    }

    public int getNumberOfHwGroup() throws BemException {
        return this.noOfHwGroups;
    }

    private void setEcBusConnectionRefForDu(int n, int n2) throws BemException {
        if (Integer.parseInt(DuwUtil.getSlotNumberForPrimaryDuw()) == n2) {
            this.ecBusRI[n].setConnectionRefLdn(DuwUtil.getPrimaryDuwPiuLdn());
        } else if (Integer.parseInt(DuwUtil.getSlotNumberForSecondaryDuw()) == n2 && DuwUtil.hasDualDuws()) {
            this.ecBusRI[n].setConnectionRefLdn(DuwUtil.getSecondaryDuwPiuLdn());
        } else {
            throw new BemException("The DU number for EcBus reference is invalid, the invalid DU number is : " + n2);
        }
    }

    private void setEcBusConnectionRefForRu(int n, AbstractRuRI[] abstractRuRIArray, String string) throws BemException {
        int n2 = Integer.parseInt(this.rbs.getCustomerParameter(string + "internalConnectorUnitNumber"));
        if (n2 > abstractRuRIArray.length) {
            throw new BemException("The number of the radio in an RBB for EcBus reference is not valid. The invalid radio number is: " + n2);
        }
        this.ecBusRI[n].setConnectionRefLdn(abstractRuRIArray[n2 - 1].getAuxPiuLdn());
    }

    private void checkEcBusConnectorUnitNo(int n, RadioEquipmentProvider radioEquipmentProvider) throws BemException {
        boolean bl = radioEquipmentProvider.isSectorEquipped(n);
        if (!bl) {
            throw new BemException("The connectorUnitNumber attribute in EcBus element is set to " + n + ", but Sector " + n + " does not exist.");
        }
    }

    private class NumberOfBfuListener
    implements CustomerParameterListener {
        int cabNo;

        public NumberOfBfuListener(int n) {
            this.cabNo = n;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            String string = customerParameter.getName();
            String string2 = BemUtil.generateCabinetKey(this.cabNo);
            if (parameterEvent.isValueChanged() && string.equalsIgnoreCase(((NoOfBfuParameter)AbstractPowerSystemCI.this.noOfBfuCustParamMap.get(string2)).getName())) {
                if (RbsInfo.RBS_6110W.NAME.equals(AbstractPowerSystemCI.this.rbs.getRbsType()) || RbsInfo.RBS_6120W.NAME.equals(AbstractPowerSystemCI.this.rbs.getRbsType()) || RbsInfo.RBS_6131W.NAME.equals(AbstractPowerSystemCI.this.rbs.getRbsType())) {
                    ((ParameterRestriction)AbstractPowerSystemCI.this.restMultiplePowerSystem.get(string2)).setActive(false);
                    ((ParameterRestriction)AbstractPowerSystemCI.this.restMultiplePowerSystemOptional.get(string2)).setActive(true);
                } else {
                    ((ParameterRestriction)AbstractPowerSystemCI.this.restMultiplePowerSystem.get(string2)).setActive(true);
                    ((ParameterRestriction)AbstractPowerSystemCI.this.restMultiplePowerSystemOptional.get(string2)).setActive(false);
                }
            }
        }
    }
}

