/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem;

import java.util.HashMap;
import java.util.Map;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.ApcHubPort;

public class ApcHubPortManager {
    private static final String CABINET_POWER6610 = "POWER6610";
    private static final String CABINET_POWER6306 = "POWER6306";
    private Map cabinetTable = this.generateHwUnitMapTable();
    private Map defaultHubPortTable = this.createDefaultHwUnitMapTable();
    private static final ApcHubPortManager singleIntance = new ApcHubPortManager();

    private ApcHubPortManager() {
    }

    public static ApcHubPortManager getInstance() {
        return singleIntance;
    }

    private Map generateHwUnitMapTable() {
        HashMap<String, Map> hashMap = new HashMap<String, Map>();
        hashMap.put(CABINET_POWER6610, this.createPower6610HwUnitMapTable());
        hashMap.put(CABINET_POWER6306, this.createPower6306HwUnitMapTable());
        return hashMap;
    }

    private Map createDefaultHwUnitMapTable() {
        HashMap<Object, ApcHubPort> hashMap = new HashMap<Object, ApcHubPort>();
        hashMap.put(this.generateKey("PDU", 1), new ApcHubPort("PDU", 1, "A2"));
        hashMap.put(this.generateKey("PDU", 2), new ApcHubPort("PDU", 2, "B2"));
        hashMap.put(this.generateKey("PDU", 3), new ApcHubPort("PDU", 3, "B7"));
        hashMap.put(this.generateKey("PDU", 4), new ApcHubPort("PDU", 4, "A8"));
        hashMap.put(this.generateKey("PDU", 5), new ApcHubPort("PDU", 5, "B3"));
        hashMap.put(this.generateKey("PDU", 6), new ApcHubPort("PDU", 6, "B4"));
        hashMap.put(this.generateKey("PDU", 7), new ApcHubPort("PDU", 7, "B6"));
        hashMap.put(this.generateKey("PDU", 8), new ApcHubPort("PDU", 8, "B5"));
        hashMap.put(this.generateKey("PSU", 1), new ApcHubPort("PSU", 1, "A3"));
        hashMap.put(this.generateKey("PSU", 2), new ApcHubPort("PSU", 2, "B3"));
        hashMap.put(this.generateKey("PSU", 3), new ApcHubPort("PSU", 3, "A4"));
        hashMap.put(this.generateKey("PSU", 4), new ApcHubPort("PSU", 4, "B4"));
        hashMap.put(this.generateKey("PSU", 5), new ApcHubPort("PSU", 5, "B6"));
        hashMap.put(this.generateKey("PSU", 6), new ApcHubPort("PSU", 6, "B2"));
        hashMap.put(this.generateKey("PSU", 7), new ApcHubPort("PSU", 7, "B7"));
        hashMap.put(this.generateKey("BFU", 1), new ApcHubPort("BFU", 1, "B5"));
        hashMap.put(this.generateKey("BFU", 2), new ApcHubPort("BFU", 2, "A5"));
        hashMap.put(this.generateKey("SCU", 1), new ApcHubPort("SCU", 1, "A1"));
        hashMap.put(this.generateKey("CLU", 1), new ApcHubPort("CLU", 1, "B8"));
        hashMap.put(this.generateKey("SUP", 1), new ApcHubPort("SUP", 1, "NA"));
        return hashMap;
    }

    private Map createPower6610HwUnitMapTable() {
        HashMap<Object, ApcHubPort> hashMap = new HashMap<Object, ApcHubPort>();
        hashMap.put(this.generateKey("PSU", 1), new ApcHubPort("PSU", 1, "A3"));
        hashMap.put(this.generateKey("PSU", 2), new ApcHubPort("PSU", 2, "B3"));
        hashMap.put(this.generateKey("PSU", 3), new ApcHubPort("PSU", 3, "A4"));
        hashMap.put(this.generateKey("PSU", 4), new ApcHubPort("PSU", 4, "B4"));
        hashMap.put(this.generateKey("PDU", 1), new ApcHubPort("PDU", 1, "A2"));
        hashMap.put(this.generateKey("PDU", 2), new ApcHubPort("PDU", 2, "B2"));
        hashMap.put(this.generateKey("PDU", 3), new ApcHubPort("PDU", 3, "B7"));
        hashMap.put(this.generateKey("PDU", 4), new ApcHubPort("PDU", 4, "A8"));
        hashMap.put(this.generateKey("BFU", 1), new ApcHubPort("BFU", 1, "B5"));
        hashMap.put(this.generateKey("SCU", 1), new ApcHubPort("SCU", 1, "A6"));
        return hashMap;
    }

    private Map createPower6306HwUnitMapTable() {
        HashMap<Object, ApcHubPort> hashMap = new HashMap<Object, ApcHubPort>();
        hashMap.put(this.generateKey("PSU", 1), new ApcHubPort("PSU", 1, "A8"));
        hashMap.put(this.generateKey("PSU", 2), new ApcHubPort("PSU", 2, "A1"));
        hashMap.put(this.generateKey("PSU", 3), new ApcHubPort("PSU", 3, "B1"));
        hashMap.put(this.generateKey("PSU", 4), new ApcHubPort("PSU", 4, "A2"));
        hashMap.put(this.generateKey("BFU", 1), new ApcHubPort("BFU", 1, "A3"));
        hashMap.put(this.generateKey("SCU", 1), new ApcHubPort("SCU", 1, "A6"));
        return hashMap;
    }

    private Object generateKey(String string, int n) {
        return string + "_" + Integer.toString(n);
    }

    public ApcHubPort getApcPortValue(String string, String string2, int n) {
        Map map = null;
        if (null != string) {
            map = (Map)this.cabinetTable.get(string.toUpperCase());
        }
        if (null == map) {
            map = this.defaultHubPortTable;
        }
        Object object = this.generateKey(string2, n);
        ApcHubPort apcHubPort = null;
        if (map.containsKey(object)) {
            apcHubPort = (ApcHubPort)map.get(object);
        }
        return apcHubPort;
    }
}

