/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.ApcHubPort;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.ApcHubPortManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.PowerSystemUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.FanSpeedSupervisionParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.CabinetRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.ClimateRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.CluRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.ScuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.SupRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.AlarmConfigurationProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.BooleanCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.PrefixUtil;

public class ClimateManager {
    private int DEFAULT_UNIT_NUMBER = 1;
    private Rbs rbs;
    protected List allRIs;
    private EnumeratedRange climateSystemRange;
    private EnumeratedRange climateRegulationSystemRange;
    private boolean hasClu;
    private boolean hasScu;
    private boolean hasSup;
    private int cabinetNumber;
    private String cabinetType;
    private CabinetRI cabinetRI;
    private ClimateRI climateRI;
    private CluRI cluRI;
    private ScuRI scuRI;
    private SupRI supRI;

    public ClimateManager(Rbs rbs, boolean bl, boolean bl2, boolean bl3, EnumeratedRange enumeratedRange, EnumeratedRange enumeratedRange2) {
        this(rbs, bl, bl2, bl3, enumeratedRange, enumeratedRange2, 1, null);
    }

    public ClimateManager(Rbs rbs, boolean bl, boolean bl2, boolean bl3, EnumeratedRange enumeratedRange, EnumeratedRange enumeratedRange2, int n, String string) {
        this.rbs = rbs;
        this.hasClu = bl;
        this.hasScu = bl2;
        this.hasSup = bl3;
        this.climateSystemRange = enumeratedRange;
        this.climateRegulationSystemRange = enumeratedRange2;
        this.cabinetNumber = n;
        this.cabinetType = string;
    }

    protected String lookupHubPos(String string) {
        ApcHubPort apcHubPort;
        String string2 = "";
        if ((string.equals("SCU") || string.equals("CLU") || string.equals("SUP")) && (apcHubPort = ApcHubPortManager.getInstance().getApcPortValue(this.cabinetType, string, this.DEFAULT_UNIT_NUMBER)) != null) {
            string2 = apcHubPort.getHubPosition();
        }
        return string2;
    }

    public EnumeratedRange getClimateSystemRange() {
        return this.climateSystemRange;
    }

    public EnumeratedRange getClimateRegulationSystemRange() {
        return this.climateRegulationSystemRange;
    }

    public void setBatteryInfoForClimate(boolean bl, boolean bl2) {
        this.climateRI.setBatteryInfoForClimate(bl, bl2);
    }

    public void createAllRIs() throws BemException {
        this.allRIs = new ArrayList();
        this.cabinetRI = new CabinetRI(this.rbs, this.hasSup, this.cabinetNumber);
        this.allRIs.add(this.cabinetRI);
        this.climateRI = new ClimateRI(this.rbs, this.cabinetNumber);
        this.allRIs.add(this.climateRI);
        this.cluRI = new CluRI(this.rbs, this.cabinetNumber);
        this.allRIs.add(this.cluRI);
        this.scuRI = new ScuRI(this.rbs, this.cabinetNumber);
        this.allRIs.add(this.scuRI);
        this.supRI = new SupRI(this.rbs, this.cabinetNumber);
        this.allRIs.add(this.supRI);
        this.setAlarmConfigurationInterface();
    }

    protected void setAlarmConfigurationInterface() throws BemException {
        AlarmConfigurationProvider alarmConfigurationProvider = (AlarmConfigurationProvider)((Object)this.rbs.getConfigItem("AlarmCI"));
        if (null != alarmConfigurationProvider) {
            if (this.hasScu) {
                alarmConfigurationProvider.configureScu(this.cabinetNumber, true);
                this.setAlarmParent(alarmConfigurationProvider, "SCU");
            }
            if (this.hasSup) {
                alarmConfigurationProvider.configureSup(this.cabinetNumber, true);
                this.setAlarmParent(alarmConfigurationProvider, "SUP");
            }
        }
    }

    protected void setAlarmParent(AlarmConfigurationProvider alarmConfigurationProvider, String string) throws BemException {
        if (string.equals("SCU")) {
            alarmConfigurationProvider.setAlarmParent(this.scuRI.getHwUnitMoi(), string, this.cabinetNumber);
        } else if (string.equals("SUP")) {
            alarmConfigurationProvider.setAlarmParent(this.supRI.getHwUnitMoi(), string, this.cabinetNumber);
        }
    }

    public void updateBoards(String string) {
        String string2 = this.lookupHubPos(string);
        if ("CLU".equals(string) && null != this.cluRI) {
            this.cluRI.setHubPosition(string2);
        } else if ("SCU".equals(string) && null != this.scuRI) {
            this.scuRI.setHubPosition(string2);
        } else if ("SUP".equals(string) && null != this.supRI) {
            this.supRI.setHubPosition(string2);
        }
    }

    public void updateLoadedValues() throws BemException {
        if (null != this.cabinetRI) {
            this.cabinetRI.updateLoadedValues();
            String string = PrefixUtil.getCabinetPrefix(String.valueOf(this.cabinetNumber)) + "configureClimate";
            String string2 = PrefixUtil.getCabinetPrefix(String.valueOf(this.cabinetNumber)) + "fanSpeedSupervision";
            YesNoCustomerParameter yesNoCustomerParameter = (YesNoCustomerParameter)this.rbs.getCustomerParameterObject(string);
            BemMo bemMo = this.rbs.getMoHandler().getMo(this.cabinetRI.getLdn());
            if (null != bemMo && bemMo.isExisting() && null != this.climateRI) {
                BemMo bemMo2 = this.rbs.getMoHandler().getMo(this.climateRI.getLdn());
                if (null != bemMo2 && bemMo2.isExisting()) {
                    yesNoCustomerParameter.setLoadedValue("YES");
                    FanSpeedSupervisionParameter fanSpeedSupervisionParameter = (FanSpeedSupervisionParameter)this.rbs.getCustomerParameterObject(string2);
                    Integer n = (Integer)bemMo2.getAttribute("fanSpeedSupervision");
                    fanSpeedSupervisionParameter.setLoadedValue(n);
                } else {
                    yesNoCustomerParameter.setLoadedValue("NO");
                }
            }
        }
    }

    private boolean isSup6601InOneCabinet() throws BemException {
        boolean bl = false;
        if (DuwUtil.isCascadingSupport(this.rbs.getRbsType()) && !DuwUtil.isCascadingMode(this.rbs, 1)) {
            bl = true;
        }
        return bl;
    }

    public List getRIsToBeInstalled() throws BemException {
        String string;
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        String string2 = PrefixUtil.getCabinetPrefix(String.valueOf(this.cabinetNumber));
        String string3 = this.rbs.getCustomerParameter(string2 + "configureClimate");
        String string4 = this.rbs.getCustomerParameter("supportSystemControl");
        if ("TRUE".equals(string4)) {
            String string5;
            string = DuwUtil.isDualBoxConfiguration(this.rbs.getRbsType()) ? "2" : "1";
            String string6 = this.rbs.getCustomerParameter(string2 + "ecBusNumber");
            String string7 = string5 = string6.equals("##UNDEFINED") ? string : string6;
            if (this.hasScu) {
                this.scuRI.setReferredCabinetNumber(String.valueOf(this.cabinetNumber));
                this.scuRI.setEcBusNo4MulCab(string5);
                arrayList.add(this.scuRI);
            }
            if (this.hasClu) {
                this.cluRI.setReferredCabinetNumber(String.valueOf(this.cabinetNumber));
                this.cluRI.setEcBusNo4MulCab(string5);
                arrayList.add(this.cluRI);
            }
            if (this.hasSup) {
                if (this.rbs.isCabinetWiz()) {
                    if (1 == this.cabinetNumber) {
                        this.supRI.setIgnoreEcportInfo(false);
                        arrayList.add(this.supRI);
                    } else if (DuwUtil.isCascadingMode(this.rbs, this.cabinetNumber) || 2 == this.cabinetNumber && DuwUtil.hasDualDuws() && !this.isSup6601InOneCabinet()) {
                        this.supRI.setReferredCabinetNumber(String.valueOf(this.cabinetNumber));
                        this.supRI.setEcBusNo4MulCab(string5);
                        this.supRI.setIgnoreEcportInfo(false);
                        arrayList.add(this.supRI);
                    }
                } else {
                    String string8 = string2 + "cabinetNumber";
                    if (!PowerSystemUtil.isContainDelCabinetCp(this.rbs, this.cabinetNumber) && (this.rbs.isParameterSupported(string8) && !this.rbs.getCustomerParameter(string8).equals("##UNDEFINED") || DuwUtil.isCascadingMode(this.rbs, this.cabinetNumber))) {
                        this.supRI.setReferredCabinetNumber(String.valueOf(this.cabinetNumber));
                        this.supRI.setEcBusNo4MulCab(string5);
                        this.supRI.setIgnoreEcportInfo(false);
                        arrayList.add(this.supRI);
                    }
                }
            }
        }
        if (this.rbs.isCabinetWiz()) {
            if (1 == this.cabinetNumber) {
                arrayList.add(this.cabinetRI);
                if ("YES".equals(string3) && "TRUE".equals(string4)) {
                    arrayList.add(this.climateRI);
                }
            } else if (DuwUtil.isCascadingMode(this.rbs, 2) || 2 == this.cabinetNumber && DuwUtil.hasDualDuws() && !this.isSup6601InOneCabinet()) {
                arrayList.add(this.cabinetRI);
                if ("YES".equals(string3) && "TRUE".equals(string4)) {
                    arrayList.add(this.climateRI);
                }
            }
        } else {
            string = string2 + "cabinetNumber";
            if (!PowerSystemUtil.isContainDelCabinetCp(this.rbs, this.cabinetNumber) && (this.rbs.isParameterSupported(string) && !this.rbs.getCustomerParameter(string).equals("##UNDEFINED") || DuwUtil.isCascadingMode(this.rbs, this.cabinetNumber))) {
                arrayList.add(this.cabinetRI);
                if ("YES".equals(string3) && "TRUE".equals(string4)) {
                    arrayList.add(this.climateRI);
                }
            }
        }
        return arrayList;
    }

    public List getRIsToBeUnInstalled() throws BemException {
        String string;
        CustomerParameterImpl customerParameterImpl;
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        if (this.cabinetNumber != 1 && !(customerParameterImpl = (IntegerParameter)this.rbs.getCustomerParameterObject((string = PrefixUtil.getDeleteCabinetPrefix(String.valueOf(this.cabinetNumber))) + "cabinetNumber")).getValue().equals("##UNDEFINED")) {
            arrayList.add(this.cabinetRI);
        }
        if ((customerParameterImpl = (YesNoCustomerParameter)this.rbs.getCustomerParameterObject((string = PrefixUtil.getCabinetPrefix(String.valueOf(this.cabinetNumber))) + "configureClimate")).hasValueChanged() && !((BooleanCustomerParameter)customerParameterImpl).getBooleanValue() || "FALSE".equals(this.rbs.getCustomerParameter("supportSystemControl"))) {
            arrayList.add(this.climateRI);
        }
        return arrayList;
    }

    public List getCabinetRIs() {
        ArrayList<CabinetRI> arrayList = new ArrayList<CabinetRI>();
        arrayList.add(this.cabinetRI);
        return arrayList;
    }

    public boolean hasClu() {
        return this.hasClu;
    }

    public boolean hasScu() {
        return this.hasScu;
    }

    public boolean hasSup() {
        return this.hasSup;
    }
}

