/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.custparam;

import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EthernetSwitchProvider;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.MomConverter;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEthernetSwitchPort;
import se.ericsson.wcdma.rbs.bem.common.mim.MimLag;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMoImpl;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class LagRefConversion
implements MomConverter {
    private final EthernetSwitchProvider ethernetSwitchProvider;

    public LagRefConversion(EthernetSwitchProvider ethernetSwitchProvider) {
        this.ethernetSwitchProvider = ethernetSwitchProvider;
    }

    public Object convertToMomValue(String string) {
        String string2 = null;
        if (string.equals("") || string.equals("##UNDEFINED")) {
            string2 = null;
        } else if (this.ethernetSwitchProvider != null) {
            try {
                MoInstance moInstance = this.ethernetSwitchProvider.getEthernetSwitchMoi();
                if (moInstance == null) {
                    throw new BemException();
                }
                FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(moInstance, MimLag.MOTYPENAME, string);
                string2 = fixedRdnMoi.getLdn();
            }
            catch (BemException bemException) {
                string2 = null;
            }
        }
        return new BemMoImpl(string2);
    }

    public String convertToParameterValue(Object object) {
        String string = "";
        try {
            string = BemUtil.extractRdnId(((BemMo)object).getDN(), MimLag.MOTYPENAME);
            if (string == null) {
                string = "";
            }
        }
        catch (Exception exception) {
            string = "";
        }
        return string;
    }

    public String getAttributeName() {
        return "lagRef";
    }

    public String getMoTypeName() {
        return MimEthernetSwitchPort.MOTYPENAME;
    }
}

