/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.etmboard.resource;

import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.etmboard.AbstractEtmRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.etmboard.EtmBoard;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEthernetSwitch;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEthernetSwitchPort;
import se.ericsson.wcdma.rbs.bem.common.mim.MimExchangeTerminalIp;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;

public class DeleteEtmfx11RI
extends AbstractEtmRI
implements EtmBoard {
    public static final String name = "ET-MFX11";
    private static final String SWALLOC_ROLE = "RBS_ETMFX11";
    private static final String REPERTOIRE = "CPP_ETMFX11";
    private static final String TRANSPORT_CAPABILTY = "IPv4";
    private static final String MOTYPENAME = MimExchangeTerminalIp.MOTYPENAME;
    private static final String ETM_TYPE = "Etmfx11";

    public DeleteEtmfx11RI(Rbs rbs, int n) {
        super(name, rbs, n, MOTYPENAME, TRANSPORT_CAPABILTY);
        super.setRoleForSwAllocation(SWALLOC_ROLE);
        super.addRepertoiresToInstall(REPERTOIRE);
        super.createPiuAndBoard(true);
    }

    public String getType() {
        return ETM_TYPE;
    }

    public void install(String string) throws BemException {
        if (string.equals("EtmfxCleanupPhase")) {
            this.cleanEtmfxFromBasicCv();
            BemLog.log(7, "ET-MFX11slotNo: " + this.getSlotNo() + " creating DeleteEtmfx11RIs");
        }
    }

    private void cleanEtmfxFromBasicCv() throws BemException {
        if (this.rbs.getRbsStep().equals("STEP_CABINET") && (this.getSlotNo() == 2 || this.getSlotNo() == 3)) {
            SingleChildMoi singleChildMoi = new SingleChildMoi(this.boardMoi, MimEthernetSwitch.MOTYPENAME, "1");
            FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(singleChildMoi, MimEthernetSwitchPort.MOTYPENAME, "1");
            FixedRdnMoi fixedRdnMoi2 = new FixedRdnMoi(singleChildMoi, MimEthernetSwitchPort.MOTYPENAME, "2");
            FixedRdnMoi fixedRdnMoi3 = new FixedRdnMoi(singleChildMoi, MimEthernetSwitchPort.MOTYPENAME, "3");
            if (this.isExisting(fixedRdnMoi2.getLdn()) && !this.isExisting(fixedRdnMoi.getLdn())) {
                this.deleteMoIfExisting(fixedRdnMoi3.getLdn());
                this.deleteMoIfExisting(fixedRdnMoi2.getLdn());
                this.deleteMoIfExisting(singleChildMoi.getLdn());
                this.setAttribute(this.piuMoi.getLdn(), "administrativeState", (Object)new Integer(0));
                this.deleteMoIfExisting(this.boardMoi.getLdn());
                this.deleteMoIfExisting(this.piuMoi.getLdn());
                this.removeSlotFromSwAllocation();
            }
        }
    }
}

