/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.resource;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDnsResolver;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpSystem;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.ReferencedMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class DnsResolverRI
extends AbstractResourceItem {
    public static final String name = "DnsResolverRI";
    public static final String OAM_DNS_IP_ADDRESS_PSEUDO = null;
    public static final String IUB_DNS_IP_ADDRESS_PSEUDO = null;
    private static String[] phases = new String[]{"DnsResolverCreationPhase"};
    private MoInstance ipAccessHostEtMoi = null;
    private MoInstance dnsResolverMoi = null;
    private String dnsResolveMoRdn = "";
    private final List pseudoList = new ArrayList();
    private String prefix;

    public DnsResolverRI(Rbs rbs, MoInstance moInstance, String string) throws BemException {
        super(name, rbs, phases);
        this.setIpAccessHostEtMoi(moInstance);
        this.dnsResolveMoRdn = string;
        this.prefix = this.dnsResolveMoRdn == "1" ? "OamIpHost_" : "Iub_";
        List list = this.getCustomerParameters();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CustomerParameter customerParameter = (CustomerParameter)iterator.next();
            this.pseudoList.add(customerParameter.getName());
        }
        if (moInstance != null) {
            this.initializeMois();
            this.initiateCPWithNodeValues();
        }
    }

    private List getCustomerParameters() throws BemException {
        ArrayList<CustomerParameter> arrayList = new ArrayList<CustomerParameter>();
        for (int i = 1; i <= 3; ++i) {
            arrayList.add(this.rbs.getCustomerParameterObject(this.prefix + "IkePeer_DnsResolver_dnsServerAddress" + i));
        }
        arrayList.add(this.rbs.getCustomerParameterObject(this.prefix + "IkePeer_DnsResolver_dnsServerAutoConfig"));
        arrayList.add(this.rbs.getCustomerParameterObject(this.prefix + "IkePeer_DnsResolver_defDomainName"));
        arrayList.add(this.rbs.getCustomerParameterObject(this.prefix + "IkePeer_DnsResolver_dscp"));
        arrayList.add(this.rbs.getCustomerParameterObject(this.prefix + "IkePeer_DnsResolver_isSubDomainName"));
        return arrayList;
    }

    public boolean isInstalled() throws BemException {
        String string = this.dnsResolverMoi.getLdn();
        BemMo bemMo = this.getMo(string);
        boolean bl = this.isExisting(bemMo);
        return bl;
    }

    public void setIpAccessHostEtMoi(MoInstance moInstance) throws BemException {
        this.ipAccessHostEtMoi = moInstance;
        this.initializeMois();
    }

    private void initiateCPWithNodeValues() throws BemException {
        String string = this.dnsResolverMoi.getLdn();
        BemMo bemMo = this.getMo(string);
        boolean bl = this.isInstalled();
        if (bl) {
            CustomerParameterServer customerParameterServer;
            String[] stringArray = (String[])this.getAttribute(bemMo, "dnsServerAddress");
            for (int i = 1; i <= stringArray.length; ++i) {
                customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + "IkePeer_DnsResolver_dnsServerAddress" + i);
                customerParameterServer.setLoadedValue(stringArray[i - 1]);
            }
            Object object = this.getAttribute(bemMo, "dnsServerAutoConfig");
            customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + "IkePeer_DnsResolver_dnsServerAutoConfig");
            customerParameterServer.setLoadedValue(object);
            object = this.getAttribute(bemMo, "defDomainName");
            customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + "IkePeer_DnsResolver_defDomainName");
            customerParameterServer.setLoadedValue(object);
            object = this.getAttribute(bemMo, "dscp");
            customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + "IkePeer_DnsResolver_dscp");
            customerParameterServer.setLoadedValue(object);
            object = this.getAttribute(bemMo, "isSubDomainName");
            customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + "IkePeer_DnsResolver_isSubDomainName");
            customerParameterServer.setLoadedValue(object);
        }
    }

    private void initializeMois() throws BemException {
        MoInstance moInstance = this.rbs.getRootMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(moInstance, MimIpSystem.MOTYPENAME, "1");
        BemMo bemMo = this.getMo(singleChildMoi.getLdn());
        BemMo[] bemMoArray = this.getChildren(bemMo, 1, MimDnsResolver.MOTYPENAME, "");
        this.dnsResolverMoi = bemMoArray.length > 0 ? new ReferencedMoi(singleChildMoi, MimDnsResolver.MOTYPENAME, "ipAccessHostEtRef", this.ipAccessHostEtMoi, "3") : new FixedRdnMoi(singleChildMoi, MimDnsResolver.MOTYPENAME, this.dnsResolveMoRdn);
    }

    public String getDisplayName() {
        return name;
    }

    public String getLdn() {
        try {
            return this.dnsResolverMoi.getLdn();
        }
        catch (BemException bemException) {
            bemException.printStackTrace();
            return "";
        }
    }

    public void install(String string) throws BemException {
        if (string.equals("DnsResolverCreationPhase")) {
            this.installDnsResolver();
        }
    }

    private void installDnsResolver() throws BemException {
        String[] stringArray;
        String string;
        Vector<NalNameValue> vector;
        String string2 = this.dnsResolverMoi.getLdn();
        BemMo bemMo = this.getMo(string2);
        boolean bl = this.isInstalled();
        if (!bl) {
            CustomerParameterServer customerParameterServer;
            String string3;
            CustomerParameter customerParameter;
            Object object;
            vector = new Vector<NalNameValue>();
            string = "DnsResolverId";
            Object object2 = this.dnsResolveMoRdn;
            vector.add(Nal.getFactory().getNameValue(string, object2));
            if (this.ipAccessHostEtMoi != null) {
                string = "ipAccessHostEtRef";
                object = this.getMo(this.ipAccessHostEtMoi.getLdn());
                vector.add(Nal.getFactory().getNameValue(string, object));
            }
            if ((customerParameter = this.rbs.getCustomerParameterObject(string3 = this.prefix + "IkePeer_DnsResolver_dnsServerAutoConfig")).isValidValue()) {
                string = "dnsServerAutoConfig";
                customerParameterServer = this.rbs.getCustomerParameterServerObject(string3);
                object2 = customerParameterServer.getValueMom();
                vector.add(Nal.getFactory().getNameValue(string, object2));
            }
            if ((customerParameter = this.rbs.getCustomerParameterObject(string3 = this.prefix + "IkePeer_DnsResolver_defDomainName")).isValidValue()) {
                string = "defDomainName";
                customerParameterServer = this.rbs.getCustomerParameterServerObject(string3);
                object2 = customerParameterServer.getValueMom();
                vector.add(Nal.getFactory().getNameValue(string, object2));
            }
            if ((customerParameter = this.rbs.getCustomerParameterObject(string3 = this.prefix + "IkePeer_DnsResolver_dscp")).isValidValue()) {
                string = "dscp";
                customerParameterServer = this.rbs.getCustomerParameterServerObject(string3);
                object2 = customerParameterServer.getValueMom();
                vector.add(Nal.getFactory().getNameValue(string, object2));
            }
            if ((customerParameter = this.rbs.getCustomerParameterObject(string3 = this.prefix + "IkePeer_DnsResolver_isSubDomainName")).isValidValue()) {
                string = "isSubDomainName";
                customerParameterServer = this.rbs.getCustomerParameterServerObject(string3);
                object2 = customerParameterServer.getValueMom();
                vector.add(Nal.getFactory().getNameValue(string, object2));
            }
            string = "dnsServerAddress";
            object = new ArrayList();
            for (int i = 1; i <= 3; ++i) {
                string3 = this.prefix + "IkePeer_DnsResolver_dnsServerAddress" + i;
                customerParameter = this.rbs.getCustomerParameterObject(string3);
                if (!customerParameter.isValidValue()) continue;
                customerParameterServer = this.rbs.getCustomerParameterServerObject(string3);
                object2 = customerParameterServer.getValueMom();
                object.add((String)object2);
            }
            stringArray = new String[object.size()];
            for (int i = 0; i < object.size(); ++i) {
                stringArray[i] = (String)object.get(i);
            }
        } else {
            String string4 = "Not support to change a exsiting DnsResolver MO(Ldn=" + this.getLdn() + ").\n";
            throw new BemException(string4);
        }
        vector.add(Nal.getFactory().getNameValue(string, stringArray));
        this.create(bemMo, vector);
    }

    public MoInstance getIpAccessHostEtMoi() {
        return this.ipAccessHostEtMoi;
    }

    public boolean shouldRiBeInstalled() throws BemException {
        boolean bl = false;
        if (this.isInstalled()) {
            Iterator iterator = this.pseudoList.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
                boolean bl2 = customerParameter.hasValueChanged();
                if (!bl2) continue;
                bl = bl2;
                break;
            }
        } else {
            Iterator iterator = this.pseudoList.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
                if (!customerParameter.isValidValue()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public MoInstance getMoi() {
        return this.dnsResolverMoi;
    }
}

