/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs4;

import java.util.ArrayList;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractDbControlledAuxillaryUnitRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalFactory;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class FcuRI
extends AbstractDbControlledAuxillaryUnitRI {
    public static final String NAME = "FCU";
    private static final String piuTypeProductName = "FCU";
    private String ldn = null;
    private Integer[] cabinetParameters;

    public FcuRI(Rbs rbs, Integer[] integerArray, String string) {
        super("FCU", rbs, 13, "FCU", "CONTROLLER_OF_FCU");
        this.ldn = string;
        this.cabinetParameters = integerArray;
    }

    public void install(String string) throws BemException {
        super.install(string);
        if (string.equals("CabinetParametersSettingsPhase")) {
            for (int i = 0; i < 5; ++i) {
                if (this.fcuMoExists()) {
                    this.setCabinetParameters();
                    break;
                }
                this.delay();
            }
            if (!this.fcuMoExists()) {
                throw new BemException("", "install()", this.ldn, "Trying to set Cabinet Parameters, but no Fcu Mo created.", null);
            }
        }
    }

    private boolean fcuMoExists() throws BemException {
        MoHandler moHandler = this.rbs.getMoHandler();
        try {
            BemMo bemMo = moHandler.getMo(this.ldn);
            return moHandler.isExisting(bemMo);
        }
        catch (MoHandlerException moHandlerException) {
            String string = moHandlerException.getAction();
            String string2 = moHandlerException.getAdditionalInfo();
            throw new BemException(string, "fcuMoExists()", this.ldn, string2, moHandlerException);
        }
    }

    private void delay() {
        try {
            long l = 1500L;
            NalFactory nalFactory = Nal.getFactory();
            nalFactory.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setCabinetParameters() throws BemException {
        MoHandler moHandler = this.rbs.getMoHandler();
        BemMo bemMo = moHandler.getMo(this.ldn);
        try {
            moHandler.setAttribute(bemMo, "cabinetParameters", this.cabinetParameters);
        }
        catch (MoHandlerException moHandlerException) {
            String string = moHandlerException.getAction();
            throw new BemException(string, this.ldn, (Throwable)moHandlerException);
        }
    }

    public String[] getInstallationPhases() {
        String[] stringArray = super.getInstallationPhases();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[0]);
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getDisplayName() {
        return "FCU: " + this.getLdn();
    }
}

