/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment;

import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDigitalCable;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class DbbManager {
    private Rbs rbs;

    public DbbManager(Rbs rbs) {
        this.rbs = rbs;
    }

    public static String getDbbValue(Rbs rbs) {
        String string = "SYSTEM_DEFINED";
        try {
            if (rbs.isParameterSupported("digitalBuildingBlock")) {
                CustomerParameter customerParameter = rbs.getCustomerParameterObject("digitalBuildingBlock");
                string = customerParameter.getValue();
            }
        }
        catch (BemException bemException) {
            BemLog.exceptionRaised("Error happened when fetching digital building block", bemException);
            bemException.printStackTrace();
        }
        return string;
    }

    public boolean isTwoCpriLinkInstalled() throws BemException {
        boolean bl = false;
        try {
            MoHandler moHandler = this.rbs.getMoHandler();
            BemMo bemMo = moHandler.getMo(this.rbs.getRootMoi().getLdn());
            BemMo[] bemMoArray = moHandler.getChildren(bemMo, 2, MimDigitalCable.MOTYPENAME, "");
            for (int i = 0; i < bemMoArray.length; ++i) {
                if (bemMoArray[i] == null || !bemMoArray[i].getLastRDN().endsWith("1_1_RI_E")) continue;
                String string = bemMoArray[i].getAttribute("connectedToObjectBRef").toString();
                if (!DuwUtil.getSecondaryDuwPiuLdn().equals(string)) continue;
                bl = true;
                break;
            }
        }
        catch (MoHandlerException moHandlerException) {
            moHandlerException.printStackTrace();
            throw new BemException(moHandlerException.getMessage(), (Throwable)moHandlerException);
        }
        return bl;
    }
}

