/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment;

import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuRI;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRbsSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRuDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.RbsSubrackMoi;

public class RuSubrackRI
extends AbstractRbsSubrackRI {
    private static final String name = "RuSubrack";
    private RuRI[] boards;
    private MoInstance moi;
    private String ldn;
    private int firstPositionSlot;

    public RuSubrackRI(Rbs rbs, int n, String string, String string2) throws BemException {
        this(rbs, n, string, string2, 2);
    }

    public RuSubrackRI(Rbs rbs, int n, String string, String string2, int n2) throws BemException {
        super(name, rbs, n, string, string2);
        this.boards = new RuRI[n];
        this.moi = new RbsSubrackMoi(new String[]{MimRuDeviceGroup.MOTYPENAME}, "RU1");
        this.ldn = this.moi.getLdn();
        this.firstPositionSlot = n2;
        for (int i = n2; i <= n; ++i) {
            this.createSlot(i, new RuRI(rbs, this.moi, i));
        }
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getDisplayName() {
        return "RuSubrack:" + this.ldn;
    }

    public RuRI[] getSubRIs() {
        RuRI[] ruRIArray = new RuRI[this.boards.length - (this.firstPositionSlot - 1)];
        for (int i = 0; i < ruRIArray.length; ++i) {
            ruRIArray[i] = this.boards[i + (this.firstPositionSlot - 1)];
        }
        return ruRIArray;
    }

    public RuRI getSlot(int n) throws BemException {
        if (n < this.firstPositionSlot || n > this.getNoOfSlots()) {
            throw new BemException("RuSubrack.getSlot() slot number out of range: " + n);
        }
        return this.boards[n - 1];
    }

    private void createSlot(int n, RuRI ruRI) {
        this.boards[n - 1] = ruRI;
    }
}

