/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.AbstractRbs3Configuration;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.ConfigurationCableData;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.ConfigurationData;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.nonautogenerated.MimAntennaBranchDef;
import se.ericsson.wcdma.rbs.bem.common.mim.nonautogenerated.MimConnFieldConnectors;

public class Configuration1External
extends AbstractRbs3Configuration {
    public static final String name = "Configuration 1 External";
    private static final int NO_OF_CARRIERS = 1;
    private static final String OUTPUT_POWER = "EXTERNAL";
    private static final int NO_OF_TX_BRANCHES = 1;

    public Configuration1External(Rbs rbs, int n, ConfigurationData configurationData, ConfigurationCableData configurationCableData) throws BemException {
        super(name, rbs, n, 1, OUTPUT_POWER, 1, configurationData, configurationCableData);
    }

    public boolean isInstalled() throws BemException {
        return this.isAiuInstalled() && this.isOneTrxInstalled() && !this.isMcpaSubrackInstalled() && !this.isAnyMcpaInstalled() && this.isAnyRfifInstalled() && this.isAnyBbifInstalled();
    }

    protected List getSubrackResourceItems() throws BemException {
        return new ArrayList();
    }

    protected List getBoardResourceItems() throws BemException {
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        arrayList.add(this.getTrx1());
        arrayList.add(this.getAiu());
        arrayList.add(this.getRfif1());
        arrayList.add(this.getBbif1());
        return arrayList;
    }

    protected List getCableResourceItems() throws BemException {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getTrxRfCable1());
        arrayList.addAll(this.getIntJumperCables());
        arrayList.addAll(this.getRfif_BbifCables1());
        return arrayList;
    }

    protected Integer getTrxRfCable1AiuConnector() {
        return new Integer(5);
    }

    protected Integer getTrxRfCable2AiuConnector() {
        return null;
    }

    protected Integer getTrxRfCable2TrxConnector() {
        return null;
    }

    protected Integer getHiPowTxCable1AiuConnector() {
        return null;
    }

    protected Integer getHiPowTxCable2AiuConnector() {
        return null;
    }

    public String getConnectionFieldConnector(int n, String string) {
        if (string.equals(MimAntennaBranchDef.BRANCH_A)) {
            return MimConnFieldConnectors.CONNECTOR_J_AND_K[n - 1];
        }
        if (string.equals(MimAntennaBranchDef.BRANCH_B)) {
            return MimConnFieldConnectors.CONNECTOR_J[n * 2 - 1];
        }
        throw new Error("Unknown branch: " + string);
    }
}

