/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.check.ConfigurationCheckReport;
import se.ericsson.wcdma.rbs.bem.common.config.check.ReportEntry;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RfCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.AbstractConfiguration;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.AtfProviderInfo;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.PauRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.SAiuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.STrxRI;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimConnectionField;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;

public class ConfigurationMicro
extends AbstractConfiguration {
    public static final String name = "Configuration Micro";
    private static final int NO_OF_CARRIERS = 1;
    private static final String OUTPUT_POWER = "NORMAL";
    private static final int NO_OF_TX_BRANCHES = 1;
    private Rbs rbs;
    private List ris = new ArrayList();
    private PauRI pauRI;
    private SAiuRI sAiuRI;
    private STrxRI sTrxRI;
    private List rfCables = new ArrayList();
    String connectionFieldLdn;
    AtfProviderInfo[] atfReferences = null;

    public ConfigurationMicro(Rbs rbs, int n, MoInstance moInstance, int n2) throws BemException {
        super(name, n, 1, OUTPUT_POWER, 1);
        this.rbs = rbs;
        this.getConnectionFieldLdn();
        this.createResourceItems(moInstance, n2);
    }

    private void createResourceItems(MoInstance moInstance, int n) throws BemException {
        this.pauRI = new PauRI(this.rbs);
        this.ris.add(this.pauRI);
        this.sAiuRI = new SAiuRI(this.rbs);
        this.ris.add(this.sAiuRI);
        this.sTrxRI = new STrxRI(this.rbs, n, moInstance);
        this.ris.add(this.sTrxRI);
        this.rfCables.add(new RfCableRI(this.rbs, this.sTrxRI.getLdn(), 1, this.pauRI.getLdn(), 1, -1, 41, -1, 11, 1));
        this.rfCables.add(new RfCableRI(this.rbs, this.pauRI.getLdn(), 2, this.sTrxRI.getLdn(), 2, 41, -1, 10, -1, 1));
        this.rfCables.add(new RfCableRI(this.rbs, this.pauRI.getLdn(), 3, this.sAiuRI.getLdn(), 1, -1, 5, -1, 2, 1));
        this.rfCables.add(new RfCableRI(this.rbs, this.sAiuRI.getLdn(), 4, this.connectionFieldLdn, 5, 8, 8, 2, 2, 1));
        this.rfCables.add(new RfCableRI(this.rbs, this.sAiuRI.getLdn(), 5, this.connectionFieldLdn, 6, 8, 8, 2, 2, 1));
        this.rfCables.add(new RfCableRI(this.rbs, this.sAiuRI.getLdn(), 6, this.sTrxRI.getLdn(), 3, 14, -1, 4, -1, 1));
        this.rfCables.add(new RfCableRI(this.rbs, this.sAiuRI.getLdn(), 7, this.sTrxRI.getLdn(), 4, 14, -1, 4, -1, 1));
        this.ris.addAll(this.rfCables);
    }

    private void getConnectionFieldLdn() throws BemException {
        MoInstance moInstance = this.rbs.getEquipmentMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(moInstance, MimConnectionField.MOTYPENAME, "1");
        this.connectionFieldLdn = singleChildMoi.getLdn();
    }

    public List getResourceItems() throws BemException {
        return this.ris;
    }

    public boolean isInstalled() throws BemException {
        return this.pauRI.isInstalled() && this.sAiuRI.isInstalled() && this.sTrxRI.isInstalled();
    }

    public String getTerminationObject(String string) throws BemException {
        return this.connectionFieldLdn;
    }

    public ConfigurationCheckReport checkConfiguration() throws BemException {
        List list = this.checkCables();
        return new ConfigurationCheckReport(list);
    }

    private List checkCables() throws BemException {
        ArrayList<ReportEntry> arrayList = new ArrayList<ReportEntry>();
        Iterator iterator = this.rfCables.iterator();
        while (iterator.hasNext()) {
            ResourceItem resourceItem = (ResourceItem)iterator.next();
            if (resourceItem.isInstalled()) continue;
            arrayList.add(new ReportEntry("Warning", "", "", "", "Cannot find cable, " + ((Object)resourceItem).toString() + ". "));
        }
        return arrayList;
    }

    public AtfProviderInfo[] getAtfProviderInfo() {
        if (this.atfReferences != null) {
            return this.atfReferences;
        }
        this.atfReferences = new AtfProviderInfo[]{new AtfProviderInfo("CONTROLLER_OF_PAU", this.sTrxRI.getPiuLdn()), new AtfProviderInfo("CONTROLLER_OF_sAIU", this.sTrxRI.getPiuLdn())};
        return this.atfReferences;
    }
}

