/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.CellAndCarrierProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt.ModifyHandler;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt.ModifyManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt.ModifyUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.scpm.SectorCustomerParameterManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;

public class ModifyCarrierHandler
extends ModifyHandler {
    private static final String[] ALL_MODIFIABLE_CARRIER_ATTRIBUTES = new String[]{"numberOfRxBranches"};

    public ModifyCarrierHandler(ModifyManager modifyManager, int n) throws BemException {
        super(modifyManager);
    }

    public void checkConsistency() throws BemException {
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            for (int j = 0; j < this.getMaxNoOfCarriers(); ++j) {
                int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
                this.getCellAndCarrierProvider().getCellAndCarrierDomainForSector(n)[j].checkConsistency(2);
            }
        }
    }

    private CellAndCarrierProvider getCellAndCarrierProvider() throws BemException {
        int n = 0;
        if (this.getRbs().isPantherHybridRbs() && this.startingSectorNumber == 7) {
            n = 1;
        }
        CellAndCarrierProvider cellAndCarrierProvider = this.getRbs().getCellAndCarrierProvider(n);
        return cellAndCarrierProvider;
    }

    public void doModification() throws BemException {
    }

    public List getAllCpPseudoNames() {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    public HashMap getRIsToUninstall() throws BemException {
        HashMap hashMap = new HashMap();
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            for (int j = 0; j < this.getMaxNoOfCarriers(); ++j) {
                if (!this.isCarrierModified(i, j)) continue;
                hashMap.putAll(this.getCellAndCarrierProvider().getAllCellAndCarrierDomain()[i][j].modify());
            }
        }
        return hashMap;
    }

    private boolean isCarrierModified(int n, int n2) throws BemException {
        ServiceValue serviceValue = this.getModifyManager().getServiceValue();
        boolean bl = false;
        if (serviceValue != null) {
            Vector vector = this.getModifyManager().getServiceValue().getValues("ModifySector");
            for (int i = 0; i < ALL_MODIFIABLE_CARRIER_ATTRIBUTES.length && !(bl = ModifyUtil.isCarrierAttributeInNameValueVector(vector, n, n2, ALL_MODIFIABLE_CARRIER_ATTRIBUTES[i], this.startingSectorNumber)); ++i) {
            }
        }
        return bl;
    }

    public void updateScpmIfAppropriate(SectorCustomerParameterManager sectorCustomerParameterManager) throws BemException {
    }
}

