/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.reconfigurations;

import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.FreeConnectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.FuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuwRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RadioBuildingBlock;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.reconfigurations.Precondition;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.AtfProvider;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAntFeederCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimFuDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRfCable;
import se.ericsson.wcdma.rbs.bem.common.moi.RbsSubrackMoi;

public class BranchBDisconnected
implements Precondition {
    private Rbs rbs;
    private String failReason;
    private RadioBuildingBlock from;

    public BranchBDisconnected(Rbs rbs, RadioBuildingBlock radioBuildingBlock, RadioBuildingBlock radioBuildingBlock2) {
        this.rbs = rbs;
        this.from = radioBuildingBlock;
        this.failReason = "";
    }

    public boolean isMet(int n) throws BemException {
        String string;
        boolean bl = false;
        if (this.from.getNoOfRus() > 0) {
            RbsSubrackMoi rbsSubrackMoi = new RbsSubrackMoi(new String[]{MimFuDeviceGroup.MOTYPENAME}, "FU1");
            FuRI fuRI = new FuRI(this.rbs, rbsSubrackMoi, n * 2, AtfProvider.ALL_CONTROLLERS_OF_FU_INDEXED_BY_POSITION[n * 2 - 1]);
            FreeConnectorRI freeConnectorRI = new FreeConnectorRI(this.rbs, fuRI.getAuxPiuLdn(), 9, MimRfCable.MOTYPENAME, "objectAConnector");
            string = fuRI.getSlotNumber() + ":FU";
            if (freeConnectorRI.isInstalled()) {
                this.failReason = "";
                bl = true;
            }
        } else {
            int n2 = 2 * n;
            if (n > 3) {
                n2 = 2 * (n - 3) + 1;
            }
            RbsSubrackMoi rbsSubrackMoi = new RbsSubrackMoi(new String[]{MimDeviceGroup.MOTYPENAME}, "RUW");
            RuwRI ruwRI = new RuwRI(this.rbs, rbsSubrackMoi, n2);
            FreeConnectorRI freeConnectorRI = new FreeConnectorRI(this.rbs, ruwRI.getAuxPiuLdn(), 2, MimAntFeederCable.MOTYPENAME, "objectAConnector");
            string = ruwRI.getSlotNumber() + ":RUW";
            if (freeConnectorRI.isInstalled()) {
                this.failReason = "";
                bl = true;
            }
        }
        if (bl) {
            this.failReason = "";
        } else if (this.rbs.getCellAndCarrierProvider().isSectorInitialised(n)) {
            this.failReason = "Antenna branch B has not been disconnected for " + string;
            if (this.rbs.getCellAndCarrierProvider().isSectorUninitiateRequested(n)) {
                this.failReason = "";
                bl = true;
            } else {
                this.failReason = this.failReason + " nor is the sector requested to be uninitiated";
            }
        } else {
            this.failReason = "";
            bl = true;
        }
        return bl;
    }

    public String getFailReason() {
        return this.failReason;
    }
}

