/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3402.configitem;

import java.util.ArrayList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.AbstractRbs3RadioEquipmentCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.ConfigurationMainRemoteWithRet;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.SectorCapability;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRaxDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTxDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.nonautogenerated.MimAntennaBranchDef;
import se.ericsson.wcdma.rbs.bem.common.moi.HubSubrackMoi;

public class RadioEquipment3402CI
extends AbstractRbs3RadioEquipmentCI {
    private static final int OBIF_SLOT_NO = 9;
    private EnumeratedRange radioIfTypeRange;

    public RadioEquipment3402CI(Rbs rbs) {
        super(rbs);
        this.setBoardPositions(MimRaxDeviceGroup.MOTYPENAME, new String[]{"6", "7", "8"});
        this.setBoardPositions(MimTxDeviceGroup.MOTYPENAME, new String[]{"5"});
    }

    public boolean open() throws BemException {
        this.initiateCPRanges();
        return super.open();
    }

    protected void createConfigurations() throws BemException {
        Rbs rbs = this.getRbs();
        int n = rbs.getMaxNumberOfSectors();
        int n2 = rbs.getMaxNumberOfCarriers();
        for (int i = 1; i <= n; ++i) {
            HubSubrackMoi hubSubrackMoi = new HubSubrackMoi(this.getRbs().getEquipmentMoi());
            ConfigurationMainRemoteWithRet configurationMainRemoteWithRet = new ConfigurationMainRemoteWithRet(this.getRbs(), i, n2, hubSubrackMoi, 9);
            SectorCapability sectorCapability = new SectorCapability();
            sectorCapability.addConfiguration(configurationMainRemoteWithRet);
            this.addSectorCapability(i, sectorCapability);
        }
    }

    public Integer getTerminationConnector(int n, String string) throws BemException {
        Integer[] integerArray;
        if (string.equalsIgnoreCase("DL")) {
            integerArray = new Integer[]{new Integer(1), new Integer(2), new Integer(3)};
        } else if (string.equalsIgnoreCase("UL")) {
            integerArray = new Integer[]{new Integer(1), new Integer(2), new Integer(3)};
        } else {
            if (string.equalsIgnoreCase(MimAntennaBranchDef.BRANCH_A)) {
                return new Integer(1);
            }
            if (string.equalsIgnoreCase(MimAntennaBranchDef.BRANCH_B)) {
                return new Integer(2);
            }
            throw new BemException(this.getClass().getName() + " getTerminationConnector(): Type " + string + " not supported");
        }
        return integerArray[n - 1];
    }

    public boolean useCreateSectorParameter() {
        return true;
    }

    private void initiateCPRanges() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("OBIF");
        this.radioIfTypeRange = new EnumeratedRange(arrayList);
    }

    protected EnumeratedRange getRadioIfTypeRange() {
        return this.radioIfTypeRange;
    }
}

