/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.resource;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.RbsUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractSwHandlingRI;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimCabinet;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDpProgram;
import se.ericsson.wcdma.rbs.bem.common.mim.MimHwGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimProgram;
import se.ericsson.wcdma.rbs.bem.common.mim.MimXpProgram;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.LdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public abstract class AbstractAuxillaryUnitRI
extends AbstractSwHandlingRI
implements ResourceItem {
    private final int auType;
    private String atfRole;
    protected int hubPosition = 99;
    private boolean isSwLoadable;
    private boolean newBoard = false;
    private boolean isDeleted = false;
    private String piuTypeProductName = null;
    private String piuTypeProductNumber = null;
    private String uniqueHwId = null;
    private String cabinetNumber = null;
    private String posPrefix = "";

    public AbstractAuxillaryUnitRI(String string, Rbs rbs, int n, String string2, String[] stringArray, String string3) {
        super(string, rbs, stringArray);
        this.auType = n;
        this.atfRole = string3;
        this.piuTypeProductName = string2;
    }

    public AbstractAuxillaryUnitRI(String string, Rbs rbs, int n, String string2, String string3, String[] stringArray, String string4) {
        super(string, rbs, stringArray);
        this.auType = n;
        this.atfRole = string4;
        this.piuTypeProductName = string2;
        this.piuTypeProductNumber = string3;
    }

    private void verifyAuxPiuMo(BemMo bemMo) throws BemException {
        String string = bemMo.getType();
        if (!string.equals(MimAuxPlugInUnit.MOTYPENAME)) {
            throw new BemException("AbstractAuxiliaryUnitRI.verifyAuxPiuMo(): MO is not an AuxPlugInUnit:" + bemMo.getDN());
        }
    }

    protected final void createAuxPiuIfNotExisting(String string) throws BemException {
        int n = this.getDuwSlot();
        String string2 = this.rbs.getPrimaryAtfLdn(this.atfRole, n);
        String string3 = this.rbs.getSecondaryAtfLdn(this.atfRole, n);
        this.createAuxPiuIfNotExisting(string, string2, string3);
    }

    private final void createAuxPiuIfNotExisting(String string, String string2, String string3) throws BemException {
        BemMo bemMo = this.getMo(string);
        BemMo bemMo2 = super.getPiuType();
        if (bemMo2 == null) {
            bemMo2 = this.piuTypeProductNumber != null ? this.getPiuTypeFromProductNameAndNumber() : this.getPiuType(this.piuTypeProductName);
        }
        BemMo bemMo3 = bemMo.getParent();
        Boolean bl = this.getIsSharedWithExternalMeConfiguredValue();
        try {
            this.verifyAuxPiuMo(bemMo3);
            this.createAuxPlugInUnitIfNotExisting(bemMo3, this.auType, this.hubPosition, bemMo2, string2, string3, bl);
        }
        catch (RuntimeException runtimeException) {
            String string4 = "AbstractAuxiliaryUnit.create()";
            String string5 = runtimeException.toString();
            throw new BemException(string4, "createAuxPiuIfNotExisting()", string, string5, runtimeException);
        }
    }

    private final void deleteAuxPiuAndBoard() throws BemException {
        String string = this.getLdn();
        BemMo bemMo = this.getMo(string);
        BemMo bemMo2 = bemMo.getParent();
        String string2 = bemMo2.getDN();
        this.isDeleted = true;
        try {
            this.deleteMoIfExisting(string);
            this.deleteMoIfExisting(string2);
        }
        catch (RuntimeException runtimeException) {
            String string3 = "AbstractAuxiliaryUnit.delete()";
            String string4 = runtimeException.toString();
            throw new BemException(string3, "deleteAuxPiuAndBoardMoIfExisting()", string, string4, runtimeException);
        }
    }

    private void createAuxPlugInUnitIfNotExisting(BemMo bemMo, int n, int n2, BemMo bemMo2, String string, String string2, Boolean bl) throws BemException {
        boolean bl2 = this.isExisting(bemMo);
        if (!bl2) {
            this.newBoard = true;
            this.createAuxPlugInUnit(bemMo, n, n2, bemMo2, string, string2, bl);
        } else if (null != this.cabinetNumber && !"".equals(this.cabinetNumber)) {
            FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(this.rbs.getMoiRefs().getEquipmentMoi(), MimCabinet.MOTYPENAME, this.cabinetNumber);
            BemMo bemMo3 = this.rbs.getMoHandler().getMo(fixedRdnMoi.getLdn());
            if (!bemMo3.isExisting()) {
                throw new BemException(bemMo.getDN() + ", set positionRef=[ " + bemMo3.getDN() + "], but it does not exist on the node");
            }
            this.setAttribute(bemMo, "positionRef", (Object)bemMo3);
        }
    }

    private void createAuxPlugInUnit(BemMo bemMo, int n, int n2, BemMo bemMo2, String string, String string2, Boolean bl) throws BemException {
        Object object;
        boolean bl2;
        this.verifyAuxPiuMo(bemMo);
        Vector<NalNameValue> vector = new Vector<NalNameValue>(0);
        vector.addElement(Nal.getFactory().getNameValue("auType", new Integer(n)));
        vector.addElement(Nal.getFactory().getNameValue("hubPosition", new Integer(n2)));
        vector.addElement(Nal.getFactory().getNameValue("piuType", bemMo2));
        vector.addElement(Nal.getFactory().getNameValue("administrativeState", new Integer(0)));
        vector.addElement(Nal.getFactory().getNameValue("isSharedWithExternalMe", bl));
        BemMo bemMo3 = this.getMo(string);
        boolean bl3 = this.isExisting(bemMo3);
        if (!bl3) {
            throw new BemException("BoardConfigBase- Creation of " + bemMo.getDN() + ": The referenced PlugInUnit " + bemMo3 + " does not exist.");
        }
        vector.addElement(Nal.getFactory().getNameValue("plugInUnitRef1", bemMo3));
        if (string2 != null && (bl2 = this.isExisting((BemMo)(object = this.getMo(string2))))) {
            vector.addElement(Nal.getFactory().getNameValue("plugInUnitRef2", object));
        }
        if (this.uniqueHwId != null) {
            vector.addElement(Nal.getFactory().getNameValue("uniqueHwId", this.uniqueHwId));
        }
        if (this.cabinetNumber != null && !"".equals(this.cabinetNumber)) {
            object = new FixedRdnMoi(this.rbs.getMoiRefs().getEquipmentMoi(), MimCabinet.MOTYPENAME, this.cabinetNumber);
            BemMo bemMo4 = this.rbs.getMoHandler().getMo(((MoInstance)object).getLdn());
            if (!bemMo4.isExisting()) {
                throw new BemException("the MO " + bemMo4.getDN() + " does not exist on the node");
            }
            vector.addElement(Nal.getFactory().getNameValue("positionRef", bemMo4));
        }
        this.create(bemMo, vector);
    }

    private void addSlotToSwAllocation() throws BemException {
        try {
            BemMo bemMo = this.getSwAllocationMOForRole(this.getRoleForSwAllocation());
            BemMo bemMo2 = this.getMo(this.getLdn());
            BemMo bemMo3 = this.getParent(bemMo2);
            BemMo bemMo4 = this.checkIfSlotAlreadyInUse(bemMo3);
            boolean bl = false;
            if (bemMo4 != null) {
                bl = true;
                if (!((Object)bemMo).equals(bemMo4)) {
                    if (bemMo.getAttribute("role").equals("RBS_TMA") && bemMo4.getAttribute("role").equals("RBS_ASC")) {
                        bl = true;
                    } else if (this.moveSlotAllowed) {
                        this.deleteSlotIfConnected(bemMo4, bemMo3);
                        bl = false;
                    } else {
                        String string = "Check if slot is already in use by other SwAllocations";
                        throw new BemException(string);
                    }
                }
            }
            if (!bl) {
                NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("aSlot", bemMo3)};
                this.action(bemMo, "addSlot", nalNameValueArray);
            }
        }
        catch (RuntimeException runtimeException) {
            String string = "Adding AuxPiu to the SwAllocation MO";
            String string2 = runtimeException.toString();
            throw new BemException(string, "addSlotToSwAllocation()", this.getLdn(), string2, runtimeException);
        }
    }

    private void removeSlotFromSwAllocation() throws BemException {
        try {
            BemMo bemMo = this.getSwAllocationMOForRole(this.getRoleForSwAllocation());
            BemMo bemMo2 = this.getMo(this.getLdn());
            BemMo bemMo3 = this.getParent(bemMo2);
            boolean bl = this.checkIfSlotIsAlreadyConnected(bemMo, bemMo3);
            if (bl) {
                NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("aSlot", bemMo3)};
                this.action(bemMo, "deleteSlot", nalNameValueArray);
            }
        }
        catch (RuntimeException runtimeException) {
            String string = "Removing AuxPiu from the SwAllocation MO";
            String string2 = runtimeException.toString();
            throw new BemException(string, "removeSlotFromSwAllocation()", this.getLdn(), string2, runtimeException);
        }
    }

    protected void setSwLoadable(boolean bl) {
        this.isSwLoadable = bl;
    }

    protected void setUniqueHwId(String string) {
        this.uniqueHwId = string;
    }

    protected String getUniqueHwId() {
        return this.uniqueHwId;
    }

    public void install(String string) throws BemException {
        if (string.equals("InstallPiuTypesPhase")) {
            if (!this.isDeleted) {
                this.installPiuTypes();
            }
        } else if (super.containsPhase(this.getInstallationPhases(), string)) {
            if (string.equals("AuxUnitAuxControlledCreationPhase") || string.equals("AuxUnitDbControlledCreationPhase")) {
                if (this.isSwLoadable) {
                    super.createSwAllocationIfNotExisting();
                    super.updateSwAllocation();
                }
                String string2 = this.getLdn();
                this.createAuxPiuIfNotExisting(string2);
                this.updatePiuRef2();
                if (this.isSwLoadable) {
                    this.addSlotToSwAllocation();
                }
            } else if (string.equals("AuxUnitReconfigureProgramPreparePhase")) {
                if (this.isSwLoadable && this.newBoard) {
                    this.reconfigureProgramPrepare();
                }
            } else if (string.equals("UnlockAllUnitsPhase")) {
                super.unlock("administrativeState");
            } else if (string.equals("UnlockPhase")) {
                this.handleUnlockPhase();
            }
        } else if (string.equals("PositionSettingPhase")) {
            this.setPositionInfo();
        } else if (string.equals("IsSharedWithExternalMeSettingPhase")) {
            this.setIsSharedWithExternalMe();
        }
    }

    protected void handleUnlockPhase() throws BemException {
        if (this.newBoard) {
            super.unlock("administrativeState");
        }
    }

    public void uninstall(String string) throws BemException {
        if (string.equals("LockPhase")) {
            super.lock("administrativeState");
        }
        if (super.containsPhase(this.getInstallationPhases(), string) && (string.equals("AuxUnitDbControlledDeletionPhase") || string.equals("AuxUnitAuxControlledDeletionPhase"))) {
            this.handleDeletionPhase();
        }
    }

    protected void handleDeletionPhase() throws BemException {
        if (this.isSwLoadable) {
            this.removeSlotFromSwAllocation();
            this.deletePrograms();
        }
        this.deleteAuxPiuAndBoard();
    }

    private void updatePiuRef2() throws BemException {
        if (!this.isInstalled()) {
            return;
        }
        int n = this.getDuwSlot();
        String string = this.rbs.getSecondaryAtfLdn(this.atfRole, n);
        if (string == null) {
            return;
        }
        BemMo bemMo = this.getMo(string);
        if (!this.isExisting(bemMo)) {
            return;
        }
        String string2 = this.getLdn();
        BemMo bemMo2 = this.getMo(string2);
        BemMo bemMo3 = bemMo2.getParent();
        BemMo bemMo4 = (BemMo)this.getAttribute(bemMo3, "plugInUnitRef2");
        if (bemMo4 == null || !((Object)bemMo4).equals(bemMo)) {
            BemMo bemMo5 = this.getMo(string);
            this.setAttribute(bemMo3, "plugInUnitRef2", (Object)bemMo5);
        }
    }

    private void deletePrograms() throws BemException {
        String string = this.getLdn();
        BemMo bemMo = this.getMo(string);
        BemMo bemMo2 = bemMo.getParent();
        try {
            if (!bemMo2.isExisting()) {
                return;
            }
            BemMo[] bemMoArray = this.getChildren(bemMo2, 10, "", "");
            if (bemMoArray != null) {
                for (int i = 0; i < bemMoArray.length; ++i) {
                    BemMo bemMo3 = bemMoArray[i];
                    String string2 = bemMo3.getType();
                    if (!string2.equals(MimDpProgram.MOTYPENAME) && !string2.equals(MimXpProgram.MOTYPENAME) && !string2.equals(MimProgram.MOTYPENAME)) continue;
                    this.delete(bemMo3);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            String string3 = "AbstractAuxiliaryUnit.uninstall()";
            String string4 = runtimeException.toString();
            throw new BemException(string3, "deletePrograms()", string, string4, runtimeException);
        }
    }

    public abstract String getLdn();

    public boolean isInstalled() throws BemException {
        return super.isExisting(this.getLdn());
    }

    private void reconfigureProgramPrepare() throws BemException {
        String string = this.getLdn();
        BemMo bemMo = this.getMo(string);
        BemMo bemMo2 = bemMo.getParent();
        NalNameValue[] nalNameValueArray = new NalNameValue[]{};
        this.action(bemMo2, "reconfigureProgramPrepare", nalNameValueArray);
    }

    public void setAtfRole(String string) {
        this.atfRole = string;
    }

    public void setHubPosition(int n) {
        this.hubPosition = n;
    }

    public int getHubPosition() {
        return this.hubPosition;
    }

    private BemMo getPiuType(String string) throws BemException {
        BemMo bemMo = null;
        if (string != null) {
            String string2 = this.findPiuType();
            if (string2 != null) {
                bemMo = this.getMo(string2);
            } else {
                throw new BemException(this.getClass().toString(), "getPiuType()", null, "\tNeeded Plugin Unit Type not found! PiuTypeProductName = " + string + "\n\tMake Sure that a Plugin Unit Type with PiuTypeName = " + string + " is installed on the RBS", null);
            }
        }
        return bemMo;
    }

    private BemMo getPiuTypeFromProductNameAndNumber() throws BemException {
        BemMo bemMo = null;
        if (this.piuTypeProductName != null && this.piuTypeProductNumber != null) {
            String string = this.findPiuType();
            if (string != null) {
                bemMo = this.getMo(string);
            } else {
                throw new BemException(this.getClass().toString(), "getPiuType()", null, "\tNeeded PiuType not found! PiuTypeProductName = " + this.piuTypeProductName + " PiuTypeProductNumber = " + this.piuTypeProductNumber + "\n\tMake sure that a Plugin Unit Type with PiuTypeName = " + this.piuTypeProductName + " and PiuTypeNumber = " + this.piuTypeProductNumber + " is installed on the RBS", null);
            }
        }
        return bemMo;
    }

    private String findPiuType() throws BemException {
        String string = null;
        try {
            HashMap hashMap = this.rbs.getAllPiuTypes();
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string2 = (String)entry.getKey();
                NalStruct nalStruct = (NalStruct)entry.getValue();
                String string3 = (String)nalStruct.getMemberValue("productName");
                if (this.piuTypeProductNumber != null) {
                    String string4 = (String)nalStruct.getMemberValue("productNumber");
                    if (!string3.equals(this.piuTypeProductName) || !string4.equals(this.piuTypeProductNumber)) continue;
                    string = string2;
                } else {
                    if (!string3.equals(this.piuTypeProductName)) continue;
                    string = string2;
                }
                break;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new BemException(this.getClass().getName(), "findPiuType()", null, "\tCould not find field: productName", noSuchFieldException);
        }
        return string;
    }

    public int getAuType() {
        return this.auType;
    }

    public void setCabinetNumber(String string) throws BemException {
        this.cabinetNumber = string;
    }

    public void setPosPrefix(String string) {
        if (!RbsUtil.isApcLightSupported(this.rbs)) {
            return;
        }
        this.posPrefix = string;
    }

    public String getPosPrefix() {
        return this.posPrefix;
    }

    protected BemMo getAuxPiuMo() throws BemException {
        throw new BemException("getAuxPiuMo not implemented for AbstractAuxillaryUnitRI");
    }

    public void loadPositionInfo() throws BemException {
        BemMo bemMo = this.getMo(this.getLdn());
        if (RbsUtil.isApcLightSupported(this.rbs) && this.isExisting(bemMo) && !this.posPrefix.equals("")) {
            BemMo bemMo2 = this.getAuxPiuMo();
            String string = this.posPrefix + "positionInformation";
            CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string);
            String string2 = (String)bemMo2.getAttribute("positionInformation");
            customerParameterServer.setLoadedValue(string2);
            string = this.posPrefix + "hwGroupId";
            customerParameterServer = this.rbs.getCustomerParameterServerObject(string);
            BemMo bemMo3 = (BemMo)bemMo2.getAttribute("positionRef");
            if (null != bemMo3 && MimHwGroup.MOTYPENAME.equals(bemMo3.getType())) {
                customerParameterServer.setLoadedValue(bemMo3.getId());
            }
        }
    }

    private boolean canPositionRefModified(BemMo bemMo) {
        return null == bemMo || null == bemMo.getDN() || bemMo.getDN().equals("") || MimHwGroup.MOTYPENAME.equals(bemMo.getType());
    }

    private void setPositionInfo() throws BemException {
        BemMo bemMo = this.getMo(this.getLdn());
        if (RbsUtil.isApcLightSupported(this.rbs) && this.isExisting(bemMo) && !this.posPrefix.equals("")) {
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            BemMo bemMo2 = this.getAuxPiuMo();
            String string = this.posPrefix + "positionInformation";
            CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string);
            if (customerParameterServer.hasValueChanged()) {
                vector.add(Nal.getFactory().getNameValue("positionInformation", customerParameterServer.getValueMom()));
            }
            if ((customerParameterServer = this.rbs.getCustomerParameterServerObject(string = this.posPrefix + "hwGroupId")).hasValueChanged()) {
                String string2 = (String)customerParameterServer.getValueMom();
                MoInstance moInstance = null;
                moInstance = string2.equals("") ? new LdnMoi(null) : new FixedRdnMoi(this.rbs.getEquipmentMoi(), MimHwGroup.MOTYPENAME, string2);
                BemMo bemMo3 = this.getMo(moInstance.getLdn());
                BemMo bemMo4 = (BemMo)bemMo2.getAttribute("positionRef");
                if (this.canPositionRefModified(bemMo4)) {
                    vector.add(Nal.getFactory().getNameValue("positionRef", bemMo3));
                }
            }
            if (vector.size() > 0) {
                this.setAttributes(bemMo2, vector);
            }
        }
    }

    public void setIsSharedWithExternalMe() throws BemException {
    }

    public Boolean getIsSharedWithExternalMeConfiguredValue() throws BemException {
        return MimAuxPlugInUnit.DEFAULT_ISSHAREDWITHEXTERNALME;
    }
}

