/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.mohandler;

import java.util.Observable;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.log.BemLogAndScriptUtil;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalFactory;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalTransaction;
import se.ericsson.wcdma.rbs.bem.common.util.RegressionTestInDesigntestUtils;

public class TransactionHelper
extends Observable {
    private static TransactionHelper singletonInstance = null;
    private boolean performUndo = false;
    private String currentTransactionPhaseName = null;
    private NalTransaction currentTid = null;
    private boolean isTransactionActive = false;
    private MoHandler theMoHandler = null;
    private static final int DELAY_BETWEEN_LOCK_AND_DELETE = 15;
    private static final int DEFAULT_TIMEOUT = 6000000;
    private final String[] startTransactionPhases = new String[]{"StartLockUnInitTransactionPhase", "StartMainTransactionPhase", "StartUnLockRestartTransactionPhase"};
    private final String[] endTransactionPhases = new String[]{"EndLockUnInitTransactionPhase", "EndMainTransactionPhase", "EndUnLockRestartTransactionPhase"};
    private BemLogAndScriptUtil bemLogAndScriptUtil = null;

    public TransactionHelper(MoHandler moHandler) {
        this.theMoHandler = moHandler;
        this.bemLogAndScriptUtil = BemLogAndScriptUtil.getInstance();
    }

    public static TransactionHelper getInstance(MoHandler moHandler) {
        if (singletonInstance == null) {
            singletonInstance = new TransactionHelper(moHandler);
        }
        return singletonInstance;
    }

    public void init() {
        this.currentTransactionPhaseName = null;
        this.isTransactionActive = false;
        this.performUndo = false;
        this.currentTid = null;
    }

    public boolean setPhase(String string) throws MoHandlerException {
        String string2;
        int n;
        boolean bl = false;
        for (n = 0; n < this.startTransactionPhases.length; ++n) {
            string2 = this.startTransactionPhases[n];
            if (!string2.equals(string)) continue;
            bl = true;
            this.currentTransactionPhaseName = string;
            break;
        }
        if (!bl) {
            for (n = 0; n < this.endTransactionPhases.length; ++n) {
                string2 = this.endTransactionPhases[n];
                if (!string2.equals(string)) continue;
                bl = true;
                this.currentTransactionPhaseName = string;
                this.handleCommitTransaction(string);
                break;
            }
        }
        return bl;
    }

    public NalTransaction handleStartTransaction(String string) throws MoHandlerException {
        if (!this.isTransactionActive && (string.equals("action") || string.equals("create") || string.equals("delete") || string.equals("set attributes"))) {
            if (this.currentTransactionPhaseName != null) {
                if (this.currentTransactionPhaseName.equals("StartLockUnInitTransactionPhase")) {
                    this.currentTid = this.createNewTransaction();
                    this.theMoHandler.setUseUndoList(true);
                    this.isTransactionActive = true;
                    this.bemLogAndScriptUtil.logStartConfigurationStep("StartLockUnInitTransactionPhase");
                } else if (this.currentTransactionPhaseName.equals("StartMainTransactionPhase") || this.currentTransactionPhaseName.equals("StartUnLockRestartTransactionPhase")) {
                    this.currentTid = this.createNewTransaction();
                    this.theMoHandler.setUseUndoList(false);
                    this.isTransactionActive = true;
                    this.bemLogAndScriptUtil.logStartConfigurationStep("StartMainTransactionPhase");
                }
            } else {
                Exception exception = new Exception();
                throw new MoHandlerException("Transaction required", "", exception, "Performing " + string + " without transaction" + "\nProbably depending on that the operation was not performed" + " by CI in correct install/uninstall phase");
            }
        }
        return this.currentTid;
    }

    private void handleCommitTransaction(String string) throws MoHandlerException {
        if (this.isTransactionActive) {
            if (string.equals("EndLockUnInitTransactionPhase")) {
                this.commitTransaction();
                this.performUndo = true;
                this.isTransactionActive = false;
                this.bemLogAndScriptUtil.logEndConfigurationStep();
                this.delay(15, "Waiting for boards to get locked");
            } else if (string.equals("EndMainTransactionPhase") || string.equals("EndUnLockRestartTransactionPhase")) {
                this.commitTransaction();
                this.isTransactionActive = false;
                this.performUndo = false;
                this.bemLogAndScriptUtil.logEndConfigurationStep();
            }
        }
    }

    private void delay(int n, String string) {
        NalFactory nalFactory = Nal.getFactory();
        if (!RegressionTestInDesigntestUtils.getRegressionTest()) {
            for (int i = 0; i < n; ++i) {
                try {
                    long l = 1000L;
                    this.reportProgress(string);
                    nalFactory.sleep(l);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void reportProgress(String string) {
        this.setChanged();
        this.notifyObservers(string);
    }

    public boolean rollbackAlloperations(Exception exception) throws Exception {
        if (this.isTransactionActive) {
            String string = "";
            try {
                this.currentTid.rollback("", exception);
                this.rollbackTransaction();
                if (this.performUndo) {
                    this.theMoHandler.undoOperationsInSeparateTransaction(exception);
                }
            }
            catch (MoHandlerException moHandlerException) {
                string = "Rollback failed";
                BemLog.log(4, string + moHandlerException.toString());
                throw new MoHandlerException("ROLLBACK_TRANSACTION", "", moHandlerException, string + "\nOriginal Exception: " + exception.toString());
            }
            string = "Rollback sucessfull.";
            BemLog.exceptionRaised(string, exception);
            throw exception;
        }
        return true;
    }

    private NalTransaction createNewTransaction() throws MoHandlerException {
        NalTransaction nalTransaction = null;
        try {
            nalTransaction = Nal.getFactory().createTransaction(6000000);
        }
        catch (NalCmException nalCmException) {
            throw new MoHandlerException("createNewTransaction", nalCmException);
        }
        return nalTransaction;
    }

    private void rollbackTransaction() throws MoHandlerException {
        if (this.currentTid != null) {
            try {
                this.currentTid.rollback(null, null);
                this.currentTid = null;
            }
            catch (NalCmException nalCmException) {
                this.currentTid = null;
                throw new MoHandlerException("Action and rollback failed.", nalCmException);
            }
        }
    }

    public void commitTransaction() throws MoHandlerException {
        if (this.currentTid != null) {
            try {
                this.currentTid.commit();
                this.currentTid = null;
            }
            catch (NalCmException nalCmException) {
                throw new MoHandlerException("COMMIT_TRANSACTION", nalCmException);
            }
        }
    }
}

