/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.nal.impl.backend;

import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalMo;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalTransaction;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.backend.NalBackend;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.backend.NalTransactionDefault;

public abstract class NalMoBackend
extends NalBackend
implements NalMo {
    public static final String ROOT_MO_LDN = "ManagedElement=1";
    private final String ldn;

    protected NalMoBackend(String string) {
        this.ldn = string;
        if (string == null) {
            return;
        }
        if ("".equals(string)) {
            return;
        }
        if (!string.startsWith(ROOT_MO_LDN)) {
            NalCmException nalCmException = new NalCmException("Attempted to create NalMo with invalid ldn='" + string + "'!");
            Nal.getLog().nalTraceError(this.getClass(), "Attempted to create NalMo with invalid ldn='" + string + "'!", nalCmException);
        }
    }

    public String getLdn() {
        return this.ldn;
    }

    public NalMo getParent() {
        String string = NalMoBackend.getParent(this.ldn);
        return Nal.getFactory().getMo(string);
    }

    public String getType() {
        return NalMoBackend.getType(this.ldn);
    }

    public String getId() {
        return NalMoBackend.getId(this.ldn);
    }

    public void create(NalTransaction nalTransaction) {
        this.create(new NalNameValue[0], nalTransaction);
    }

    public void delete(NalTransaction nalTransaction) {
        this.delete("", "", 0, nalTransaction);
    }

    public NalMo[] getChildren(NalTransaction nalTransaction) {
        return this.getChildren("", "", 1, nalTransaction);
    }

    public void setAttribute(NalNameValue nalNameValue, NalTransaction nalTransaction) {
        this.setAttribute(nalNameValue.getName(), nalNameValue.getValue(), nalTransaction);
    }

    public static String getType(String string) {
        int n;
        if (string == null || "null".equals(string)) {
            return null;
        }
        int n2 = string.lastIndexOf(44);
        if (n2 < (n = string.lastIndexOf(61))) {
            String string2 = string.substring(n2 + 1, n);
            string2 = string2.trim();
            return string2;
        }
        return null;
    }

    public static String getId(String string) {
        if (string == null || "null".equals(string)) {
            return null;
        }
        String string2 = null;
        try {
            int n = string.lastIndexOf("=");
            int n2 = n + 1;
            string2 = string.substring(n2);
        }
        catch (Exception exception) {
            string2 = null;
        }
        return string2;
    }

    public static String getParent(String string) {
        if (string == null || "null".equals(string)) {
            return null;
        }
        int n = string.lastIndexOf(",");
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        return string2;
    }

    protected String getLdn(Object object) {
        String string = null;
        string = object instanceof NalMo ? ((NalMo)object).getLdn() : (object instanceof String ? (String)object : ((NalMo)object).getLdn());
        if (string == null) {
            string = "null";
        }
        return string;
    }

    public static NalTransaction getReadTransactionDefault(NalTransaction nalTransaction) {
        NalTransactionDefault nalTransactionDefault = new NalTransactionDefault(false, nalTransaction);
        return nalTransactionDefault;
    }

    public static NalTransaction getWriteTransactionDefault(NalTransaction nalTransaction) {
        NalTransactionDefault nalTransactionDefault = new NalTransactionDefault(true, nalTransaction);
        return nalTransactionDefault;
    }

    public static NalTransaction getWriteTransactionDefault(int n, NalTransaction nalTransaction) {
        NalTransactionDefault nalTransactionDefault = new NalTransactionDefault(true, n, nalTransaction);
        return nalTransactionDefault;
    }

    public boolean equals(Object object) {
        String string = this.getLdn(this);
        String string2 = this.getLdn(object);
        boolean bl = string.equals(string2);
        return bl;
    }

    public int hashCode() {
        String string = this.getLdn(this);
        return string.hashCode();
    }

    public int compareTo(Object object) {
        String string = this.getLdn(this);
        String string2 = this.getLdn(object);
        int n = string.compareTo(string2);
        return n;
    }

    public String toString() {
        String string = this.getLdn(this);
        return string;
    }
}

