/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.nal.impl.neal;

import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.cm.CmNotificationConsumer;
import se.ericsson.cello.neal.cm.CmSubscription;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.NotificationType;
import se.ericsson.cello.neal.cm.Scope;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmNotificationConsumer;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmSubscription;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalMo;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.backend.NalBackend;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.backend.NalCmSubscriptionBackend;

public class NalCmSubscriptionNeal
extends NalCmSubscriptionBackend
implements NalCmSubscription,
CmNotificationConsumer {
    private static final Class THIS_CLASS = NalCmSubscriptionNeal.class;
    private final CmSubscription nealSubscription;

    NalCmSubscriptionNeal(NalMo nalMo, int n, String[] stringArray, NalCmNotificationConsumer nalCmNotificationConsumer) {
        super(nalCmNotificationConsumer, nalMo.getLdn());
        CmSubscription cmSubscription;
        Mo mo = (Mo)nalMo.getNative();
        Scope scope = NalCmSubscriptionNeal.int2scope(n);
        this.nealSubscription = cmSubscription = mo.subscribe(scope, stringArray, NotificationType.AVC_AND_TOPOLOGY, (CmNotificationConsumer)this);
    }

    public synchronized boolean isAlive() {
        boolean bl = super.isAlive();
        if (!bl) {
            return false;
        }
        boolean bl2 = this.nealSubscription.isAlive();
        return bl && bl2;
    }

    public synchronized void cancel() {
        super.cancel();
        this.nealSubscription.cancel();
    }

    public Object getNative() {
        return this.nealSubscription;
    }

    public void moCreated(String string, int n) {
        this.moCreated(string);
    }

    public void moDeleted(String string, int n) {
        this.moDeleted(string);
    }

    public void attributeValueChanged(String string, NameValue[] nameValueArray, int n) {
        if (this.isAlive()) {
            NalNameValue[] nalNameValueArray = NalBackend.wrapNativeNameValueArray(nameValueArray);
            this.attributeValueChanged(string, nalNameValueArray);
        }
    }

    public void overflowOccurred(String string) {
        Nal.getLog().nalTraceError(THIS_CLASS, "Neal reports owerflow : " + string);
    }

    public void subscriptionNotActive(CmSubscription cmSubscription, Node node) {
        if (this.isAlive()) {
            Nal.getLog().nalTrace(2, THIS_CLASS, "Alive Subscription canceled from server side! " + this.toString());
        } else {
            Nal.getLog().nalTrace(6, THIS_CLASS, "Cancelled Subscription canceled from server side. " + this.toString());
        }
    }

    public void communicationFailed(CmSubscription cmSubscription, Node node, String string) {
        Nal.getLog().nalTraceError(THIS_CLASS, "Neal reports communication failure : " + string);
    }

    private static Scope int2scope(int n) {
        switch (n) {
            case 0: {
                return Scope.BASE_ONLY;
            }
            case 1: {
                return Scope.ONE_LEVEL;
            }
            case 2: {
                return Scope.TWO_LEVELS;
            }
            case 3: {
                return Scope.THREE_LEVELS;
            }
            case 4: {
                return Scope.FOUR_LEVELS;
            }
            case 5: {
                return Scope.FIVE_LEVELS;
            }
        }
        return Scope.ALL_LEVELS;
    }
}

