/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.nal.impl.neal;

import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Scope;
import se.ericsson.cello.neal.cm.Transaction;
import se.ericsson.cello.neal.cm.Value;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmNotificationConsumer;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmSubscription;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalMo;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalTransaction;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.backend.NalMoBackend;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.neal.NalBackendNeal;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.neal.NalCmSubscriptionNeal;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.neal.NalFactoryNeal;

public class NalMoNeal
extends NalMoBackend
implements NalMo,
Comparable {
    private final NalFactoryNeal factory;
    private Mo delegate = null;
    private int myConnectionIndex = NalBackendNeal.getConnectionIndex();

    NalMoNeal(NalFactoryNeal nalFactoryNeal, Mo mo) {
        super(mo.getLdn());
        this.factory = nalFactoryNeal;
        this.delegate = mo;
    }

    NalMoNeal(NalFactoryNeal nalFactoryNeal, String string) {
        super(string);
        this.factory = nalFactoryNeal;
    }

    private Mo getDelegate() {
        int n = NalBackendNeal.getConnectionIndex();
        if (this.myConnectionIndex != n) {
            this.delegate = null;
        }
        if (this.delegate == null) {
            String string = this.getLdn() == null ? "" : this.getLdn();
            this.delegate = this.factory.getCmService().getMo(string);
        }
        return this.delegate;
    }

    public Object getNative() {
        return this.getDelegate();
    }

    public Object action(String string, NalNameValue[] nalNameValueArray, NalTransaction nalTransaction) {
        NameValue[] nameValueArray = NalBackendNeal.toNeal(nalNameValueArray);
        Transaction transaction = NalBackendNeal.toNeal(nalTransaction);
        Value value = this.getDelegate().action(string, nameValueArray, transaction);
        Object object = value == null ? null : NalMoNeal.wrapNativeObject(value.getValue());
        return object;
    }

    public void create(NalTransaction nalTransaction) {
        this.create(new NalNameValue[0], nalTransaction);
    }

    public void create(NalNameValue[] nalNameValueArray, NalTransaction nalTransaction) {
        String string = this.getLdn();
        if (string == null) {
            NullPointerException nullPointerException = new NullPointerException("PROGRAMMING ERROR! Failed to create NalMo with ldn=null!");
            nullPointerException.printStackTrace();
            throw nullPointerException;
        }
        if (!string.startsWith("ManagedElement=1")) {
            NalCmException nalCmException = new NalCmException("PROGRAMMING ERROR! Faied to create NalMo with invalid ldn=" + string + "!");
            nalCmException.printStackTrace();
            throw nalCmException;
        }
        if (!this.getDelegate().exists()) {
            NalMo nalMo = this.getParent();
            nalMo.create(nalTransaction);
            NalMo nalMo2 = nalMo.createChild(this.getId(), this.getType(), nalNameValueArray, nalTransaction);
            if (!this.equals(nalMo2)) {
                throw new NalCmException("PROGRAMMING ERROR! Got " + nalMo2 + " when trying to create " + this + "!");
            }
        }
    }

    public NalMo createChild(String string, String string2, NalNameValue[] nalNameValueArray, NalTransaction nalTransaction) {
        Transaction transaction = NalBackendNeal.toNeal(nalTransaction);
        NameValue[] nameValueArray = NalBackendNeal.toNeal(nalNameValueArray);
        Mo mo = this.getDelegate().createChild(string, string2, nameValueArray, transaction);
        NalMo nalMo = NalMoNeal.wrapNativeMo(mo);
        return nalMo;
    }

    public void delete(NalTransaction nalTransaction) {
        Transaction transaction = NalBackendNeal.toNeal(nalTransaction);
        this.getDelegate().delete(transaction);
    }

    public void delete(String string, String string2, int n, NalTransaction nalTransaction) {
        Transaction transaction = NalBackendNeal.toNeal(nalTransaction);
        Scope scope = NalBackendNeal.toNeal(n);
        this.getDelegate().delete(string, string2, scope, transaction);
    }

    public boolean exists() {
        return this.exists(null);
    }

    public boolean exists(NalTransaction nalTransaction) {
        if (this.getLdn() == null) {
            return false;
        }
        boolean bl = this.getDelegate().exists();
        return bl;
    }

    public NalNameValue getAttribute(String string, NalTransaction nalTransaction) {
        Transaction transaction = NalBackendNeal.toNeal(nalTransaction);
        NameValue nameValue = this.getDelegate().getAttribute(string, transaction);
        NalNameValue nalNameValue = NalMoNeal.wrapNativeNameValue(nameValue);
        return nalNameValue;
    }

    public NalNameValue[] getAttributes(String[] stringArray, NalTransaction nalTransaction) {
        Transaction transaction = NalBackendNeal.toNeal(nalTransaction);
        Object[] objectArray = this.getDelegate().getAttributes(stringArray, transaction);
        NalNameValue[] nalNameValueArray = NalMoNeal.wrapNativeNameValueArray(objectArray);
        return nalNameValueArray;
    }

    public NalMo[] getChildren(String string, String string2, int n, NalTransaction nalTransaction) {
        Transaction transaction = NalBackendNeal.toNeal(nalTransaction);
        Scope scope = NalBackendNeal.toNeal(n);
        Object[] objectArray = this.getDelegate().getChildren(string, string2, scope, transaction);
        NalMo[] nalMoArray = NalMoNeal.wrapNativeMoArray(objectArray);
        return nalMoArray;
    }

    public NalMo[] getChildren(NalTransaction nalTransaction) {
        Transaction transaction = NalBackendNeal.toNeal(nalTransaction);
        Object[] objectArray = this.getDelegate().getChildren(transaction);
        NalMo[] nalMoArray = NalMoNeal.wrapNativeMoArray(objectArray);
        return nalMoArray;
    }

    public void setAttribute(String string, Object object, NalTransaction nalTransaction) {
        Transaction transaction = NalBackendNeal.toNeal(nalTransaction);
        NameValue nameValue = NalBackendNeal.getNealNameValue(string, object);
        this.getDelegate().setAttribute(nameValue, transaction);
    }

    public void setAttribute(NalNameValue nalNameValue, NalTransaction nalTransaction) {
        Transaction transaction = NalBackendNeal.toNeal(nalTransaction);
        NameValue nameValue = NalBackendNeal.toNeal(nalNameValue);
        this.getDelegate().setAttribute(nameValue, transaction);
    }

    public void setAttributes(NalNameValue[] nalNameValueArray, NalTransaction nalTransaction) {
        Transaction transaction = NalBackendNeal.toNeal(nalTransaction);
        NameValue[] nameValueArray = NalBackendNeal.toNeal(nalNameValueArray);
        this.getDelegate().setAttributes(nameValueArray, transaction);
    }

    public NalCmSubscription subscribe(NalCmNotificationConsumer nalCmNotificationConsumer) {
        return this.subscribe(0, new String[0], nalCmNotificationConsumer);
    }

    public NalCmSubscription subscribe(int n, NalCmNotificationConsumer nalCmNotificationConsumer) {
        String[] stringArray = new String[]{};
        NalCmSubscription nalCmSubscription = new NalCmSubscriptionNeal(this, n, stringArray, nalCmNotificationConsumer);
        nalCmSubscription = NalMoNeal.wrapNativeCmSubscription(nalCmSubscription);
        return nalCmSubscription;
    }

    public NalCmSubscription subscribe(int n, String[] stringArray, NalCmNotificationConsumer nalCmNotificationConsumer) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        NalCmSubscription nalCmSubscription = new NalCmSubscriptionNeal(this, n, stringArray, nalCmNotificationConsumer);
        nalCmSubscription = NalMoNeal.wrapNativeCmSubscription(nalCmSubscription);
        return nalCmSubscription;
    }
}

