/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.service;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.service.GuiLogicer;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;

public abstract class Service {
    private static boolean initGuiLogicFlag = true;
    protected Object[] guiLogics = null;
    protected Class[] guiLogicClasses = null;
    protected String serviceName = null;

    public boolean configureService(ServiceValue serviceValue) throws BemException {
        Vector vector = serviceValue.getValues(this.serviceName);
        if (vector == null) {
            return true;
        }
        int n = this.guiLogics.length;
        for (int i = 0; i < n; ++i) {
            GuiLogicer guiLogicer = (GuiLogicer)this.guiLogics[i];
            String string = null;
            try {
                string = this.guiLogics[i].toString();
                string = this.extractName(string);
                boolean bl = guiLogicer.importFromService(serviceValue, this.serviceName);
                if (!bl) {
                    throw new BemException("Error in service " + this.serviceName + ", checkSyntax()");
                }
            }
            catch (BemException bemException) {
                throw bemException;
            }
            catch (Exception exception) {
                throw new BemException(null, null, null, "Service.configureService()\nLogic=" + string + "\nException in Logic.checkSyntax()=" + exception.toString(), exception);
            }
            try {
                String string2 = serviceValue.getOriginator();
                boolean bl = guiLogicer.updateModel(string2);
                if (bl) continue;
                throw new BemException("Error in service " + this.serviceName + ", updateModel()");
            }
            catch (BemException bemException) {
                throw bemException;
            }
            catch (Exception exception) {
                throw new BemException(null, null, null, "Service.configureService()\nLogic=" + string + "\nException in Logic.updateModel()=" + exception.toString(), exception);
            }
        }
        return true;
    }

    protected Object[] initGuiLogic(Class[] classArray) throws BemException {
        String string;
        this.guiLogicClasses = classArray;
        String string2 = string = "Service.initGuiLogic()";
        String string3 = null;
        if (initGuiLogicFlag) {
            int n = classArray.length;
            string2 = string + " number of Logics=" + n;
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                try {
                    string3 = classArray[i].toString();
                    string3 = this.extractName(string3);
                    string2 = string + " number of Logics=" + n + "\n" + "currentLogic=" + string3 + " before retrieving constructor";
                    Constructor constructor = classArray[i].getConstructor(null);
                    string2 = string + " number of Logics=" + n + "\n" + "currentLogic=" + string3 + " before calling constructor";
                    objectArray[i] = constructor.newInstance(null);
                    continue;
                }
                catch (InvocationTargetException invocationTargetException) {
                    String string4 = "\nTargetException=" + invocationTargetException.getTargetException().toString();
                    throw new BemException(this.serviceName + " Service", "Create GUI logic classes", null, string2 + string4, invocationTargetException);
                }
                catch (Exception exception) {
                    throw new BemException(this.serviceName + " Service", "Create GUI logic classes", null, string2, exception);
                }
            }
            return objectArray;
        }
        return new Object[0];
    }

    public Class[] getGuiLogicClasses() {
        return this.guiLogicClasses;
    }

    private String extractName(String string) {
        String string2 = string;
        if (string != null) {
            int n;
            int n2 = string.lastIndexOf(".");
            if (n2 != -1) {
                string2 = string.substring(n2 + 1);
            }
            if ((n = string2.lastIndexOf("@")) != -1) {
                string2 = string2.substring(0, n);
            }
        }
        return string2;
    }

    public static void setInitGuiLogicFlag(boolean bl) {
        initGuiLogicFlag = bl;
    }
}

