/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.client.clients.cli.main;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.client.clients.cli.html.HtmlParser;
import se.ericsson.wcdma.rbs.bem.client.clients.cli.html.JarInfo;

public class CacheSetup {
    private static String host = null;
    private static String hostDocumentBase = null;

    public CacheSetup(String string) {
        host = string;
        String string2 = "/em/";
        hostDocumentBase = host + string2;
    }

    public String getDocumentBase() {
        return hostDocumentBase;
    }

    public String setup(ArrayList arrayList) {
        String string = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = "index_stubbed.html";
            string = this.copyFileFromRbs(hostDocumentBase, string2, stringBuffer);
            HtmlParser htmlParser = new HtmlParser(stringBuffer.toString());
            String string3 = htmlParser.getApplRevision();
            if (string3 == null) {
                throw new Exception("CacheSetup.setup() Not possible to read revision from file=" + string2);
            }
            String string4 = CacheSetup.getUserHome() + this.getCacheBaseDir() + string3 + File.separator;
            File file = new File(string4);
            if (!file.exists() && !file.mkdirs()) {
                string = "Can not create directory: " + string4;
            }
            if (string == null) {
                string = this.fetchJarFiles(htmlParser, host, string4, arrayList);
            }
        }
        catch (Exception exception) {
            string = "===Exception exc=" + exception.toString();
        }
        return string;
    }

    private String copyFileFromRbs(String string, String string2, StringBuffer stringBuffer) {
        String string3 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
            string3 = this.copyFileFromRbs(string, string2, outputStreamWriter);
            if (string3 == null) {
                stringBuffer.append(byteArrayOutputStream.toString());
            }
            ((Writer)outputStreamWriter).close();
        }
        catch (Exception exception) {
            string3 = "CopyFileFromRbs() " + exception.toString();
        }
        return string3;
    }

    private String copyFileFromRbs(String string, String string2, Writer writer) {
        String string3 = null;
        String string4 = null;
        try {
            String string5 = "HTTP://";
            string4 = string5 + string + string2;
            URL uRL = new URL(string4);
            InputStream inputStream = uRL.openStream();
            int n = 0;
            n = inputStream.read();
            while (n != -1) {
                writer.write(n);
                n = inputStream.read();
            }
            writer.close();
        }
        catch (Exception exception) {
            string3 = "Reading file=" + string4 + "  Exception=" + exception.toString();
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String copyBinaryFileFromRbs(String string, String string2, String string3) {
        String string4 = null;
        String string5 = null;
        FilterInputStream filterInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            String string6 = "HTTP://";
            string5 = string6 + string + string2;
            URL uRL = new URL(string5);
            InputStream inputStream = uRL.openStream();
            filterInputStream = new DataInputStream(inputStream);
            FileOutputStream fileOutputStream = new FileOutputStream(string3 + string2);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            filterOutputStream = new DataOutputStream(bufferedOutputStream);
            byte[] byArray = new byte[4096];
            int n = ((DataInputStream)filterInputStream).read(byArray);
            while (n != -1) {
                ((DataOutputStream)filterOutputStream).write(byArray, 0, n);
                n = ((DataInputStream)filterInputStream).read(byArray);
            }
        }
        catch (Exception exception) {
            string4 = "Reading file=" + string5 + "  Exception=" + exception.toString();
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string4;
    }

    private String copyFilesFromRbs(String string, String[] stringArray, String string2) {
        String string3;
        File file;
        String string4 = null;
        for (int i = 0; i < stringArray.length && ((file = new File(string3 = string2 + stringArray[i])).exists() || (string4 = this.copyBinaryFileFromRbs(string, stringArray[i], string2)) == null); ++i) {
        }
        return string4;
    }

    private String fetchJarFiles(HtmlParser htmlParser, String string, String string2, ArrayList arrayList) throws Exception {
        List list = htmlParser.getJarInfo();
        int n = list.size();
        String string3 = null;
        for (int i = 0; i < n; ++i) {
            JarInfo jarInfo = (JarInfo)list.get(i);
            String string4 = string + jarInfo.getRelativePath();
            string3 = this.copyFilesFromRbs(string4, jarInfo.getJarFiles(), string2);
            String[] stringArray = jarInfo.getJarFiles();
            for (int j = 0; j < stringArray.length; ++j) {
                String string5 = string2 + stringArray[j];
                arrayList.add(string5);
            }
        }
        return string3;
    }

    private String getCacheBaseDir() {
        return File.separator + "Ericsson" + File.separator + "cello" + File.separator + "emas" + File.separator;
    }

    private static String getUserHome() {
        return System.getProperty("user.home");
    }
}

