/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.cns.proxy;

import enea.ose.system.AttachSignal;
import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import java.net.URL;
import se.ericsson.cello.cns.TransferClientException;
import se.ericsson.cello.cns.VendorCredentialsException;
import se.ericsson.cello.cns.proxy.CppCnsjiGetFileCfm;
import se.ericsson.cello.cns.proxy.CppCnsjiGetFileReq;
import se.ericsson.cello.cns.proxy.CppCnsjiInitiateServiceCfm;
import se.ericsson.cello.cns.proxy.CppCnsjiInitiateServiceReq;
import se.ericsson.cello.cns.proxy.CppCnsjiNotifySubscribeCfm;
import se.ericsson.cello.cns.proxy.CppCnsjiNotifySubscribeReq;
import se.ericsson.cello.cns.proxy.CppCnsjiTerminateServiceCfm;
import se.ericsson.cello.cns.proxy.CppCnsjiTerminateServiceReq;
import se.ericsson.cello.cns.proxy.CppCnsjiVCstatusCfm;
import se.ericsson.cello.cns.proxy.CppCnsjiVCstatusReq;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.sigutil.OseNameServer;
import se.ericsson.cello.support.sigutil.PortManager;
import se.ericsson.cello.support.sigutil.SignalHelper;
import se.ericsson.cello.support.sigutil.SignalObserver;
import se.ericsson.cello.support.sigutil.SignalPort;
import se.ericsson.cello.support.sigutil.SubscriptionObserver;

public class CNSProxy
implements SubscriptionObserver,
SignalObserver {
    private static CNSProxy instance;
    private int protocolVersion = 0;
    private SignalPort signalPort = PortManager.instance();
    private static OseProcess op;
    private static final int MAX_NO_OF_RETRIES = 5;
    private static final String SERVICE_NAME = "CELLO_CNSI_SERVICE_NAME";
    private static final int PV_FIRST = 1;
    private static final int PV_SECOND = 1;
    private static final int PV_THIRD = 1;
    private static final int CPP_CNSJI_OK = 0;
    private static final int CPP_CNSJI_INVALID_PV = 101;
    private static final int CPP_CNSJI_MAX_NO_OF_CLIENTS_REACHED = 102;
    private static final int CPP_CNSJI_SERVICE_NOT_INITIATED = 103;
    private static final int CPP_CNSJI_SERVICE_ALREADY_INITIATED = 104;
    private static final int CPP_CNSJI_NO_MEMORY = 105;
    private static final int CPP_CNSJI_INTERNAL_ERR = 106;
    private static final int TRACEGROUP = 6;
    private static final int RECEIVE_TIMEOUT = 60000;
    private static final int HTTPS_RECEIVE_TIMEOUT = 300000;
    private static final String HTTPS_TIMEOUT_PROPERTY = "se.ericsson.cello.cns.https_timeout";

    public void serviceAdded(String string) {
        MessageLog.info(this.getClass(), (String)"serviceAdded = CELLO_CNSI_SERVICE_NAME");
        if (op != null && this.protocolVersion != 0) {
            MessageLog.trace((int)6, this.getClass(), (String)"init() CNSJI already called.");
            return;
        }
        if (this.init()) {
            MessageLog.trace((int)6, this.getClass(), (String)"init() CNSJI called successfully.");
        } else {
            MessageLog.trace((int)6, this.getClass(), (String)"init() CNSJI returned false.");
        }
    }

    public void serviceRemoved(String string) {
        block1: {
            MessageLog.info(this.getClass(), (String)"serviceRemoved: CELLO_CNSI_SERVICE_NAME");
            if (op != null) {
                if (!op.equals((Object)OseNameServer.lookup((String)SERVICE_NAME))) break block1;
            }
        }
        op = null;
        this.protocolVersion = 0;
    }

    public void signalReceived(InSignal inSignal) {
        MessageLog.trace((int)6, this.getClass(), (String)("signalReceived: " + inSignal.getClass()));
        if (inSignal.getClass().equals(CppCnsjiNotifySubscribeCfm.class)) {
            MessageLog.info(this.getClass(), (String)"Service successfully subscribed");
        } else {
            MessageLog.info(this.getClass(), (String)("Received unknown signal: " + inSignal.getClass()));
        }
    }

    public static CNSProxy instance() {
        if (instance == null) {
            instance = new CNSProxy();
        }
        return instance;
    }

    private CNSProxy() {
        this.signalPort.addSignalObserver((SignalObserver)this, CppCnsjiNotifySubscribeCfm.class);
        OseNameServer.addSubscriptionObserver((String)SERVICE_NAME, (SubscriptionObserver)this);
    }

    public synchronized boolean checkOp() {
        if (op != null && this.protocolVersion != 0) {
            return true;
        }
        boolean bl = this.init();
        MessageLog.trace((int)6, this.getClass(), (String)("Op needs to be checked, init returned " + bl));
        for (int i = 0; !bl && i < 5; ++i) {
            try {
                Thread.sleep(60000L);
                bl = this.init();
                continue;
            }
            catch (InterruptedException interruptedException) {
                MessageLog.info(this.getClass(), (String)("InterruptedException: " + interruptedException.getMessage()));
            }
        }
        return bl;
    }

    private synchronized boolean init() {
        boolean bl = true;
        OseProcess oseProcess = null;
        oseProcess = OseNameServer.lookup((String)SERVICE_NAME);
        op = oseProcess;
        MessageLog.info(this.getClass(), (String)("In init(), op = : " + op));
        if (oseProcess == null) {
            MessageLog.info(this.getClass(), (String)"init(), op == null");
            bl = false;
        } else {
            if (this.protocolVersion != 0) {
                bl = this.sendCppCnsjiTerminateServiceReq();
            }
            if (bl) {
                bl = this.sendCppCnsjiInitiateServiceReq();
            }
            if (bl) {
                this.sendCppCnsjiNotifySubscribeReq();
            }
        }
        return bl;
    }

    protected boolean sendCppCnsjiInitiateServiceReq() {
        boolean bl = true;
        int n = 0;
        CppCnsjiInitiateServiceReq cppCnsjiInitiateServiceReq = new CppCnsjiInitiateServiceReq(1, 1, 1);
        Signal signal = SignalHelper.sendAndReceiveAttachedClean((OseProcess)op, (Signal)cppCnsjiInitiateServiceReq, (Class)CppCnsjiInitiateServiceCfm.class, (int)60000);
        if (signal == null) {
            MessageLog.info(this.getClass(), (String)" sendCppCnsjiInitiateServiceReq(). No response signal, rspSig == null.");
            bl = false;
            return bl;
        }
        if (signal instanceof CppCnsjiInitiateServiceCfm) {
            MessageLog.info(this.getClass(), (String)(" sendCppCnsjiInitiateServiceReq() confirmed, pv = : " + ((CppCnsjiInitiateServiceCfm)signal).getPreferredPV()));
            this.protocolVersion = ((CppCnsjiInitiateServiceCfm)signal).getPreferredPV();
            n = ((CppCnsjiInitiateServiceCfm)signal).getResult();
            if (n != 0) {
                bl = false;
                MessageLog.info(this.getClass(), (String)(" sendCppCnsjiInitiateServiceReq() failed, received result = : " + ((CppCnsjiInitiateServiceCfm)signal).getResult() + " ,preferred PV = : " + this.protocolVersion));
            } else {
                MessageLog.info(this.getClass(), (String)("Successfully Initialized with pv " + this.protocolVersion));
            }
        } else if (signal instanceof AttachSignal) {
            bl = false;
            MessageLog.info(this.getClass(), (String)" sendCppCnsjiInitiateServiceReq(), receiver process terminated: CELLO_CNSI_SERVICE_NAME");
        } else {
            MessageLog.info(this.getClass(), (String)(" sendCppCnsjiInitiateServiceReq(), received rspSig:  " + signal.getClass()));
            bl = false;
        }
        return bl;
    }

    public boolean sendCppCnsjiTerminateServiceReq() {
        CppCnsjiTerminateServiceCfm cppCnsjiTerminateServiceCfm = null;
        CppCnsjiTerminateServiceReq cppCnsjiTerminateServiceReq = null;
        if (op == null || this.protocolVersion == 0) {
            return true;
        }
        cppCnsjiTerminateServiceReq = new CppCnsjiTerminateServiceReq();
        cppCnsjiTerminateServiceCfm = (CppCnsjiTerminateServiceCfm)SignalHelper.sendAndReceiveAttachedClean((OseProcess)op, (Signal)cppCnsjiTerminateServiceReq, (Class)CppCnsjiTerminateServiceCfm.class, (int)60000);
        if (cppCnsjiTerminateServiceCfm == null) {
            MessageLog.info(this.getClass(), (String)" sendCppCnsjiTerminateServiceReq(). No response signal, rspSig == null");
            return false;
        }
        if (cppCnsjiTerminateServiceCfm instanceof CppCnsjiTerminateServiceCfm) {
            MessageLog.trace((int)6, this.getClass(), (String)" sendCppCnsjiTerminateServiceReq(), received CppCnsjiTerminateServiceCfm");
            return true;
        }
        if (cppCnsjiTerminateServiceCfm instanceof AttachSignal) {
            MessageLog.info(this.getClass(), (String)"receiver process terminated: CELLO_CNSI_SERVICE_NAME");
        } else {
            MessageLog.info(this.getClass(), (String)(" sendCppCnsjiTerminateServiceReq(), received rspSig:  " + ((Object)((Object)cppCnsjiTerminateServiceCfm)).getClass()));
        }
        return false;
    }

    public void sendCppCnsjiNotifySubscribeReq() {
        CppCnsjiNotifySubscribeReq cppCnsjiNotifySubscribeReq = new CppCnsjiNotifySubscribeReq();
        OseProcess oseProcess = this.signalPort.getOseProcess();
        SignalHelper.sendWithSender((OseProcess)op, (OseProcess)oseProcess, (Signal)cppCnsjiNotifySubscribeReq);
    }

    public synchronized String fetchFile(URL uRL) throws TransferClientException {
        int n = 300000;
        try {
            n = Integer.parseInt(System.getProperty(HTTPS_TIMEOUT_PROPERTY, Integer.toString(300000)));
        }
        catch (NumberFormatException numberFormatException) {
            throw new TransferClientException("Illegal HTTPS timeout value: " + System.getProperty(HTTPS_TIMEOUT_PROPERTY));
        }
        return this.fetchFile(uRL, n);
    }

    private synchronized String fetchFile(URL uRL, int n) throws TransferClientException {
        CppCnsjiGetFileReq cppCnsjiGetFileReq = null;
        CppCnsjiGetFileCfm cppCnsjiGetFileCfm = null;
        MessageLog.trace((int)6, (Class)CNSProxy.class, (String)("Fetch URL " + uRL + ", timeout=" + n));
        if (uRL.getHost().length() >= 255 || uRL.getFile().length() >= 255) {
            throw new TransferClientException("Path or host name too long. Max length: 254 + null char13");
        }
        cppCnsjiGetFileReq = new CppCnsjiGetFileReq(uRL);
        if (this.checkOp()) {
            cppCnsjiGetFileCfm = (CppCnsjiGetFileCfm)SignalHelper.sendAndReceiveAttachedClean((OseProcess)op, (Signal)cppCnsjiGetFileReq, (Class)CppCnsjiGetFileCfm.class, (int)n);
        }
        if (cppCnsjiGetFileCfm == null) {
            throw new TransferClientException("CNSJI not accessible!", 16);
        }
        if (cppCnsjiGetFileCfm instanceof CppCnsjiGetFileCfm) {
            if (((CppCnsjiGetFileCfm)cppCnsjiGetFileCfm).getResult() != 0) {
                throw new TransferClientException("CNS server returned errCode: " + cppCnsjiGetFileCfm.getResult(), cppCnsjiGetFileCfm.getResult());
            }
            return cppCnsjiGetFileCfm.getFileContent();
        }
        if (cppCnsjiGetFileCfm instanceof AttachSignal) {
            throw new TransferClientException("receiver process terminated: CELLO_CNSI_SERVICE_NAME", 17);
        }
        throw new TransferClientException("Unknown response received!", 18);
    }

    public synchronized boolean isVCPresent() throws VendorCredentialsException {
        CppCnsjiVCstatusReq cppCnsjiVCstatusReq = null;
        CppCnsjiVCstatusCfm cppCnsjiVCstatusCfm = null;
        cppCnsjiVCstatusReq = new CppCnsjiVCstatusReq();
        if (this.checkOp()) {
            cppCnsjiVCstatusCfm = (CppCnsjiVCstatusCfm)SignalHelper.sendAndReceiveAttachedClean((OseProcess)op, (Signal)cppCnsjiVCstatusReq, (Class)CppCnsjiVCstatusCfm.class, (int)60000);
        }
        if (cppCnsjiVCstatusCfm == null) {
            throw new VendorCredentialsException("CNSJI not accessible!", 8);
        }
        if (cppCnsjiVCstatusCfm instanceof CppCnsjiVCstatusCfm) {
            if (!((CppCnsjiVCstatusCfm)cppCnsjiVCstatusCfm).isVCPresent()) {
                throw new VendorCredentialsException("CNS server returned errCode: " + cppCnsjiVCstatusCfm.getResult(), cppCnsjiVCstatusCfm.getResult());
            }
            return true;
        }
        if (cppCnsjiVCstatusCfm instanceof AttachSignal) {
            throw new VendorCredentialsException("receiver process terminated: CELLO_CNSI_SERVICE_NAME", 9);
        }
        throw new VendorCredentialsException("Unknown response received!", 10);
    }

    static {
        op = null;
    }
}

