/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.DomainExtension;
import se.ericsson.cello.mimparser.MomEnum;
import se.ericsson.cello.mimparser.MomEnumMember;
import se.ericsson.cello.mimparser.model.DomainExtensionImpl;
import se.ericsson.cello.mimparser.model.MimModelImpl;
import se.ericsson.cello.mimparser.model.MomBase;
import se.ericsson.cello.mimparser.model.MomEnumMemberImpl;
import se.ericsson.cello.mimparser.model.utils.DescriptionHelper;

public class MomEnumImpl
extends MomBase
implements MomEnum {
    private static final String NEW_LINE = "\n";
    private Map myEnumMembers = new HashMap();
    private static final String APPLICATION_TAG = "applicationTag: ";
    private DomainExtension domainExtension;

    public MomEnumImpl(String xmlType, Attributes attributes, MimModelImpl model, int id) {
        super(xmlType, attributes, model, id);
    }

    public void addEnumMember(String name, MomEnumMemberImpl member) {
        this.myEnumMembers.put(name, member);
    }

    public MomEnumMemberImpl getEnumMemberCaseInsensitive(String name) {
        Iterator members = this.getMembers();
        while (members.hasNext()) {
            MomEnumMember mem = (MomEnumMember)members.next();
            String memberName = mem.getName();
            if (!memberName.equalsIgnoreCase(name)) continue;
            name = memberName;
            break;
        }
        return (MomEnumMemberImpl)this.myEnumMembers.get(name);
    }

    public Iterator getMembers() {
        Collection c = this.myEnumMembers.values();
        EnumComparator comparator = new EnumComparator();
        ArrayList list = new ArrayList(c);
        Collections.sort(list, comparator);
        return list.iterator();
    }

    public DomainExtension getDomain() {
        return this.domainExtension;
    }

    public void setDomain(DomainExtensionImpl domainExtension) {
        this.domainExtension = domainExtension;
    }

    public String getExtendedDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getDescription() != null) {
            stringBuffer.append("enum ");
            stringBuffer.append(this.getName());
            stringBuffer.append(" description: ");
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(this.getDescription());
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(NEW_LINE);
        }
        if (this.getApplicationTag() != null) {
            stringBuffer.append(APPLICATION_TAG);
            stringBuffer.append(this.getApplicationTag());
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(NEW_LINE);
        }
        stringBuffer.append(DescriptionHelper.getEnumDescription(this));
        return stringBuffer.toString();
    }

    private class EnumComparator
    implements Comparator {
        private EnumComparator() {
        }

        public int compare(Object o1, Object o2) {
            MomEnumMemberImpl member1 = (MomEnumMemberImpl)o1;
            MomEnumMemberImpl member2 = (MomEnumMemberImpl)o2;
            if (member1.getValue() != null && member2.getValue() == null) {
                return -1;
            }
            if (member1.getValue() == null && member2.getValue() != null) {
                return 1;
            }
            if (member1.getValue() == null && member2.getValue() == null) {
                return member1.getName().compareTo(member2.getName());
            }
            if (member1.getValue() < member2.getValue()) {
                return -1;
            }
            if (member1.getValue() > member2.getValue()) {
                return 1;
            }
            return 0;
        }
    }
}

