/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.model;

import java.util.ArrayList;
import java.util.Iterator;
import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.DerivedDataTypeRef;
import se.ericsson.cello.mimparser.MoRef;
import se.ericsson.cello.mimparser.MomCorbaTypeAttribute;
import se.ericsson.cello.mimparser.MomEntity;
import se.ericsson.cello.mimparser.MomEnumRef;
import se.ericsson.cello.mimparser.MomSequence;
import se.ericsson.cello.mimparser.MomStructRef;
import se.ericsson.cello.mimparser.model.MimModelImpl;
import se.ericsson.cello.mimparser.model.MomBase;
import se.ericsson.cello.mimparser.model.MomEntityResolvable;
import se.ericsson.cello.mimparser.state.DefaultSettable;

public class MomSequenceImpl
extends MomBase
implements MomSequence,
MomEntityResolvable,
DefaultSettable {
    private static final String TRUE = "true";
    private static final String SPACE = " ";
    private static final String NEWLINE = "\n";
    private static final String DATA_TYPE = "dataType: ";
    private static final String FALSE = "false";
    private static final String NON_UNIQUE = "nonUnique: ";
    private static final String MAX_LENGTH = "maxLength: ";
    private static final String MIN_LENGTH = "minLength: ";
    private static final String ARRAY_BRACKETS = "[]";
    private static final String NEW_LINE = "\n";
    private static final String DEFAULT_VALUES = "defaultValues: ";
    private static final String ORDERED = "ordered: ";
    private int length = -1;
    private int maxLength = -1;
    private int minLength = -1;
    private String maxLengthRawData;
    private String minLengthRawData;
    private boolean areElementsUnique = true;
    private boolean isOrdered;
    private MomEntity type;
    private ArrayList seqDefaultValue = new ArrayList();
    private String seqName;
    private static final String NULL = "null";
    private static final String EMPTY_STRING = "";

    public MomSequenceImpl(String xmlType, Attributes attributes, MimModelImpl model, int id) {
        super(xmlType, attributes, model, id);
    }

    public void setSeqName(String seqName) {
        this.seqName = seqName;
    }

    public int getLength() {
        return this.length;
    }

    public String getSeqName() {
        return this.seqName;
    }

    public void setLength(String length) {
        this.length = this.convertToInt(length);
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public String getMaxLengthRawData() {
        return this.maxLengthRawData;
    }

    public void setMaxLength(String maxLength) {
        this.maxLengthRawData = maxLength;
        this.maxLength = this.convertToInt(maxLength);
    }

    public int getMinLength() {
        return this.minLength;
    }

    public String getMinLengthRawData() {
        return this.minLengthRawData;
    }

    public void setMinLength(String minLength) {
        this.minLengthRawData = minLength;
        this.minLength = this.convertToInt(minLength);
    }

    public boolean areElementsUnique() {
        return this.areElementsUnique;
    }

    public void setAreElementsUnique(boolean areUnique) {
        this.areElementsUnique = areUnique;
    }

    public boolean isOrdered() {
        return this.isOrdered;
    }

    public void setIsOrdered() {
        this.isOrdered = true;
    }

    public MomEntity getType() {
        return this.type;
    }

    public void setType(MomEntity type) {
        this.type = type;
    }

    public void setResolvedEntity(MomEntity resolved) {
        this.setType(resolved);
    }

    private int convertToInt(String value) {
        try {
            int convertedValue = Integer.parseInt(value);
            return convertedValue;
        }
        catch (Exception exc) {
            String errMsg = "MomSequenceImpl.convertToInt()  Can not convert String to int for element:" + this.seqName + " String=" + value + "  Exception=" + exc.toString();
            this.getModel().addToWarningList(errMsg);
            return -1;
        }
    }

    public Iterator getDefaultValues() {
        return this.seqDefaultValue.iterator();
    }

    void addDefaultValue(Object value) {
        this.seqDefaultValue.add(value);
    }

    public void setDefault(String defaultValue) {
        this.addDefaultValue(defaultValue);
    }

    public String getExtendedDescription() {
        MomEntity entity;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getMaxLength() != -1) {
            stringBuffer.append(MAX_LENGTH + this.getMaxLength() + "\n");
        }
        if (this.getMinLength() != -1) {
            stringBuffer.append(MIN_LENGTH + this.getMinLength() + "\n");
        }
        if (this.areElementsUnique()) {
            stringBuffer.append("nonUnique: false\n");
        }
        if (this.isOrdered()) {
            stringBuffer.append("ordered: true\n");
        } else {
            stringBuffer.append("nonUnique: true\n");
        }
        String defaultValues = this.appendDefaultValues(this);
        if (!defaultValues.equalsIgnoreCase(NULL) && !defaultValues.equalsIgnoreCase(EMPTY_STRING)) {
            stringBuffer.append(DEFAULT_VALUES + defaultValues + "\n");
        }
        if ((entity = this.getType()) instanceof MomCorbaTypeAttribute) {
            MomCorbaTypeAttribute momCorbaTypeAttribute = (MomCorbaTypeAttribute)entity;
            stringBuffer.append(momCorbaTypeAttribute.getExtendedDescription());
        }
        return stringBuffer.toString();
    }

    public String getTypeInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        MomEntity entity = this.getType();
        if (entity instanceof MomCorbaTypeAttribute) {
            stringBuffer.append(entity.getXmlType() + ARRAY_BRACKETS);
        } else if (entity instanceof MoRef) {
            stringBuffer.append(entity.getXmlType() + SPACE + entity.getName() + "\n");
        } else if (entity instanceof MomEnumRef) {
            stringBuffer.append(entity.getXmlType() + SPACE + entity.getName() + "\n");
        } else if (entity instanceof MomStructRef) {
            stringBuffer.append(entity.getXmlType() + SPACE + entity.getName() + "\n");
        } else if (entity instanceof DerivedDataTypeRef) {
            DerivedDataTypeRef dataTypeRef = (DerivedDataTypeRef)entity;
            stringBuffer.append(dataTypeRef.getXmlType() + SPACE + entity.getName() + "\n");
        } else {
            stringBuffer.append(entity.getName());
        }
        return stringBuffer.toString();
    }
}

