/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.DomainExtension;
import se.ericsson.cello.mimparser.MomStruct;
import se.ericsson.cello.mimparser.MomStructMember;
import se.ericsson.cello.mimparser.model.DomainExtensionImpl;
import se.ericsson.cello.mimparser.model.MimModelImpl;
import se.ericsson.cello.mimparser.model.MomBase;
import se.ericsson.cello.mimparser.model.MomStructMemberImpl;
import se.ericsson.cello.mimparser.parser.MomParser;

public class MomStructImpl
extends MomBase
implements MomStruct {
    private static final String NEW_LINE = "\n";
    private static final String STRUCT_MEMBER = "structMember: ";
    private static final String LEFT_CURLY = "{";
    private static final String APPLICATION_TAG = "applicationTag: ";
    private static final String DESCRIPTION = "description: ";
    private Map structs = new HashMap();
    private DomainExtension domainExtension;

    public MomStructImpl(String xmlType, Attributes attributes, MimModelImpl model, int id) {
        super(xmlType, attributes, model, id);
    }

    public void addMember(String name, MomStructMemberImpl structMember) {
        this.structs.put(name, structMember);
    }

    public Iterator getMembers() {
        return this.structs.values().iterator();
    }

    public DomainExtension getDomain() {
        return this.domainExtension;
    }

    public void setDomain(DomainExtensionImpl domainExtension) {
        this.domainExtension = domainExtension;
    }

    public String getDescription() {
        if (this.description == null && this.getModel().getContentLevel() == 2) {
            HashMap<Integer, MomBase> momBases = new HashMap<Integer, MomBase>(0);
            if (this.getModel().getCacheSize() > this.structs.size()) {
                Iterator iter = this.getMembers();
                while (iter.hasNext()) {
                    MomBase element = (MomBase)iter.next();
                    momBases.put(new Integer(element.getId()), element);
                }
            }
            MomParser.reParseMomBase(this, momBases);
        }
        return this.description;
    }

    public String getExtendedDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getDescription() != null) {
            stringBuffer.append("description: \n" + this.getDescription() + NEW_LINE + NEW_LINE);
        }
        if (this.getApplicationTag() != null) {
            stringBuffer.append(APPLICATION_TAG + this.getApplicationTag() + NEW_LINE);
        }
        stringBuffer.append(STRUCT_MEMBER + this.getTypeInfo() + NEW_LINE);
        return stringBuffer.toString();
    }

    public String getTypeInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LEFT_CURLY);
        Iterator iter = this.getMembers();
        while (iter.hasNext()) {
            MomStructMember momStructMember = (MomStructMember)iter.next();
            if (iter.hasNext()) {
                stringBuffer.append(momStructMember.getTypeInfo() + ", ");
                continue;
            }
            stringBuffer.append(momStructMember.getTypeInfo());
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

