/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.parser;

import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.mimparser.model.MimModelImpl;
import se.ericsson.cello.mimparser.model.MomBase;

public class ParseInfo {
    private MimModelImpl mimModel;
    private int contentLevel;
    private MomBase momBase;
    private int idCounter;
    private boolean reparsingFinished = true;
    private Map momBases = new HashMap(0);

    public ParseInfo(int contentLevel, MimModelImpl mimModel) {
        this.contentLevel = contentLevel;
        this.mimModel = mimModel;
    }

    public ParseInfo(int contentLevel, MimModelImpl mimModel, MomBase momBase) {
        this(contentLevel, mimModel);
        this.momBase = momBase;
    }

    public ParseInfo(int contentLevel, MimModelImpl mimModel, MomBase mb, Map momBases) {
        this(contentLevel, mimModel, mb);
        this.momBases = momBases;
    }

    public int getNextId() {
        return this.idCounter++;
    }

    public int getCurrentId() {
        return this.idCounter;
    }

    public boolean shouldSetDescription() {
        boolean shouldSetDescription = true;
        if (this.contentLevel != 1) {
            shouldSetDescription = false;
        }
        return shouldSetDescription;
    }

    public boolean isReparse() {
        return this.momBase != null;
    }

    public void setReparsedDescription(int id, String description) {
        if (this.isReparse()) {
            MomBase mb;
            if (id == this.momBase.getId()) {
                this.momBase.setDescription(description);
                this.momBase.getModel().addparsedDescription(this.momBase);
            }
            if ((mb = (MomBase)this.momBases.get(new Integer(id))) != null) {
                mb.setDescription(description);
                mb.getModel().addparsedDescription(this.momBase);
                this.momBases.remove(mb);
            }
            if (this.momBases.isEmpty()) {
                this.reparsingFinished = true;
            }
        }
    }

    public boolean shouldParsingContinue() {
        boolean shouldContinue = true;
        if (this.isReparse() && this.reparsingFinished) {
            shouldContinue = false;
        }
        return shouldContinue;
    }

    public MimModelImpl getMimModel() {
        return this.mimModel;
    }
}

