/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.state;

import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.model.MomActionImpl;
import se.ericsson.cello.mimparser.model.MomAttributeImpl;
import se.ericsson.cello.mimparser.model.MomClassImpl;
import se.ericsson.cello.mimparser.state.ActionState;
import se.ericsson.cello.mimparser.state.AttributeState;
import se.ericsson.cello.mimparser.state.DeprecatedState;
import se.ericsson.cello.mimparser.state.LockBeforeDeleteState;
import se.ericsson.cello.mimparser.state.MomBaseState;
import se.ericsson.cello.mimparser.state.NotificationTypesState;
import se.ericsson.cello.mimparser.state.TransactionConstraintState;
import se.ericsson.cello.mimparser.statemachine.StateMachine;

class ClassState
extends MomBaseState {
    private MomClassImpl momClass;
    public static final String CLASS_TAG = "class";

    public ClassState(MomClassImpl momClass) {
        super(CLASS_TAG);
        this.momClass = momClass;
    }

    public void startElement(StateMachine stateMachine, String name, Attributes attributes) {
        super.startElement(stateMachine, name, this.momClass);
        if (name.equals("attribute")) {
            MomAttributeImpl moAttributeObject = new MomAttributeImpl(name, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.momClass.addAttribute(moAttributeObject.getName(), moAttributeObject);
            stateMachine.pushState(new AttributeState(moAttributeObject));
        } else if (name.equals("action")) {
            MomActionImpl moActionObject = new MomActionImpl(name, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.momClass.addAction(moActionObject.getName(), moActionObject);
            stateMachine.pushState(new ActionState(moActionObject));
        } else if (name.equals("notificationTypes")) {
            stateMachine.pushState(new NotificationTypesState(this.momClass));
        } else if (name.equals("transactionConstraint")) {
            stateMachine.pushState(new TransactionConstraintState(this.momClass));
        } else if (name.equals("systemCreated")) {
            this.momClass.setSystemCreated();
        } else if (name.equals("deprecated")) {
            stateMachine.pushState(new DeprecatedState(this.momClass));
        } else if (name.equals("lockBeforeDelete")) {
            stateMachine.pushState(new LockBeforeDeleteState(this.momClass));
        } else if (name.equals("nonPersistent")) {
            this.momClass.setNonPersistent();
        } else if (name.equals("transactionRequired")) {
            this.momClass.setTransactionRequired();
        }
    }
}

