/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.enrollment;

import se.ericsson.cello.ipsec.mom.StructIpSecEnrollmentData;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.security.cppsec.esa.IpSecInstallationException;
import se.ericsson.security.cppsec.esa.NodeIpSecHandler;
import se.ericsson.security.cppsec.esa.NodeIpSecHandlerFactory;
import se.ericsson.security.cppsec.esa.enrollment.CertEnrollerImpl;
import se.ericsson.security.cppsec.esa.enrollment.CertEnrollmentException;
import se.ericsson.security.cppsec.esa.logger.EsaMessageSender;
import se.ericsson.security.cppsec.esa.logger.EsaReportLogger;
import se.ericsson.security.cppsec.esa.model.IpSecEnrollmentData;
import se.ericsson.security.cppsec.esa.wrapper.EsaConstantsFactory;

public class IpSecCertEnrollerImpl
extends CertEnrollerImpl {
    private IpSecEnrollmentData enrollData = null;
    NodeIpSecHandler nodeIpSecHandler = null;
    private final EsaMessageSender messageSender;

    public IpSecCertEnrollerImpl(EsaMessageSender esaMessageSender) {
        super(esaMessageSender);
        this.messageSender = esaMessageSender;
        this.nodeIpSecHandler = NodeIpSecHandlerFactory.getNodeIpSecHandler(esaMessageSender);
    }

    public void enroll() throws CertEnrollmentException {
        if (this.enrollData != null && this.integrationCode != null) {
            int n = this.enrollData.getKeyLength();
            int n2 = this.enrollData.getSubjectAltNameType();
            this.messageSender.sendMessage("Initiating certificate enrollment.");
            EsaReportLogger.getInstance().logMessage("IPSEC:Initiating certificate enrollment.");
            Struct struct = null;
            try {
                if (this.enrollData.getEnrollmentMode() == 0 || this.enrollData.getEnrollmentMode() == 2) {
                    this.createEnrollmentOtp(this.enrollData.getDataChallengePassword());
                }
                struct = StructIpSecEnrollmentData.createStruct((String)this.enrollData.getCAFingerprint(), (int)n, (int)n2, (String)this.enrollData.getSubjectAltName(), (String)this.enrollmentOtp, (String)this.enrollData.getDistinguishedName(), (String)this.enrollData.getEnrollmentServerURL(), (int)this.enrollData.getEnrollmentMode(), (String)this.enrollData.getCertificateAuthorityDn());
                if (!this.nodeIpSecHandler.validCertificateExists() || this.overwriteCurrentEnrollmentData(this.enrollmentOtp, EsaConstantsFactory.getEsaConstants().getEsaIpsecStateFilePath())) {
                    this.isEnrolling = true;
                    this.nodeIpSecHandler.initiateCertificateEnrollment(struct);
                }
                this.reportLogger.logMessage("IPSEC: IpSec certificate already exists. No new enrollment initiated");
            }
            catch (IpSecInstallationException ipSecInstallationException) {
                throw new CertEnrollmentException("Action InitCertEnrollment failed.", ipSecInstallationException);
            }
        } else {
            throw new CertEnrollmentException("The CertEnroller instance is not initiated");
        }
        this.messageSender.sendMessage("Initiated certificate enrollment.");
        EsaReportLogger.getInstance().logMessage("IPSEC:Initiated certificate enrollment.");
    }

    public void waitForCertEnrollment() throws CertEnrollmentException {
        if (this.isEnrolling) {
            try {
                this.nodeIpSecHandler.waitForCertEnrollment(this.enrollData.getEnrollmentTimeLimit());
            }
            catch (IpSecInstallationException ipSecInstallationException) {
                throw new CertEnrollmentException(ipSecInstallationException);
            }
            this.esaDataVerification.writeIpsecStateFile(this.enrollmentOtp);
            this.enrollmentOtp = null;
            this.messageSender.sendMessage("Certificate enrollment is completed.");
            EsaReportLogger.getInstance().logMessage("IPSEC:Certificate enrollment is completed.");
            this.isEnrolling = false;
        }
    }

    public void setEnrollmentData(IpSecEnrollmentData ipSecEnrollmentData) {
        this.enrollData = ipSecEnrollmentData;
    }
}

