/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.logger;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import se.ericsson.security.cppsec.esa.wrapper.EsaConstantsFactory;
import se.ericsson.security.cppsec.esa.wrapper.MessageLogWrapper;
import se.ericsson.security.cppsec.esa.wrapper.MessageLogWrapperFactory;

public class EsaReportLogger {
    private static EsaReportLogger instance = null;
    private final String NEW_LINE = System.getProperty("line.separator");
    private final MessageLogWrapper logger = MessageLogWrapperFactory.getLogger(this.getClass());
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.ENGLISH);
    private boolean safeLogging = false;
    private static OutputStreamWriter outputStreamWriter = null;

    private EsaReportLogger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EsaReportLogger getInstance() {
        Class clazz = EsaReportLogger.class;
        synchronized (clazz) {
            if (instance == null) {
                instance = new EsaReportLogger();
            }
        }
        return instance;
    }

    public synchronized void logMessage(String string) {
        this.logger.trace(2, "logMessage(message) - " + string);
        try {
            this.getOutputStream();
            outputStreamWriter.write(this.getTimeStamp() + ": " + string + this.NEW_LINE);
            if (this.safeLogging) {
                this.closeLog();
            }
        }
        catch (Exception exception) {
            this.logger.traceError("Could not write to log file due to exception: " + exception.getClass().getName() + ", message: " + exception.getMessage());
        }
    }

    public synchronized void logMessage(String string, Exception exception) {
        this.logger.traceError(string, exception);
        try {
            this.getOutputStream();
            outputStreamWriter.write(this.getTimeStamp() + ": " + string + this.NEW_LINE);
            exception.printStackTrace(new PrintWriter(outputStreamWriter));
            if (this.safeLogging) {
                this.closeLog();
            }
        }
        catch (Exception exception2) {
            this.logger.traceError("Could not write to log file due to exception: " + exception2.getClass().getName() + ", message: " + exception2.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getOutputStream() throws FileNotFoundException, UnsupportedEncodingException {
        Class clazz = EsaReportLogger.class;
        synchronized (clazz) {
            if (outputStreamWriter == null) {
                File file = new File(EsaConstantsFactory.getEsaConstants().getEsaResultFilePath());
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file, true));
                outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, "UTF8");
            }
        }
    }

    protected String getTimeStamp() {
        Date date = new Date();
        return this.sdf.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeLog() {
        Class clazz = EsaReportLogger.class;
        synchronized (clazz) {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                    outputStreamWriter = null;
                }
                catch (IOException iOException) {
                    this.logger.traceError("Unable to close outputstream for esa report", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSafeLogging(boolean bl) {
        Class clazz = EsaReportLogger.class;
        synchronized (clazz) {
            this.safeLogging = bl;
        }
    }
}

