/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.model.elements;

import org.xml.sax.Attributes;
import se.ericsson.security.cppsec.esa.SecurityActivationInputException;
import se.ericsson.security.cppsec.esa.model.Level2Data;
import se.ericsson.security.cppsec.esa.model.Level3Data;
import se.ericsson.security.cppsec.esa.model.SecurityData;
import se.ericsson.security.cppsec.esa.model.elements.FileTransferClientElement;
import se.ericsson.security.cppsec.esa.model.elements.Level2DataElement;
import se.ericsson.security.cppsec.esa.model.elements.Level3DataElement;
import se.ericsson.security.cppsec.esa.model.elements.TelnetAndFtpServersElement;
import se.ericsson.security.cppsec.esa.parser.StackElement;

public class SecurityElement
extends StackElement
implements SecurityData {
    private static final String USER_LABEL = "userLabel";
    private static final String MINIMUM_SECURITY_LEVEL = "minimumSecurityLevel";
    private static final String WANTED_SECURITY_LEVEL = "wantedSecurityLevel";
    public static final String SECURITY = "security";
    private String wantedSecurityLevel;
    private String minimumSecurityLevel;
    private String userLabel;
    private String fileTransferClientValue;
    private String telnetAndFtpServersValue;
    private FileTransferClientElement fileTransferClient = null;
    private TelnetAndFtpServersElement telnetAndFtpServers = null;
    private Level2DataElement level2Data = null;
    private Level3DataElement level3Data = null;

    protected void fetchAttributes(Attributes attributes) throws SecurityActivationInputException {
        this.wantedSecurityLevel = super.getRequiredAttribute(attributes, WANTED_SECURITY_LEVEL);
        this.minimumSecurityLevel = super.getOptionalAttribute(attributes, MINIMUM_SECURITY_LEVEL, this.wantedSecurityLevel);
        this.userLabel = super.getOptionalAttribute(attributes, USER_LABEL, "");
        this.validateAttributes();
    }

    protected void validateAttributes() throws SecurityActivationInputException {
        int n;
        try {
            n = Integer.parseInt(this.wantedSecurityLevel);
            if (n < 1 || n > 3) {
                throw new SecurityActivationInputException("The Security attribute wantedSecurityLevel invalid value - " + this.wantedSecurityLevel);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new SecurityActivationInputException("The Security attribute wantedSecurityLevel invalid value - " + this.wantedSecurityLevel, numberFormatException);
        }
        try {
            n = Integer.parseInt(this.minimumSecurityLevel);
            int n2 = Integer.parseInt(this.wantedSecurityLevel);
            if (n > n2) {
                throw new SecurityActivationInputException("The Security attribute minimumSecurityLevel invalid value - " + this.minimumSecurityLevel);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new SecurityActivationInputException("The Security attribute minimumSecurityLevel invalid value - " + this.minimumSecurityLevel, numberFormatException);
        }
    }

    protected StackElement createElement(String string, String string2, String string3, Attributes attributes) {
        StackElement stackElement = null;
        if ("fileTransferClient".equalsIgnoreCase(string2)) {
            this.fileTransferClient = stackElement = new FileTransferClientElement();
        } else if ("telnetAndFtpServers".equalsIgnoreCase(string2)) {
            stackElement = new TelnetAndFtpServersElement();
            this.telnetAndFtpServers = (TelnetAndFtpServersElement)stackElement;
        } else if ("level2".equalsIgnoreCase(string2)) {
            stackElement = new Level2DataElement();
            this.level2Data = (Level2DataElement)stackElement;
        } else if ("level3".equalsIgnoreCase(string2)) {
            stackElement = new Level3DataElement();
            this.level3Data = (Level3DataElement)stackElement;
        }
        return stackElement;
    }

    public void checkConsistency() throws SecurityActivationInputException {
        int n = Integer.valueOf(this.wantedSecurityLevel);
        if (n >= 2) {
            if (this.level2Data == null) {
                throw new SecurityActivationInputException("The Security element is not consistent - it must contain the Level2 element");
            }
            this.level2Data.checkConsistency();
            if (n == 3) {
                if (this.level3Data == null) {
                    throw new SecurityActivationInputException("The Security element is not consistent - it must contain the Level3 element");
                }
                this.level3Data.checkConsistency();
            }
        }
        if (!this.telnetAndFtpServersValue.equalsIgnoreCase("secure") && !this.telnetAndFtpServersValue.equalsIgnoreCase("unsecure")) {
            throw new SecurityActivationInputException("The TelnetAndFtpServers value is invalid");
        }
        if (!this.fileTransferClientValue.equalsIgnoreCase("secure") && !this.fileTransferClientValue.equalsIgnoreCase("unsecure")) {
            throw new SecurityActivationInputException("The FileTransferClientValue value is invalid");
        }
    }

    public void endElement() {
        this.telnetAndFtpServersValue = this.telnetAndFtpServers != null ? this.telnetAndFtpServers.value : ("3".equals(this.wantedSecurityLevel) ? "secure" : "unsecure");
        this.fileTransferClientValue = this.fileTransferClient != null ? this.fileTransferClient.value : "secure";
    }

    public String getFileTransferClient() {
        return this.fileTransferClientValue;
    }

    public Integer getMinimumSecurityLevel() {
        return Integer.valueOf(this.minimumSecurityLevel);
    }

    public String getTelnetandFtpServers() {
        return this.telnetAndFtpServersValue;
    }

    public String getUserLabel() {
        return this.userLabel;
    }

    public Integer getWantedSecurityLevel() {
        return Integer.valueOf(this.wantedSecurityLevel);
    }

    public Level2Data getLevel2Data() {
        return this.level2Data;
    }

    public Level3Data getLevel3Data() {
        return this.level3Data;
    }
}

