/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.cmaaue.to;

import java.lang.reflect.Method;
import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.collector.DataCollectorAction;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;

public class CreateIcmpChildAction
implements DataCollectorAction {
    private static final String ICMP = "Icmp";

    public void perform(CollectorContext collectorContext, Coordinator coordinator, String string) throws AueException {
        MoIterator moIterator;
        if (this.isIpv6Configured(collectorContext) && (moIterator = this.findIpSystemMos(collectorContext)) != null) {
            ManagedObject managedObject = null;
            while (moIterator.hasMoreElements()) {
                managedObject = moIterator.nextMo();
                if (this.hasIcmpChild(managedObject)) continue;
                this.createIcmpChild(managedObject, collectorContext, coordinator);
            }
        }
    }

    private boolean isIpv6Configured(CollectorContext collectorContext) {
        MoIterator moIterator = collectorContext.getMoAccessor().lookupType("Ipv6");
        return moIterator != null && moIterator.size() > 0;
    }

    private void createIcmpChild(ManagedObject managedObject, CollectorContext collectorContext, Coordinator coordinator) throws AueException {
        MoFactory moFactory = collectorContext.getMoAccessor().lookupMoFactory(ICMP);
        Method method = null;
        try {
            method = moFactory.getClass().getMethod("autoCreateMo", ManagedObject.class, String.class, Coordinator.class);
            method.invoke((Object)moFactory, managedObject, "1", coordinator);
        }
        catch (Exception exception) {
            throw new AueException("Unable to call IcmpFactory.autoCreateMo()", (Throwable)exception);
        }
    }

    private boolean hasIcmpChild(ManagedObject managedObject) {
        MoIterator moIterator = managedObject.getChildren();
        if (moIterator != null) {
            ManagedObject managedObject2 = null;
            while (moIterator.hasMoreElements()) {
                managedObject2 = moIterator.nextMo();
                if (!managedObject2.getType().equals(ICMP)) continue;
                return true;
            }
        }
        return false;
    }

    private MoIterator findIpSystemMos(CollectorContext collectorContext) {
        return collectorContext.getMoAccessor().lookupType("IpSystem");
    }
}

