/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.common.fropxy;

import enea.ose.system.InSignal;
import java.util.Hashtable;
import se.ericsson.cello.common.fropxy.FroEventInd;
import se.ericsson.cello.common.fropxy.FroFaultCeasedInd;
import se.ericsson.cello.common.fropxy.FroFaultInd;
import se.ericsson.cello.common.fropxy.FroLockInd;
import se.ericsson.cello.common.fropxy.FroSignalInterface;
import se.ericsson.cello.common.fropxy.MoAlarmable;
import se.ericsson.cello.common.fropxy.MoEventable;
import se.ericsson.cello.common.fropxy.MoNotifiable;
import se.ericsson.cello.mao.AlarmHandler;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.support.debug.MessageLog;

public class FroSignalHandling {
    public static void run(InSignal inSignal, Hashtable hashtable, Class clazz) {
        try {
            ManagedObject managedObject = null;
            int n = ((FroSignalInterface)inSignal).getFroId();
            managedObject = (ManagedObject)hashtable.get(new Integer(n));
            if (managedObject == null) {
                MessageLog.info((Class)clazz, (String)("Mo with froid=" + n + " could not be found in subscriptions"));
                return;
            }
            if (inSignal instanceof FroFaultInd) {
                if (managedObject instanceof MoAlarmable) {
                    ((MoAlarmable)managedObject).alarmRaised((FroFaultInd)inSignal, clazz.getName());
                } else {
                    AlarmHandler.addNonGenericAlarm((FroFaultInd)inSignal, clazz.getName(), managedObject);
                }
            } else if (inSignal instanceof FroFaultCeasedInd) {
                if (managedObject instanceof MoAlarmable) {
                    ((MoAlarmable)managedObject).alarmCeased((FroFaultCeasedInd)inSignal, clazz.getName());
                } else {
                    FroFaultCeasedInd froFaultCeasedInd = (FroFaultCeasedInd)inSignal;
                    AlarmHandler.clearNonGenericAlarm(froFaultCeasedInd.getSpecificProblem(), froFaultCeasedInd.getSignalNumber(), managedObject);
                }
            } else if (inSignal instanceof FroLockInd) {
                ((MoNotifiable)managedObject).parameterChanged((FroLockInd)inSignal, clazz.getName());
            } else if (inSignal instanceof FroEventInd) {
                ((MoEventable)managedObject).eventRaised((FroEventInd)inSignal, clazz.getName());
            } else {
                MessageLog.info((Class)clazz, (String)("In signal's type is not recongnized " + inSignal.getClass()));
            }
        }
        catch (Exception exception) {
            MessageLog.traceError((Class)clazz, (String)"RuntimeError", (Throwable)exception);
        }
        catch (Error error) {
            MessageLog.traceError((Class)clazz, (String)"RuntimeError", (Throwable)error);
        }
    }
}

