/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipsec;

import se.ericsson.cello.ipsec.IpSecMo;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.ValueOutOfRangeException;

public class StructHelper {
    public static Struct[] convertCertListParam2Struct(ArrayParameter arrayParameter) throws MoAccessException {
        if (arrayParameter != null) {
            Struct[] structArray = new Struct[arrayParameter.size()];
            for (int i = 0; i < arrayParameter.size(); ++i) {
                StructParameter structParameter = (StructParameter)arrayParameter.get(i);
                structArray[i] = StructHelper.convertCertInfo2Struct(structParameter);
            }
            return structArray;
        }
        return null;
    }

    public static Struct convertCertInfo2Struct(StructParameter structParameter) {
        if (structParameter != null) {
            Object[] objectArray = new Object[]{((StringParameter)structParameter.get("issuer")).getValue(), ((StringParameter)structParameter.get("notValidAfter")).getValue(), ((StringParameter)structParameter.get("notValidBefore")).getValue(), ((StringParameter)structParameter.get("serialNumber")).getValue(), ((StringParameter)structParameter.get("subject")).getValue(), ((StringParameter)structParameter.get("fingerprint")).getValue(), ((StringParameter)structParameter.get("subjectAltName")).getValue()};
            StructImpl structImpl = new StructImpl(IpSecMo.CERT_INFO_ELEMENT_NAMES, objectArray);
            return structImpl;
        }
        return null;
    }

    public static void checkIntegrityAlgorithm(String string, String string2, SetRequestContext setRequestContext) throws MoAccessException {
        int n;
        int n2;
        Struct struct;
        int n3;
        Struct[] structArray = (Struct[])setRequestContext.getAttributeFromRequest(string);
        if (string2.equals("IkePeer") || string2.equals("PeerIpSecProfile") && string.equals("allowedIkeSaTransform")) {
            for (n3 = 0; n3 < structArray.length; ++n3) {
                struct = structArray[n3];
                n2 = (Integer)struct.getValue("encryptionAlgorithm");
                n = (Integer)struct.getValue("integrityAlgorithm");
                if (n == 4 && n2 != 4 && n2 != 5) {
                    throw new ValueOutOfRangeException(string, string2, " AES_GCM is not allowed for struct attribute integrityAlgorithm in " + string2 + " MO as encryption algorithm is not AES_GCM.");
                }
                if (n2 != 4 && n2 != 5 || n == 4) continue;
                throw new ValueOutOfRangeException(string, string2, " AES_GCM is not allowed for struct attribute encryptionAlgorithm in " + string2 + " MO as integrity algorithm is not AES_GCM.");
            }
        }
        if (string2.equals("IpSecTunnel") || string2.equals("PeerIpSecProfile") && string.equals("allowedChildSaTransform")) {
            for (n3 = 0; n3 < structArray.length; ++n3) {
                struct = structArray[n3];
                n2 = (Integer)struct.getValue("encryptionAlgorithm");
                n = (Integer)struct.getValue("integrityAlgorithm");
                if (n == 5 && n2 != 4 && n2 != 5) {
                    throw new ValueOutOfRangeException(string, string2, "AES_GCM is not allowed for struct attribute integrityAlgorithm in " + string2 + " MO as encryption algorithm is not AES_GCM.");
                }
                if (n2 != 4 && n2 != 5 || n == 5) continue;
                throw new ValueOutOfRangeException(string, string2, " AES_GCM is not allowed for struct attribute encryptionAlgorithm in " + string2 + " MO as integrity algorithm is not AES_GCM.");
            }
        }
    }
}

