/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.gui.view;

import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.gui.treetable.TreeTableModelAdapter;
import se.ericsson.cello.nex.gui.view.MoTreeTableModel;
import se.ericsson.cello.nex.gui.view.NexTreeNode;
import se.ericsson.cello.nex.viewservices.ViewI;
import se.ericsson.security.launcher.emnotification.EmEventInterface;
import se.ericsson.security.launcher.emnotification.EmNotificationListenerInterface;

public class MoDeleteListener
implements EmNotificationListenerInterface {
    private MoTreeTableModel model = null;
    private TreeTableModelAdapter modelAdapter = null;
    private EmEventInterface myEvent = null;
    private static int nListener = 0;
    private String myListenerId = "";
    private static final String UP_DELETED_NOTIFICATION = "se.ericsson.cello.emas.sm.UP_DELETED";
    ViewI myView;

    public MoDeleteListener(MoTreeTableModel aModel, TreeTableModelAdapter aModelAdapter, ViewI aView) {
        this.model = aModel;
        this.modelAdapter = aModelAdapter;
        this.myView = aView;
        this.myListenerId = "" + ++nListener;
        NexLog.logger().info("MoDeleteListener created. Id: " + nListener);
    }

    public void notificationFromEM(EmEventInterface event) {
        this.myEvent = event;
        String type = this.myEvent.getType();
        if (type.equals("se.ericsson.cello.nex.MO_DELETED") || type.equals(UP_DELETED_NOTIFICATION)) {
            if (this.model == null || this.modelAdapter == null) {
                NexLog.logger().fine("Can not update GUI for deleting MOs. Model is not set.");
            } else {
                this.updateDeletedNode();
                this.myView.selectRootMo(false);
            }
        }
    }

    public EmEventInterface getMyEvent() {
        return this.myEvent;
    }

    private void updateDeletedNode() {
        Object theLdns = this.myEvent.getUserData();
        String[] deletedNodeLdns = null;
        if (theLdns instanceof String[]) {
            deletedNodeLdns = (String[])theLdns;
        } else if (theLdns instanceof String) {
            deletedNodeLdns = new String[]{(String)theLdns};
        } else {
            deletedNodeLdns = null;
            NexLog.logger().info("Can not handle user object when updating the deleted node.");
        }
        if (deletedNodeLdns == null) {
            return;
        }
        NexTreeNode node = null;
        String aLdn = null;
        for (int i = 0; i < deletedNodeLdns.length; ++i) {
            aLdn = deletedNodeLdns[i];
            node = this.model.findNode(aLdn);
            if (node == null) continue;
            this.model.removeNodeFromParent(node);
        }
        this.modelAdapter.fireTableDataChanged();
        NexLog.logger().info("Mo Tree is updated by MoDeleteListener Id:" + this.myListenerId);
    }
}

