/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.gui.view;

import java.awt.Container;
import java.util.Collection;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import se.ericsson.cello.nex.gui.OwnerFrameI;
import se.ericsson.cello.nex.viewservices.model.ViewElementI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NexTreeNode
extends DefaultMutableTreeNode
implements Comparable<NexTreeNode> {
    private static final long serialVersionUID = 9015537541950491539L;
    protected OwnerFrameI ownerFrame;
    private volatile boolean childrenFetched = false;
    private NexTreeNode[] path_array = null;
    private String shortName;
    private String prefix;
    private String description = null;
    private boolean partiallyExpanded = false;
    private Collection<String> tableAttributes = null;

    public NexTreeNode(ViewElementI aViewElementI, boolean childrenAllowed, OwnerFrameI anOwner) {
        super(aViewElementI);
        this.allowsChildren = childrenAllowed;
        this.shortName = this.getViewElement().getName();
        this.constructPrefix();
        this.children = new Vector();
        this.ownerFrame = anOwner;
    }

    public NexTreeNode() {
    }

    public String getToolTip() {
        if (this.partiallyExpanded) {
            return "<html><pre> Only partially expanded. <br> To see all MOs below: <br> collapse and expand again, or <br> use Expand Below. </pre></html>";
        }
        return this.getLongName();
    }

    public abstract Container getPropertiesContainer();

    public abstract Object getValueAt(String var1);

    public boolean isFolder() {
        return false;
    }

    @Override
    public boolean isLeaf() {
        return !this.allowsChildren;
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public NexTreeNode getChildAt(int index) {
        return (NexTreeNode)this.children.elementAt(index);
    }

    public void refresh(final String[] attributes) {
        if (SwingUtilities.isEventDispatchThread()) {
            Runnable runner = new Runnable(){

                public void run() {
                    NexTreeNode.this.refresh(attributes);
                }
            };
            new Thread(runner).start();
            return;
        }
        this.refreshHasChildren();
        this.getViewElement().refreshAttributes(attributes);
    }

    public void refreshAttributes(final String[] attributes) {
        if (SwingUtilities.isEventDispatchThread()) {
            Runnable runner = new Runnable(){

                public void run() {
                    NexTreeNode.this.refreshAttributes(attributes);
                }
            };
            new Thread(runner).start();
            return;
        }
        this.getViewElement().refreshAttributes(attributes);
    }

    public void refreshHasChildren() {
        if (SwingUtilities.isEventDispatchThread()) {
            Runnable runner = new Runnable(){

                public void run() {
                    NexTreeNode.this.refreshHasChildren();
                }
            };
            new Thread(runner).start();
            return;
        }
        this.allowsChildren = this.getViewElement().refreshHasChildren();
    }

    @Override
    public int compareTo(NexTreeNode o) {
        return this.getName().compareTo(o.toString());
    }

    public void setPartiallyExpanded(boolean b) {
        this.partiallyExpanded = b;
    }

    public boolean isPartiallyExpanded() {
        return this.partiallyExpanded;
    }

    public void allChildrenFetched() {
        this.partiallyExpanded = false;
        this.childrenFetched = true;
    }

    public boolean hasFetchedChildren() {
        return this.childrenFetched;
    }

    public void setChildrenFetched(boolean fetched) {
        this.childrenFetched = fetched;
    }

    public String getDescription() {
        if (null == this.description) {
            this.description = this.getViewElement().getDescription();
        }
        return this.description;
    }

    public abstract String getLongName();

    public String getName() {
        return this.shortName;
    }

    public ViewElementI getViewElement() {
        return (ViewElementI)this.userObject;
    }

    @Override
    public String toString() {
        String aName = this.getName();
        if (this.ownerFrame.showTreeNodePrefix()) {
            return this.prefix + aName;
        }
        return aName;
    }

    @Override
    public TreeNode[] getPath() {
        Object[] retArr;
        if (this.path_array == null) {
            Vector<NexTreeNode> path = new Vector<NexTreeNode>();
            path = this.getPathToTop(path);
            this.path_array = new NexTreeNode[path.size()];
            retArr = new NexTreeNode[path.size()];
            path.copyInto(this.path_array);
            path.copyInto(retArr);
        } else {
            retArr = new NexTreeNode[this.path_array.length];
            System.arraycopy(this.path_array, 0, retArr, 0, this.path_array.length);
        }
        return retArr;
    }

    public boolean isRootNode() {
        return false;
    }

    public Collection<String> getTableAttributes() {
        if (null == this.tableAttributes) {
            this.tableAttributes = this.getViewElement().getDefinedTableAttributes();
        }
        return this.tableAttributes;
    }

    private Vector<NexTreeNode> getPathToTop(Vector<NexTreeNode> path) {
        if (this.parent != null) {
            ((NexTreeNode)this.parent).getPathToTop(path).addElement(this);
        } else {
            path.addElement(this);
        }
        return path;
    }

    private void constructPrefix() {
        ViewElementI.ViewElementType type = this.getViewElement().getType();
        if (type.equals((Object)ViewElementI.ViewElementType.CHILD)) {
            this.prefix = "(Child) ";
        } else if (type.equals((Object)ViewElementI.ViewElementType.CONTAINMENT)) {
            this.prefix = "(Child) ";
        } else if (type.equals((Object)ViewElementI.ViewElementType.PARENT)) {
            this.prefix = "(Parent) ";
        } else if (type.equals((Object)ViewElementI.ViewElementType.REFERENCE)) {
            this.prefix = "(Ref. " + this.getViewElement().getReferencingAttribute() + ") ";
        } else if (type.equals((Object)ViewElementI.ViewElementType.MO)) {
            this.prefix = "";
        } else if (type.equals((Object)ViewElementI.ViewElementType.FOLDER)) {
            this.prefix = "";
        }
    }
}

